/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.IntHashMap;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;

public final class JavaImplOverPlugin
implements EditorPlugin,
JavaParserPlugin.HelperClient,
GutterColumnListener {
    private static final String PLUGIN_KEY = JavaImplOverPlugin.class.getName();
    public static final String COLUMN_NAME = "implements-overrides-column";
    private static final ImplOverItem[] EMPTY_ITEMS = new ImplOverItem[0];
    private BasicEditorPane editor;
    private GutterColumn column;
    private List itemList = null;
    private UpdaterTask updTask = null;
    private static AsyncScheduler updScheduler = new AsyncScheduler("ImplementsOverrideGutterUpdater", 30000);
    private static Icon IMPLEMENTS_ICON = null;
    private static Icon OVERRIDES_ICON = null;

    @Override
    public void notifyCompileScheduled() {
        this.cancelUpdater();
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.scheduleUpdater(javaManager, sourceFile);
    }

    public static ImplOverItem getImplOverItem(BasicEditorPane editor, int line, boolean isImpl) {
        JavaImplOverPlugin plugin = JavaImplOverPlugin.lookupPlugin(editor);
        if (plugin == null) {
            return null;
        }
        ImplOverItem[] items = plugin.findItems(line);
        for (int i = 0; i < items.length; ++i) {
            ImplOverItem item = items[i];
            if (item.isClass || isImpl != item.isImpl) continue;
            return item;
        }
        return null;
    }

    private static JavaImplOverPlugin lookupPlugin(BasicEditorPane editor) {
        return (JavaImplOverPlugin)editor.getProperty(PLUGIN_KEY);
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(PLUGIN_KEY, (Object)this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        this.column = gutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
        this.column.setReservedWidth(Math.max(JavaImplOverPlugin.getImplementsIcon().getIconWidth(), JavaImplOverPlugin.getOverridesIcon().getIconWidth()));
        this.column.setLayoutConstraint("breakpoint", 1);
        JavaParserPlugin.attachHelperClient(editor, this);
    }

    public void deinstall(BasicEditorPane editor) {
        this.cancelUpdater();
        JavaParserPlugin.detachHelperClient(editor, this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        if (gutter != null) {
            gutter.removeGutterColumn(this.column);
        }
        this.column = null;
        editor.putProperty(PLUGIN_KEY, null);
        this.editor = null;
    }

    private void clearGutterColumns() {
        if (this.column != null) {
            this.column.removeAllGutterMarks();
        }
        this.clearItemList();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private Project getProject() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.editor);
        if (context != null) {
            return context.getProject();
        }
        return null;
    }

    private static Icon getImplementsIcon() {
        if (IMPLEMENTS_ICON == null) {
            IMPLEMENTS_ICON = JavaArb.getIcon(31);
        }
        return IMPLEMENTS_ICON;
    }

    private static Icon getOverridesIcon() {
        if (OVERRIDES_ICON == null) {
            OVERRIDES_ICON = JavaArb.getIcon(31);
        }
        return OVERRIDES_ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdater(JavaManager javaManager, SourceFile sourceFile) {
        UpdaterTask task = new UpdaterTask(javaManager, sourceFile);
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.updTask != null) {
                updScheduler.cancelTask((AsyncTask)this.updTask);
            }
            this.updTask = task;
        }
        updScheduler.scheduleTask((AsyncTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUpdater() {
        UpdaterTask pendingTask;
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            pendingTask = this.updTask;
            this.updTask = null;
        }
        if (pendingTask != null) {
            updScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdater(UpdaterTask task) {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.updTask == task) {
                this.updTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setItemList(List itemList) {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            this.itemList = itemList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearItemList() {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            this.itemList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImplOverItem[] findItems(int line) {
        ArrayList<ImplOverItem> resultList = null;
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.itemList != null) {
                int size = this.itemList.size();
                for (int i = 0; i < size; ++i) {
                    ImplOverItem item = (ImplOverItem)this.itemList.get(i);
                    boolean addItem = false;
                    if (item.mark != null) {
                        int markLine = item.mark.getLine();
                        if (markLine == line) {
                            addItem = true;
                        }
                    } else if (item.line == line) {
                        addItem = true;
                    }
                    if (!addItem) continue;
                    if (resultList == null) {
                        resultList = new ArrayList<ImplOverItem>();
                    }
                    resultList.add(item);
                }
            }
        }
        if (resultList == null) {
            return EMPTY_ITEMS;
        }
        return resultList.toArray(new ImplOverItem[resultList.size()]);
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        Object data = gutterMark.getUserData();
        if (data instanceof ImplOverItem) {
            ((ImplOverItem)data).gotoImplOverItem();
        }
    }

    public String getMarkToolTip(GutterMark mark, MouseEvent event) {
        Object data = mark.getUserData();
        if (data != null && (data instanceof List || data instanceof ImplOverItem)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            if (data instanceof List) {
                List list = (List)data;
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        buffer.append("<br>");
                    }
                    ImplOverItem item = (ImplOverItem)list.get(i);
                    buffer.append(this.getMarkToolTip(item));
                }
            } else {
                buffer.append(this.getMarkToolTip((ImplOverItem)data));
            }
            buffer.append("</html>");
            return buffer.toString();
        }
        return null;
    }

    protected String getMarkToolTip(ImplOverItem item) {
        int index = item.isClass ? (item.isImpl ? 340 : 342) : (item.isImpl ? 344 : 346);
        return JavaArb.format(index, item.className);
    }

    public final class ImplOverItem {
        private String className;
        private String methodName;
        private String descriptor;
        private GutterMark mark;
        private int offset;
        private int line;
        private boolean isClass;
        private boolean isImpl;
        private Icon icon;

        public ImplOverItem(String className, String methodName, String descriptor, int offset, boolean isImpl, Icon icon) {
            this.className = className;
            this.methodName = methodName;
            this.descriptor = descriptor;
            this.offset = offset;
            this.isClass = descriptor == null;
            this.isImpl = isImpl;
            this.icon = icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gotoImplOverItem() {
            SourceName target = null;
            Node destNode = null;
            JavaManager javaManager = JavaManager.getJavaManager((Project)JavaImplOverPlugin.this.getProject());
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            try {
                cacheSupport.beginCacheUse();
                SourceClass type = javaManager.getSourceClass(this.className);
                if (type == null) {
                    return;
                }
                URL url = type.getOwningSourceFile().getURL();
                if (this.descriptor == null || this.methodName == null) {
                    target = type.getNameElement();
                } else {
                    for (SourceMethod checkMethod : type.getDeclaredMethods()) {
                        String checkDescriptor = checkMethod.getDescriptor();
                        String checkName = checkMethod.getName();
                        if (!this.descriptor.equals(checkDescriptor) || !this.methodName.equals(checkName)) continue;
                        target = checkMethod.getNameElement();
                        break;
                    }
                }
                if (target == null) {
                    return;
                }
                try {
                    destNode = NodeFactory.findOrCreate((URL)url);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
            if (destNode != null) {
                Context context = Context.newIdeContext((Node)destNode);
                NavigationManager navigator = NavigationManager.getNavigationManager();
                int offset = target.getStartOffset();
                int length = target.getEndOffset() - offset;
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, length);
                try {
                    if (navigator != null) {
                        navigator.navigateTo((NavigationPoint)point);
                    } else {
                        point.navigate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        protected String getMarkToolTip() {
            int index = this.isClass ? (this.isImpl ? 340 : 342) : (this.isImpl ? 344 : 346);
            return JavaArb.format(index, this.className);
        }

        public ToggleAction createGotoSourceAction() {
            String name = this.className;
            int dot = name.lastIndexOf(46);
            String className = name.substring(dot + 1);
            String packageName = name.substring(0, Math.max(0, dot));
            String label = className + " (" + packageName + ")";
            ToggleAction action = new ToggleAction(label, this.icon){

                public void actionPerformed(ActionEvent e) {
                    ImplOverItem.this.gotoImplOverItem();
                }
            };
            return action;
        }

        public String toString() {
            String impl = this.isImpl ? "implements" : "overrides";
            return impl + ": " + this.className + ", offset = " + this.offset;
        }
    }

    private final class UpdaterTask
    extends AsyncTask {
        private boolean updCancelled = false;
        private JavaManager updJavaManager;
        private SourceFile updSourceFile;

        private UpdaterTask(JavaManager javaManager, SourceFile sourceFile) {
            this.updJavaManager = javaManager;
            this.updSourceFile = sourceFile;
        }

        protected void requestCancelImpl() {
            this.updCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.updCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() throws AsyncTask.CancelledException {
            try {
                this.bailIfCancelled();
                final ArrayList foundList = new ArrayList();
                Project project = JavaImplOverPlugin.this.getProject();
                if (project == null) {
                    Object var3_3 = null;
                    return var3_3;
                }
                CacheSupport cacheSupport = this.updJavaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    List classes = this.updSourceFile.getSourceClasses();
                    Iterator i = classes.iterator();
                    while (i.hasNext()) {
                        this.bailIfCancelled();
                        this.processClass(this.updJavaManager, (SourceClass)i.next(), foundList);
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                this.bailIfCancelled();
                Runnable gutterSetter = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        if (UpdaterTask.this.isCancelledImpl() || JavaImplOverPlugin.this.column == null) {
                            return;
                        }
                        int numFound = foundList.size();
                        IntHashMap lineItemMap = new IntHashMap();
                        TextBuffer textBuffer = JavaImplOverPlugin.this.getTextBuffer();
                        LineMap lineMap = textBuffer.getLineMap();
                        textBuffer.readLock();
                        try {
                            block3: for (int i = 0; i < numFound; ++i) {
                                ImplOverItem item = (ImplOverItem)foundList.get(i);
                                int offset = item.offset;
                                offset = Math.min(offset, textBuffer.getLength());
                                offset = Math.max(offset, 0);
                                int line = lineMap.getLineFromOffset(offset) + 1;
                                item.line = line;
                                ArrayList<ImplOverItem> lineItemList = (ArrayList<ImplOverItem>)lineItemMap.get(line);
                                if (lineItemList == null) {
                                    lineItemList = new ArrayList<ImplOverItem>();
                                    lineItemMap.put(line, lineItemList);
                                    lineItemList.add(item);
                                    continue;
                                }
                                if (!item.isImpl) {
                                } else {
                                    lineItemList.add(item);
                                    continue;
                                }
                                for (int j = 0; j < lineItemList.size(); ++j) {
                                    if (!((ImplOverItem)lineItemList.get(j)).isImpl) continue;
                                    lineItemList.add(j, item);
                                    continue block3;
                                }
                            }
                        }
                        finally {
                            textBuffer.readUnlock();
                        }
                        JavaImplOverPlugin.this.clearGutterColumns();
                        Iterator i = lineItemMap.iterator();
                        block5: while (true) {
                            if (!i.hasNext()) {
                                JavaImplOverPlugin.this.setItemList(foundList);
                                return;
                            }
                            List list = (List)i.next();
                            ImplOverItem first = (ImplOverItem)list.get(0);
                            int options = 1;
                            Object data = first;
                            if (list.size() > 1) {
                                options |= 0x10000;
                                data = list;
                            }
                            GutterMark mark = JavaImplOverPlugin.this.column.addGutterMark(first.line, first.icon, null, 3000, options);
                            mark.setUserData(data);
                            first.mark = mark;
                            int j = 1;
                            while (true) {
                                if (j >= list.size()) continue block5;
                                ImplOverItem item = (ImplOverItem)list.get(j);
                                item.mark = mark;
                                if (!item.isImpl) {
                                    mark.setIcon(item.icon);
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                };
                SwingUtilities.invokeLater(gutterSetter);
                Object var5_6 = null;
                return var5_6;
            }
            finally {
                JavaImplOverPlugin.this.finishUpdater(this);
                this.updSourceFile = null;
            }
        }

        private void processClass(JavaManager javaManager, SourceClass sourceClass, List foundList) throws AsyncTask.CancelledException {
            if (sourceClass == null) {
                return;
            }
            JavaClass javaLangObject = javaManager.getClass("java.lang.Object");
            Set hierarchy = sourceClass.getHierarchy();
            Iterator i = hierarchy.iterator();
            while (i.hasNext()) {
                this.bailIfCancelled();
                JavaType targetType = (JavaType)i.next();
                if (targetType.equals(javaLangObject)) continue;
                this.addItem((SourceMember)sourceClass, (JavaMember)targetType, foundList);
            }
            Map methodHierarchies = this.collectHierarchy(sourceClass, (JavaProvider)javaManager);
            List methods = sourceClass.getSourceMethods();
            Iterator i2 = methods.iterator();
            while (i2.hasNext()) {
                this.bailIfCancelled();
                this.processMethod(javaManager, methodHierarchies, (SourceMethod)i2.next(), foundList);
            }
            Collection classes = sourceClass.getDeclaredClasses();
            Iterator i3 = classes.iterator();
            while (i3.hasNext()) {
                this.bailIfCancelled();
                this.processClass(javaManager, (SourceClass)i3.next(), foundList);
            }
        }

        private Map collectHierarchy(SourceClass type, JavaProvider provider) throws AsyncTask.CancelledException {
            LinkedHashMap hierarchies = new LinkedHashMap();
            BindingContext context = new BindingContext(provider);
            Iterator i = type.getMethods().iterator();
            while (i.hasNext()) {
                this.bailIfCancelled();
                JavaMethod method = (JavaMethod)i.next();
                if (method.getOwningClass() == type || method.isPrivate() || method.isStatic() || method.isConstructor()) continue;
                context.setContext((JavaIsGeneric)method, (JavaType)type);
                StringBuffer signature = new StringBuffer();
                StringBuffer erasedSignature = new StringBuffer();
                this.signatures(method, signature, erasedSignature, context);
                String signatureText = signature.toString();
                String erasedSignatureText = erasedSignature.toString();
                this.collectHierarchyMethod(hierarchies, signatureText, method);
                if (signatureText.equals(erasedSignatureText)) continue;
                this.collectHierarchyMethod(hierarchies, erasedSignatureText, method);
            }
            return hierarchies;
        }

        private void signatures(JavaMethod method, StringBuffer signature, StringBuffer erasedSignature, BindingContext context) {
            context.appendDescription(method, false, null, null, signature, erasedSignature);
        }

        private void collectHierarchyMethod(Map hierarchies, String signature, JavaMethod method) {
            ArrayList<JavaMethod> list;
            Object hierarchy = hierarchies.get(signature);
            if (hierarchy != null) {
                list = (ArrayList<JavaMethod>)hierarchy;
            } else {
                list = new ArrayList<JavaMethod>(4);
                hierarchies.put(signature, list);
            }
            list.add(method);
        }

        private void processMethod(JavaManager javaManager, Map methodHierarchies, SourceMethod sourceMethod, List foundList) throws AsyncTask.CancelledException {
            StringBuffer signature = new StringBuffer();
            StringBuffer erasedSignature = new StringBuffer();
            BindingContext context = new BindingContext((JavaProvider)javaManager);
            context.setContext((JavaIsGeneric)sourceMethod, (JavaType)sourceMethod.getEnclosingClass());
            this.signatures((JavaMethod)sourceMethod, signature, erasedSignature, context);
            Collection methodHierarchy = (Collection)methodHierarchies.get(signature.toString());
            if (methodHierarchy != null) {
                Iterator i = methodHierarchy.iterator();
                while (i.hasNext()) {
                    this.bailIfCancelled();
                    JavaMethod targetMethod = (JavaMethod)i.next();
                    this.addItem((SourceMember)sourceMethod, (JavaMember)targetMethod, foundList);
                }
            }
            this.processLocalAndAnonymousClasses(javaManager, (SourceElement)sourceMethod.getBlock(), foundList);
        }

        private void processLocalAndAnonymousClasses(JavaManager javaManager, SourceElement element, List foundList) throws AsyncTask.CancelledException {
            if (element == null) {
                return;
            }
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                this.bailIfCancelled();
                SourceElement child = (SourceElement)children.get(i);
                if (child.getSymbolKind() == 3) {
                    this.processClass(javaManager, (SourceClass)child, foundList);
                    continue;
                }
                this.processLocalAndAnonymousClasses(javaManager, child, foundList);
            }
        }

        private void addItem(SourceMember from, JavaMember to, List foundList) {
            JavaType toType;
            JavaMethod toMethod;
            SourceClass fromType;
            SourceMethod fromMethod;
            if (to instanceof JavaType) {
                fromMethod = null;
                fromType = (SourceClass)from;
                toMethod = null;
                toType = (JavaType)to;
            } else {
                fromMethod = (SourceMethod)from;
                fromType = from.getEnclosingClass();
                toMethod = (JavaMethod)to;
                toType = to.getOwningClass();
            }
            this.addResult(fromMethod, fromType, toMethod, toType, foundList);
        }

        private void addResult(SourceMethod sourceMethod, SourceClass sourceType, JavaMethod targetMethod, JavaType targetType, List foundList) {
            boolean isImpl;
            String targetName = targetType.getRawName();
            int sourceOffset = sourceType.getStartOffset();
            SourceName sourceTypeName = sourceType.getNameElement();
            if (sourceTypeName != null) {
                sourceOffset = sourceTypeName.getStartOffset();
            }
            String descriptor = null;
            String methodName = null;
            if (targetMethod != null) {
                sourceOffset = sourceMethod.getStartOffset();
                SourceName sourceName = sourceMethod.getNameElement();
                methodName = sourceMethod.getName();
                if (sourceName != null) {
                    sourceOffset = sourceName.getStartOffset();
                }
                descriptor = targetMethod.getDescriptor();
            }
            boolean bl = isImpl = !sourceType.isInterface() && targetType.isInterface();
            if (sourceOffset != -1) {
                ImplOverItem found = new ImplOverItem(targetName, methodName, descriptor, sourceOffset, isImpl, isImpl ? JavaImplOverPlugin.getImplementsIcon() : JavaImplOverPlugin.getOverridesIcon());
                foundList.add(found);
            }
        }
    }
}

