/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.editing.AbstractEditingPlugin;
import oracle.jdevimpl.java.editing.JavaSmartClipboard;
import oracle.jdevimpl.java.editing.JavaSmartJoin;
import oracle.jdevimpl.javadoc.audit.DocCommenter;

public final class JavaEditingPlugin
extends AbstractEditingPlugin {
    @Override
    protected AbstractLexer getLexer() {
        JavaLexer lexer = new JavaLexer();
        lexer.setSkipComments(false);
        lexer.setRecognizeSQLJ(true);
        return lexer;
    }

    @Override
    protected boolean isEofToken(int token) {
        return token == 0;
    }

    @Override
    protected boolean isSingleLineCommentToken(int token) {
        return token == 24;
    }

    @Override
    protected boolean isMultiLineOrDocCommentToken(int token) {
        return token == 25 || token == 26;
    }

    @Override
    protected boolean isCharacterLiteralToken(int token) {
        return token == 13;
    }

    @Override
    protected boolean isStringLiteralToken(int token) {
        return token == 14;
    }

    @Override
    protected int getRightParenToken() {
        return 72;
    }

    @Override
    protected int getRightBracketToken() {
        return 71;
    }

    @Override
    protected boolean skipCloseParenGeneration(int token) {
        switch (token) {
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 35: 
            case 37: 
            case 40: 
            case 48: 
            case 53: 
            case 55: 
            case 59: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addJavadocCommentsAtOffset() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.getEditorPane());
        DocCommenter.addJavadocComments(null, context);
        DocCommenter.gotoCommentStart(DocCommenter.getMemberAt(context), context);
    }

    @Override
    public void install(BasicEditorPane editor) {
        Toolbar toolbar;
        super.install(editor);
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor != null && (toolbar = codeEditor.getToolbar()) != null) {
            ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
            toolbarManager.installToolbar("JavaCodeEditor.Toolbar", toolbar, (View)codeEditor);
        }
    }

    @Override
    public boolean invokeAction(String actionKey) {
        if (actionKey.equals("cut-to-clipboard") || actionKey.equals("copy-to-clipboard") || actionKey.equals("extended-paste-from-clipboard") || actionKey.equals("paste-from-clipboard")) {
            return JavaSmartClipboard.invokeAction(this.getEditorPane(), actionKey);
        }
        if (actionKey.equals("join-line")) {
            return JavaSmartJoin.smartJoin(this.getEditorPane());
        }
        return super.invokeAction(actionKey);
    }
}

