/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.ceditor.AbstractEditorHoverPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.htmlpopup.ContentProvider;
import oracle.ide.ceditor.htmlpopup.HtmlPopupView;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.browse.JavaBrowseClickPlugin;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.jdevimpl.javadoc.popup.JavadocPopupController;

public class JavaEditorHoverPlugin
extends AbstractEditorHoverPlugin {
    protected boolean installHoverableEditor(BasicEditorPane editor) {
        return CodeEditor.getContext((BasicEditorPane)editor).getNode() instanceof JavaSourceNode;
    }

    protected NumberRange getRectangleOffsets(BasicEditorPane editor, int offset) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor != null) {
            return JavaBrowseClickPlugin.getJavaIdentifierAtOffset(editor, offset);
        }
        return null;
    }

    protected Hover getHover(BasicEditorPane editor, List<HoverFlavor> flavors, int offset, Rectangle rect) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor == null) {
            return null;
        }
        for (HoverFlavor flavor : flavors) {
            SourceElement se;
            JavaBrowseSupport2 browseSupport;
            JavaHasType jhType;
            if (flavor == HoverFlavor.getFlavor((String)"source") && (jhType = (browseSupport = JavaBrowseSupport2.getSingleton()).getBrowseSymbolAtOffset(codeEditor, offset)) != null && jhType.getSourceElement() != null && (se = jhType.getSourceElement()) != null) {
                CodePeek peek = JavaCodePeek.createCodePeek((JComponent)editor, se, rect);
                if (peek != null) {
                    peek.setAutohide(true);
                }
                return peek;
            }
            if (flavor != HoverFlavor.getFlavor((String)"doc") || (jhType = (browseSupport = JavaBrowseSupport2.getSingleton()).getBrowseSymbolAtOffset(codeEditor, offset)) == null || jhType.getSourceElement() == null) continue;
            try {
                ContentProvider contentProvider = JavadocPopupController.getContentProvider(codeEditor.getContext().getProject(), jhType);
                if (contentProvider == null) continue;
                HtmlPopupView view = new HtmlPopupView(contentProvider);
                view.setOpaque(true);
                view.putClientProperty((Object)UIConstants.VETO_CONVERSION, (Object)Boolean.TRUE);
                view.setBackground(UIConstants.getColor((String)"ghost.panel.background", (UIConstants.Look)UIConstants.Look.DARK));
                Peek peek = new Peek((JComponent)editor, (JComponent)view, flavor);
                peek.setRectangle(rect);
                peek.setAutohide(true);
                return peek;
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

