/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.net.URL;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyAddin;
import oracle.jdevimpl.java.browse.BrowseNavigationPoint2;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseContext;
import oracle.jdevimpl.java.browse.JavaBrowseContextImpl;
import oracle.jdevimpl.java.browse.JavaBrowseHelper;
import oracle.jdevimpl.java.util.FoundSymbol;

public class JavaBrowseSupport2
implements BrowseSupport,
JavaConstants {
    private static JavaBrowseSupport2 singleton = null;

    protected JavaBrowseSupport2() {
    }

    static JavaBrowseSupport2 getSingleton() {
        if (singleton == null) {
            singleton = new JavaBrowseSupport2();
        }
        return singleton;
    }

    protected JavaBrowseContext getJavaBrowseContext(CodeEditor editor) {
        return JavaBrowseContextImpl.createContext(editor);
    }

    protected JavaBrowseContext getJavaBrowseContext(Context context, int offset) {
        return JavaBrowseContextImpl.createContext(context, offset);
    }

    protected JavaBrowseHelper getJavaBrowseHelper(CodeEditor editor) {
        JavaBrowseContext browseContext = this.getJavaBrowseContext(editor);
        return new JavaBrowseHelper(browseContext);
    }

    protected JavaBrowseHelper getJavaBrowseHelper(Context context, int offset) {
        JavaBrowseContext browseContext = this.getJavaBrowseContext(context, offset);
        return new JavaBrowseHelper(browseContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canBrowseAtCursor(CodeEditor editor) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(editor);
        helper.acquire();
        try {
            boolean bl = helper.isBrowseable();
            return bl;
        }
        finally {
            helper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBrowseSymbolAtCursor(CodeEditor editor) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(editor);
        helper.acquire();
        try {
            this.performBrowseSymbolImpl(helper);
        }
        finally {
            helper.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBrowseHierarchyAtCursor(CodeEditor editor) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(editor);
        helper.acquire();
        try {
            this.performBrowseHierarchyImpl(helper);
        }
        finally {
            helper.release();
        }
    }

    @Override
    public void performBrowseDocAtCursor(CodeEditor editor) {
        HelpInfo hi = this.getHelpInfoAtCursor(editor);
        if (hi != null) {
            HelpSystem.getHelpSystem().showHelp(hi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelpInfo getHelpInfoAtCursor(CodeEditor editor) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(editor);
        helper.acquire();
        try {
            HelpInfo helpInfo = this.getHelpInfoImpl(helper);
            return helpInfo;
        }
        finally {
            helper.release();
        }
    }

    public static JavaHasType getSymbolAtOffset(CodeEditor editor) {
        JavaBrowseSupport2 support = JavaBrowseSupport2.getSingleton();
        if (support != null) {
            return support.getSymbolAtCursor(editor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaHasType getSymbolAtCursor(CodeEditor editor) {
        JavaBrowseHelper helper = this.getJavaBrowseHelper(editor);
        helper.acquire();
        try {
            FoundSymbol returnSymbol = new FoundSymbol();
            JavaHasType javaHasType = helper.analyze(returnSymbol, true, false);
            return javaHasType;
        }
        finally {
            helper.release();
        }
    }

    public static boolean canBrowseHierarchy() {
        return AddinManager.getAddinManager().getAddin(BrowseHierarchyAddin.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performBrowseSymbolAtOffset(Context context, int cursorOffset) {
        JavaBrowseSupport2 support = JavaBrowseSupport2.getSingleton();
        if (support != null) {
            JavaBrowseHelper helper = support.getJavaBrowseHelper(context, cursorOffset);
            helper.acquire();
            try {
                support.performBrowseSymbolImpl(helper);
            }
            finally {
                helper.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaHasType getBrowseSymbolAtOffset(CodeEditor editor, int offset) {
        Context context = editor.getContext();
        JavaBrowseSupport2 support = JavaBrowseSupport2.getSingleton();
        if (support != null) {
            JavaBrowseHelper helper = support.getJavaBrowseHelper(context, offset);
            helper.acquire();
            try {
                JavaHasType javaHasType = support.getBrowseSymbolImpl(helper);
                return javaHasType;
            }
            finally {
                helper.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performBrowseDocAtOffset(Context context, int cursorOffset) {
        JavaBrowseSupport2 support = JavaBrowseSupport2.getSingleton();
        if (support != null) {
            HelpInfo hi = null;
            JavaBrowseHelper helper = support.getJavaBrowseHelper(context, cursorOffset);
            helper.acquire();
            try {
                hi = support.getHelpInfoImpl(helper);
            }
            finally {
                helper.release();
            }
            if (hi != null) {
                HelpSystem.getHelpSystem().showHelp(hi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performBrowseHierarchyAtOffset(Context context, int cursorOffset) {
        JavaBrowseSupport2 support = JavaBrowseSupport2.getSingleton();
        if (support != null) {
            JavaBrowseHelper helper = support.getJavaBrowseHelper(context, cursorOffset);
            helper.acquire();
            try {
                support.performBrowseHierarchyImpl(helper);
            }
            finally {
                helper.release();
            }
        }
    }

    private static JavaHasType getBrowseableResult(JavaHasType result) {
        int k = result.getElementKind();
        switch (k) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return result;
            }
            case 10: {
                return null;
            }
            case 14: 
            case 16: {
                return result.getResolvedType();
            }
        }
        throw new RuntimeException("getBrowseableResult: " + k);
    }

    private static URL determineGotoURL(JavaHasType result, URL currentUrl) {
        int k = result.getElementKind();
        switch (k) {
            case 7: {
                return currentUrl;
            }
            case 10: {
                return null;
            }
            case 4: 
            case 5: 
            case 8: {
                JavaMember member = (JavaMember)result;
                JavaClass owning = member.getOwningClass();
                SourceClass owningSource = (SourceClass)owning.getSourceElement();
                if (owningSource != null) {
                    return owningSource.getOwningSourceFile().getURL();
                }
                return owning.getURL();
            }
            case 3: {
                JavaType resultType = (JavaType)result;
                SourceClass sourceClass = (SourceClass)result.getSourceElement();
                if (sourceClass != null) {
                    return sourceClass.getOwningSourceFile().getURL();
                }
                return resultType.getURL();
            }
        }
        throw new RuntimeException("determineGotoURL: " + k);
    }

    private static int determineGotoOffset(JavaHasType result) {
        SourceHasName hasName;
        SourceName name;
        SourceElement sourceResult;
        JavaMethod method;
        if (result.getElementKind() == 8 && (method = (JavaMethod)result).isSynthetic() && method.isConstructor()) {
            result = method.getOwningClass();
        }
        if ((sourceResult = result.getSourceElement()) == null) {
            return -1;
        }
        if (sourceResult instanceof SourceHasName && (name = (hasName = (SourceHasName)sourceResult).getNameElement()) != null) {
            return name.getStartOffset();
        }
        return sourceResult.getStartOffset();
    }

    private JavaHasType getBrowseSymbolImpl(JavaBrowseHelper helper) {
        JavaHasType browseable;
        FoundSymbol returnSymbol = new FoundSymbol();
        JavaHasType result = helper.analyze(returnSymbol, false, false);
        while (result != null && (browseable = JavaBrowseSupport2.getBrowseableResult(result)) != result) {
            result = browseable;
        }
        return result;
    }

    private void performBrowseSymbolImpl(JavaBrowseHelper helper) {
        URL currentUrl;
        URL gotoUrl;
        JavaHasType result = this.getBrowseSymbolImpl(helper);
        if (result != null && (gotoUrl = JavaBrowseSupport2.determineGotoURL(result, currentUrl = helper.getURL())) != null) {
            int offset = JavaBrowseSupport2.determineGotoOffset(result);
            if (currentUrl != null && currentUrl.equals(gotoUrl)) {
                this.browseInCurrentFile(helper, offset);
            } else {
                this.browseInOtherFile(gotoUrl, offset, result, helper.getProvider());
            }
        }
    }

    private void performBrowseHierarchyImpl(JavaBrowseHelper helper) {
        FoundSymbol returnSymbol = new FoundSymbol();
        JavaHasType result = helper.analyze(returnSymbol, true, true);
        if (result != null) {
            JavaType browseType = result.getResolvedType();
            if (browseType != null && browseType.getElementKind() == 3) {
                JavaClass browseClass = (JavaClass)browseType;
                String className = browseClass.getQualifiedName();
                Context context = helper.getContext();
                BrowseHierarchyAddin.browseTypeHierarchy(context, className);
                return;
            }
            JavaBrowseSupport2.reportError(371);
        }
    }

    protected HelpInfo getHelpInfoImpl(JavaBrowseHelper helper) {
        HelpInfo helpInfo = null;
        FoundSymbol returnSymbol = new FoundSymbol();
        JavaHasType result = helper.analyze(returnSymbol, true, true);
        if (result != null) {
            JavaType browseType;
            int k = result.getElementKind();
            switch (k) {
                case 3: 
                case 7: 
                case 14: 
                case 16: {
                    browseType = result.getResolvedType();
                    break;
                }
                case 5: 
                case 8: {
                    JavaMember member = (JavaMember)result;
                    browseType = member.getOwningClass();
                    break;
                }
                default: {
                    throw new RuntimeException("performBrowseSymbolImpl: " + k);
                }
            }
            JavaClass browseClass = null;
            if (browseType != null && browseType.getElementKind() == 3) {
                browseClass = (JavaClass)browseType;
            }
            if (browseClass != null) {
                helpInfo = this.helpInfoFor(helper.getContext(), browseClass);
            } else {
                JavaBrowseSupport2.reportError(20);
            }
        }
        return helpInfo;
    }

    protected HelpInfo helpInfoFor(Context context, JavaClass browseClass) {
        try {
            String languageElement = browseClass.getQualifiedName();
            HelpInfo helpInfo = new HelpInfo(languageElement, 1);
            helpInfo.setContext(context);
            return helpInfo;
        }
        catch (Exception e) {
            JavaBrowseSupport2.reportError(20);
            return null;
        }
    }

    protected static void gotoOffset(CodeEditor editor, int offset) {
        NavigationManager mgr = NavigationManager.getNavigationManager();
        LineNavigationPoint point = new LineNavigationPoint(editor.getContext(), offset, false);
        try {
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void browseInCurrentFile(JavaBrowseHelper helper, int offset) {
        CodeEditor editor = helper.getCodeEditor();
        if (editor != null) {
            JavaBrowseSupport2.gotoOffset(editor, offset);
        }
    }

    private void browseInOtherFile(URL url, int offset, JavaHasType result, JavaManager provider) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            Context context = Context.newIdeContext((Node)node);
            Project definingProject = JavaManager.getDefiningProject((Context)context, (URL)url);
            if (definingProject != null) {
                context.setProject(definingProject);
            }
            NavigationManager mgr = NavigationManager.getNavigationManager();
            BrowseNavigationPoint2 point = new BrowseNavigationPoint2(context, offset, result, provider);
            if (mgr != null) {
                mgr.navigateTo((NavigationPoint)point);
            } else {
                point.navigate();
            }
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    protected static void reportError(int errorKey) {
        String errorMessage = JavaArb.getString(errorKey);
        JavaBrowseSupport2.reportError(errorMessage);
    }

    protected static void reportError(String errorMessage) {
        BrowseSymbolDialog.showErrorDialog(errorMessage);
    }
}

