/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyAddin;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;

final class BrowseHierarchyDialog
extends JEWTDialog
implements DocumentListener {
    static void showDialog(Context context) {
        Project project = context.getProject() != null ? context.getProject() : Ide.getDefaultProject();
        BSPanel panel = new BSPanel(project);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_jed_view_type_hierarchy_html");
        JTextField initialComponent = panel.field_browse;
        Document documentToTrack = null;
        if (initialComponent instanceof JTextComponent) {
            documentToTrack = ((JTextComponent)initialComponent).getDocument();
        }
        String title = JavaArb.getString(364);
        IdeMainWindow parent = Ide.getMainWindow();
        try {
            boolean done = false;
            while (!done) {
                final BrowseHierarchyDialog dialog = new BrowseHierarchyDialog((Frame)parent, panel, initialComponent, title);
                ActionListener doubleClicker = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        dialog.dismissDialog(false);
                    }
                };
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                BrowseHandler popupList = BrowseHandler.createClassPackageBrowserPopup(javaManager, panel.field_browse, doubleClicker);
                documentToTrack.addDocumentListener(dialog);
                dialog.updateButtonStatus(documentToTrack);
                panel.selectBrowseText();
                boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
                String selectedClass = popupList.getSelectedItem();
                popupList.dispose();
                documentToTrack.removeDocumentListener(dialog);
                if (!ok) {
                    done = true;
                    continue;
                }
                String className = selectedClass != null ? selectedClass : panel.getBrowseText();
                if (className.length() <= 0) continue;
                done = BrowseHierarchyDialog.performBrowse(context, project, className);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static boolean performBrowse(Context context, Project project, String symbol) {
        if (BrowseSymbolDialog.findSymbol(project, symbol) == null) {
            BrowseHierarchyDialog.showNotFoundError(symbol);
            return false;
        }
        BrowseHierarchyAddin.browseTypeHierarchy(context, symbol);
        return true;
    }

    private static void showNotFoundError(String symbol) {
        String message = JavaArb.format(6, symbol);
        BrowseHierarchyDialog.showErrorDialog(message);
    }

    static void showErrorDialog(String message) {
        String title = JavaArb.getString(4);
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }

    private BrowseHierarchyDialog(Frame parent, Component contents, Component defaultComponent, String title) {
        super(parent, title, 7);
        this.setContent(contents);
        if (defaultComponent != null) {
            this.setInitialFocus(defaultComponent);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtonStatus(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtonStatus(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtonStatus(e);
    }

    private void updateButtonStatus(DocumentEvent e) {
        Document document = e.getDocument();
        this.updateButtonStatus(document);
    }

    private void updateButtonStatus(Document document) {
        boolean enabled = document.getLength() != 0;
        this.setOKButtonEnabled(enabled);
    }

    private static final class BSPanel
    extends JPanel
    implements ActionListener,
    ClassPackageBrowserFilterV2 {
        private Project project;
        private JTextField field_browse;
        private JButton button_browse;

        private BSPanel(Project project) {
            super(new GridBagLayout());
            this.project = project;
            this.initializeUI();
        }

        private void initializeUI() {
            String browseText = JavaArb.getString(7);
            JLabel label_browse = new JLabel();
            PlainDocument browseDocument = new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    String modStr = str.replace('/', '.').replace('\\', '.');
                    super.insertString(offs, modStr, a);
                }
            };
            this.field_browse = new JTextField(browseDocument, "", 0);
            ResourceUtils.resLabel((JLabel)label_browse, (Component)this.field_browse, (String)browseText);
            String buttonText = JavaArb.getString(10);
            this.button_browse = new JButton();
            ResourceUtils.resButton((AbstractButton)this.button_browse, (String)buttonText);
            this.button_browse.addActionListener(this);
            String explainText = JavaArb.getString(8);
            JLabel label_explain = new JLabel(explainText);
            String hintText = JavaArb.getString(9);
            JLabel label_hint = new JLabel(hintText);
            Insets defaultInsets = new Insets(0, 0, 0, 0);
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
            this.add((Component)label_explain, constraints);
            constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)label_browse, constraints);
            constraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)this.field_browse, constraints);
            constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
            this.add((Component)this.button_browse, constraints);
            constraints = new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 5, 0), 0, 0);
            this.add((Component)label_hint, constraints);
        }

        private String getBrowseText() {
            return this.field_browse.getText();
        }

        private void setBrowseText(String browseText) {
            this.field_browse.setText(browseText);
            this.selectBrowseText();
        }

        private void selectBrowseText() {
            this.field_browse.selectAll();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String startText = this.getBrowseText();
            String[] result = ClassPackageBrowserV2.browseClassOrPackage((Component)this.button_browse, this.project, 3, false, this, startText);
            if (result != null && result.length > 0) {
                this.setBrowseText(result[0]);
            }
        }

        @Override
        public boolean acceptPackage(String pkg) {
            return true;
        }

        @Override
        public boolean acceptClass(JavaClass cls) {
            return cls.isSourceElement() || cls.getSourceElement() != null || cls.getSourceElement() == null && cls.getName().indexOf(36) == -1;
        }
    }
}

