/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaOptions;

public final class JavaProjectIndexer
implements Observer {
    private static JavaProjectIndexer _indexer = new JavaProjectIndexer();
    private static AsyncScheduler INDEX_SCHEDULER = new AsyncScheduler("JavaProjectIndex", 5, 1);
    private Set _indexedSet = new HashSet(50);
    private int DISPLAY_DELAY = 6000;
    private int SUBSEQUENT_DELAY = 2000;
    private List<IndexTask> _taskList = new ArrayList<IndexTask>();
    private boolean _trackerRunning = false;

    public static JavaProjectIndexer getJavaProjectIndexer() {
        return _indexer;
    }

    private JavaProjectIndexer() {
    }

    private void projectOpened(Project project) {
        if (project != null && !this.isIndexed(project)) {
            project.attach((Observer)this);
            this.projectChanged(project);
        }
    }

    private void projectChanged(Project project) {
        if (project != null && !this.isMigrating()) {
            this.indexProject(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectClosed(Project project) {
        if (project != null) {
            project.detach((Observer)this);
            List<IndexTask> list = this._taskList;
            synchronized (list) {
                Iterator<IndexTask> iterator = this._taskList.iterator();
                while (iterator.hasNext()) {
                    IndexTask task = iterator.next();
                    if (task.getProject() != project) continue;
                    INDEX_SCHEDULER.cancelTask((AsyncTask)task);
                    iterator.remove();
                }
            }
            this.clearIndexed(project);
        }
    }

    private boolean isMigrating() {
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)WorkspaceMigrator.MIGRATOR_NAME);
        return migrator != null && migrator.getTraversableContext() != null;
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (observed instanceof Project) {
            Project project = (Project)observed;
            if (id == UpdateMessage.OBJECT_RELOADED) {
                this.projectChanged(project);
            } else if (id == UpdateMessage.PROPERTY_SET && (change.containsProperty("classPath") || change.containsProperty("sourcePath"))) {
                this.projectChanged(project);
            }
        }
    }

    void initialize() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent e) {
                JavaProjectIndexer.this.attachToProjects();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
    }

    private void attachToProjects() {
        NodeListener projectListener = new NodeListener(){

            public void nodeOpened(NodeEvent e) {
                if (e.getNode() instanceof Project) {
                    JavaProjectIndexer.this.projectOpened((Project)e.getNode());
                }
            }

            public void nodeClosed(NodeEvent e) {
                if (e.getNode() instanceof Project) {
                    JavaProjectIndexer.this.projectClosed((Project)e.getNode());
                }
            }
        };
        Node.addNodeListenerForType(Project.class, (NodeListener)projectListener);
        AsyncTask task = new AsyncTask(){

            protected Object runImpl() {
                Iterator iterator = NodeFactory.getOpenNodes();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof Project)) continue;
                    JavaProjectIndexer.this.projectOpened((Project)object);
                }
                return null;
            }

            protected void requestCancelImpl() {
            }

            protected boolean isCancelledImpl() {
                return false;
            }
        };
        INDEX_SCHEDULER.scheduleTask(task);
    }

    private void indexProject(Project project) {
        LocatorTask locatorTask = this.locatorIndexProject(project);
        KeywordTask keywordTask = this.keywordIndexProject(project);
        this.trackIndex(locatorTask);
        this.trackIndex(keywordTask);
    }

    private LocatorTask locatorIndexProject(Project project) {
        this.clearIndexed(project);
        LocatorTask task = new LocatorTask(project);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
        return task;
    }

    private KeywordTask keywordIndexProject(Project project) {
        KeywordTask task = new KeywordTask(project);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)task);
        return task;
    }

    private static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            return this._indexedSet.contains(project);
        }
    }

    public boolean waitUntilIndexed(Project project) {
        if (this.isIndexed(project)) {
            return true;
        }
        if (!project.isOpen()) {
            return false;
        }
        this.locatorIndexProject(project);
        while (!this.isIndexed(project)) {
            JavaProjectIndexer.sleep(50);
        }
        return true;
    }

    private void markIndexed(final Project project) {
        project.runUnderReadLock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (project.isOpen()) {
                        JavaProjectIndexer.this._indexedSet.add(project);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            this._indexedSet.remove(project);
        }
    }

    private boolean getShowIndexerDialog() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)settings.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        return javaOptions.getShowIndexerDialog();
    }

    private void setShowIndexerDialog(boolean show) {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)settings.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        javaOptions.setShowIndexerDialog(show);
        settings.putData("JavaEditingOptions", (Copyable)javaOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackIndex(IndexTask task) {
        boolean showDialog = this.getShowIndexerDialog();
        List<IndexTask> list = this._taskList;
        synchronized (list) {
            this._taskList.add(task);
            if (showDialog) {
                this.trackProgress();
            }
        }
    }

    private void trackProgress() {
        if (this._trackerRunning) {
            return;
        }
        this._trackerRunning = true;
        final ProgressDialog dialog = new ProgressDialog();
        final boolean[] bail = new boolean[]{false};
        final Runnable displayRunnable = new Runnable(){

            @Override
            public void run() {
                dialog.pack();
                WizardLauncher.runDialog((JDialog)((Object)dialog));
                boolean show = !dialog.cb_alwaysBackground.isSelected();
                JavaProjectIndexer.this.setShowIndexerDialog(show);
                bail[0] = true;
            }
        };
        Runnable updaterRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(JavaProjectIndexer.access$1200(JavaProjectIndexer.this));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                JavaProjectIndexer.access$1202(JavaProjectIndexer.this, JavaProjectIndexer.access$1300(JavaProjectIndexer.this));
                showing = false;
                block10: while (true) {
                    var3_4 = JavaProjectIndexer.access$400(JavaProjectIndexer.this);
                    synchronized (var3_4) {
                        if (JavaProjectIndexer.access$400(JavaProjectIndexer.this).size() > 0) {
                            task = (IndexTask)JavaProjectIndexer.access$400(JavaProjectIndexer.this).remove(0);
                            if (task.isFinished()) {
                                continue;
                            }
                        } else {
                            JavaProjectIndexer.access$1402(JavaProjectIndexer.this, false);
                            break;
                        }
                    }
                    if (!showing) {
                        showing = true;
                        SwingUtilities.invokeLater(displayRunnable);
                    }
                    while (true) {
                        if (!task.isFinished()) ** break;
                        continue block10;
                        if (bail[0]) {
                            var3_4 = JavaProjectIndexer.access$400(JavaProjectIndexer.this);
                            synchronized (var3_4) {
                                JavaProjectIndexer.access$400(JavaProjectIndexer.this).add(0, task);
                                JavaProjectIndexer.access$1402(JavaProjectIndexer.this, false);
                            }
                            return;
                        }
                        project = task.getProject();
                        if (project != null) {
                            description = task.getStatusBarText(project);
                            progressText = task.getProgressBarTooltipText(project);
                            uiupdaterRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    dialog.label_description.setText(description);
                                    dialog.label_taskProgress.setText(progressText);
                                }
                            };
                            SwingUtilities.invokeLater(uiupdaterRunnable);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {}
                    }
                    break;
                }
                if (showing) {
                    canceluiRunnable = new Runnable(){

                        @Override
                        public void run() {
                            dialog.bail();
                        }
                    };
                    SwingUtilities.invokeLater(canceluiRunnable);
                }
            }
        };
        Thread updater = new Thread(updaterRunnable, "Project Indexer Progress");
        updater.start();
    }

    static /* synthetic */ int access$1200(JavaProjectIndexer x0) {
        return x0.DISPLAY_DELAY;
    }

    static /* synthetic */ int access$1202(JavaProjectIndexer x0, int x1) {
        x0.DISPLAY_DELAY = x1;
        return x0.DISPLAY_DELAY;
    }

    static /* synthetic */ int access$1300(JavaProjectIndexer x0) {
        return x0.SUBSEQUENT_DELAY;
    }

    static /* synthetic */ boolean access$1402(JavaProjectIndexer x0, boolean x1) {
        x0._trackerRunning = x1;
        return x0._trackerRunning;
    }

    private static class ProgressDialog
    extends JEWTDialog {
        private JLabel label_description = new JLabel(JavaArb.getString(373));
        private JProgressBar pb_taskProgress = new JProgressBar(0, 100);
        private JLabel label_taskProgress;
        private JCheckBox cb_alwaysBackground;
        private JPanel panel_progress;

        private void bail() {
            this.dismissDialog(false);
        }

        private ProgressDialog() {
            super((Frame)Ide.getMainWindow(), JavaArb.getString(372), 1);
            this.pb_taskProgress.setIndeterminate(true);
            this.label_taskProgress = new JLabel("");
            this.cb_alwaysBackground = new JCheckBox();
            String alwaysText = JavaArb.getString(375);
            ResourceUtils.resButton((AbstractButton)this.cb_alwaysBackground, (String)alwaysText);
            this.panel_progress = new JPanel(new GridBagLayout());
            Insets defaultInsets = new Insets(2, 5, 2, 5);
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.label_description, constraints);
            constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.pb_taskProgress, constraints);
            constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.label_taskProgress, constraints);
            constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createRigidArea(new Dimension(400, 5)), constraints);
            constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add((Component)this.cb_alwaysBackground, constraints);
            constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createVerticalStrut(1), constraints);
            constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, defaultInsets, 0, 0);
            this.panel_progress.add(Box.createGlue(), constraints);
            this.setContent(this.panel_progress);
            this.setDefaultButton(1);
            String backgroundText = JavaArb.getString(374);
            this.setOKButtonText(StringUtils.stripMnemonic((String)backgroundText));
            this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)backgroundText));
        }
    }

    private class KeywordTask
    extends IndexTask {
        private BackgroundTask task;
        private boolean finished;

        public KeywordTask(Project project) {
            super(project);
        }

        @Override
        protected ProgressTrackedTask getProgressTrackedTask(final Project project) {
            return new ProgressTrackedTask(){

                public boolean isIndeterminate() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int getCurrentValue() {
                    KeywordTask keywordTask = KeywordTask.this;
                    synchronized (keywordTask) {
                        return KeywordTask.this.task != null ? KeywordTask.this.task.getProgress() : 0;
                    }
                }

                public int getMinimum() {
                    return 0;
                }

                public int getMaximum() {
                    return 100;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String getCurrentText() {
                    KeywordTask keywordTask = KeywordTask.this;
                    synchronized (keywordTask) {
                        return KeywordTask.this.task != null ? KeywordTask.this.task.getProgressText() : KeywordTask.this.getProgressBarText(project);
                    }
                }

                public String getTaskDescription() {
                    return KeywordTask.this.getProgressBarTooltipText(project);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    KeywordTask keywordTask = KeywordTask.this;
                    synchronized (keywordTask) {
                        try {
                            while (!KeywordTask.this.finished && !KeywordTask.this.cancelled) {
                                ((Object)((Object)KeywordTask.this)).wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void buildIndex(Project project) {
            IndexManager manager = IndexManager.getIndexManager();
            Index index = manager.getIndex(project);
            try {
                KeywordTask keywordTask = this;
                synchronized (keywordTask) {
                    block21: {
                        if (!this.cancelled) break block21;
                        return;
                    }
                    this.task = index.build();
                }
                try {
                    this.task.get();
                }
                catch (RejectedExecutionException ree) {
                }
                catch (InterruptedException ie) {
                }
                catch (ExecutionException ee) {
                    // empty catch block
                }
            }
            finally {
                index.release();
                KeywordTask keywordTask = this;
                synchronized (keywordTask) {
                    this.finished = true;
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        @Override
        protected String getStatusBarText(Project project) {
            String projectName = project.getShortLabel();
            String statusText = JavaArb.format(378, projectName);
            return statusText;
        }

        @Override
        protected String getProgressBarText(Project project) {
            return JavaArb.getString(379);
        }

        @Override
        protected String getProgressBarTooltipText(Project project) {
            return this.getProgressBarText(project);
        }

        @Override
        protected synchronized void requestCancelImpl() {
            super.requestCancelImpl();
            if (this.task != null) {
                this.task.cancel(true);
            }
        }
    }

    private class LocatorTask
    extends IndexTask {
        private Thread thread;

        public LocatorTask(Project project) {
            super(project);
        }

        @Override
        protected ProgressTrackedTask getProgressTrackedTask(final Project project) {
            return new ProgressTrackedTask(){

                public boolean isIndeterminate() {
                    return true;
                }

                public int getCurrentValue() {
                    return 0;
                }

                public int getMinimum() {
                    return 0;
                }

                public int getMaximum() {
                    return 100;
                }

                public String getCurrentText() {
                    return project != null ? LocatorTask.this.getProgressBarText(project) : "";
                }

                public String getTaskDescription() {
                    return project != null ? LocatorTask.this.getProgressBarTooltipText(project) : "";
                }

                public void run() {
                    while (!LocatorTask.this.isFinished() && !LocatorTask.this.cancelled) {
                        LocatorTask.sleep((int)100);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void buildIndex(final Project project) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!JavaProjectIndexer.this.isIndexed(project)) {
                        JavaManager jm = JavaManager.getJavaManager((Project)project);
                        JavaClassLocator locator = jm.getJavaClassLocator();
                        if (locator instanceof JavaClassLocator2) {
                            try {
                                ((JavaClassLocator2)locator).buildIndexInterruptibly();
                                JavaProjectIndexer.this.markIndexed(project);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            locator.buildIndex();
                            JavaProjectIndexer.this.markIndexed(project);
                        }
                    }
                }
            };
            LocatorTask locatorTask = this;
            synchronized (locatorTask) {
                if (this.cancelled) {
                    return;
                }
                this.thread = new Thread(r, "class-locator-index-" + project.getShortLabel());
                this.thread.start();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        protected String getStatusBarText(Project project) {
            String projectName = project.getShortLabel();
            String statusText = JavaArb.format(376, projectName);
            return statusText;
        }

        @Override
        protected String getProgressBarText(Project project) {
            return JavaArb.getString(377);
        }

        @Override
        protected String getProgressBarTooltipText(Project project) {
            return this.getStatusBarText(project);
        }

        @Override
        protected synchronized void requestCancelImpl() {
            super.requestCancelImpl();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    private abstract class IndexTask
    extends AsyncTask {
        private Project _project;
        protected volatile boolean cancelled;

        public IndexTask(Project project) {
            this._project = project;
        }

        public Project getProject() {
            return this._project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() {
            if (this._project != null && this._project.isOpen()) {
                final ProgressTrackedTask trackedTask = this.getProgressTrackedTask(this._project);
                final ProgressTracker tracker = Ide.getStatusBar().getProgressTracker();
                Runnable addTrackerOnUIThread = new Runnable(){

                    @Override
                    public void run() {
                        tracker.addTask(trackedTask, "BackgroundKeywordIndexer");
                    }
                };
                SwingUtilities.invokeLater(addTrackerOnUIThread);
                String statusText = this.getStatusBarText(this._project);
                if (statusText != null && statusText.length() > 0) {
                    Ide.getStatusBar().setText(statusText);
                }
                try {
                    this.buildIndex(this._project);
                }
                finally {
                    if (statusText != null && statusText.equals(Ide.getStatusBar().getText())) {
                        Ide.getStatusBar().setText("");
                    }
                    List list = JavaProjectIndexer.this._taskList;
                    synchronized (list) {
                        JavaProjectIndexer.this._taskList.remove((Object)this);
                    }
                }
            }
            return Boolean.TRUE;
        }

        protected abstract ProgressTrackedTask getProgressTrackedTask(Project var1);

        protected abstract void buildIndex(Project var1);

        protected abstract String getStatusBarText(Project var1);

        protected abstract String getProgressBarText(Project var1);

        protected abstract String getProgressBarTooltipText(Project var1);

        protected void requestCancelImpl() {
            this.cancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.cancelled;
        }
    }
}

