/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.event.ChangeListener;
import oracle.jdevimpl.deploy.stripe.AbstractModuleIO;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;

class MonitoredOutputStream
extends FilterOutputStream
implements MonitoredStream {
    MonitoredStream.ListenerSupport listenerSupport = new MonitoredStream.ListenerSupport();
    MonitoredStream.StatusSupport status_ = new MonitoredStream.StatusSupport(this.listenerSupport, this);
    boolean dirty_ = false;

    MonitoredOutputStream(OutputStream out) {
        super(out);
        this.status_.setStatus(1);
    }

    MonitoredOutputStream() {
        this(null);
        this.status_.setStatus(0);
    }

    public void setStreamAndStatus(OutputStream out, int status) {
        this.out = out;
        this.status_.setStatus(status);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerSupport.addListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public int getStatus() {
        return this.status_.getStatus();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.write(b);
    }

    @Override
    public void flush() throws IOException {
        if (!this.dirty_) {
            this.dirty_ = true;
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.status_.setStatus(3);
        }
        catch (AbstractModuleIO.CouchedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty_;
    }
}

