/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.logging;

import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.jdevimpl.deploy.logging.DeployLogPageFormatter;
import oracle.jdevimpl.deploy.logging.DeployLogPageHandler;
import oracle.jdevimpl.deploy.logging.DeployLogger;

public class DeployLoggingAddin
implements Addin {
    static Logger deployLogger = null;

    public void initialize() {
        deployLogger = this.getOrCreateDeployLogger();
        if (Ide.getIdeArgs().getCreateUI()) {
            Ide.addIdeListener((IdeListener)new IdeAdapter(){

                public void mainWindowOpened(IdeEvent e) {
                    Ide.removeIdeListener((IdeListener)this);
                    DeployLoggingAddin.this.addLogPageHandler();
                }
            });
        }
    }

    private Logger getOrCreateDeployLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("oracle.jdeveloper.deploy");
        if (logger == null) {
            logger = new DeployLogger();
            logManager.addLogger(logger);
        }
        return logger;
    }

    private void addLogPageHandler() {
        DeployLogPageHandler handler = new DeployLogPageHandler();
        DeployLogPageFormatter formatter = new DeployLogPageFormatter();
        handler.setFormatter(formatter);
        deployLogger.addHandler(handler);
        deployLogger.setUseParentHandlers(false);
    }
}

