/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.logging;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.log.StyledMessage;

public class DeployLogPageFormatter
extends Formatter {
    static final String PROPERTY_DATE_FORMAT = ".dateFormat";
    static final String PROPERTY_PRINT_STACKTRACE = ".printStackTrace";
    static final String VALUE_DEFAULT_DATE_FORMAT = "[hh:mm:ss a] ";
    final DateFormat dateFormat_;
    final boolean printStackTraces_;

    public DeployLogPageFormatter() {
        String className = this.getClass().getName();
        String formatString = System.getProperty(className + PROPERTY_DATE_FORMAT, VALUE_DEFAULT_DATE_FORMAT);
        this.dateFormat_ = new SimpleDateFormat(formatString);
        this.printStackTraces_ = Boolean.getBoolean(className + PROPERTY_PRINT_STACKTRACE);
    }

    public Object getFormattedLine(LogRecord record) {
        return this.formatForLogPage(record, true);
    }

    public Object getFormattedString(LogRecord record) {
        return this.formatForLogPage(record, false);
    }

    private Object formatForLogPage(LogRecord record, boolean carriageReturn) {
        String msg = this.formatMessage(record);
        if (carriageReturn && msg != null && !msg.endsWith("\n")) {
            msg = String.format("%s\n", msg.trim());
        }
        msg = String.format("%s%s", this.dateFormat_.format(new Date()), msg);
        if (this.printStackTraces_ && record.getThrown() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos, true);
            ps.println(msg);
            ps.println("Stack Trace:");
            record.getThrown().printStackTrace(ps);
            msg = baos.toString();
        }
        return this.stylize(msg, record);
    }

    @Override
    public String format(LogRecord record) {
        return this.formatMessage(record);
    }

    public Object stylize(String message, LogRecord record) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (record.getLevel() == Level.SEVERE) {
            StyleConstants.setForeground(attrs, new Color(environOptions.getLogSystemErrColor()));
        } else if (record.getLevel() == Level.WARNING) {
            StyleConstants.setForeground(attrs, new Color(environOptions.getLogSystemOutColor()));
        }
        StyledMessage sm = new StyledMessage((AttributeSet)attrs, message);
        return sm;
    }
}

