/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.jar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.common.CdaPacketPanel;
import oracle.jdevimpl.deploy.common.JScrollingTextArea;
import oracle.jdevimpl.deploy.jar.ArchivePreviewPacket;
import oracle.jdevimpl.deploy.res.JarArb;

public class ArchivePreviewPanel
extends JTabbedPane {
    private final CdaPacketPanel cdaPacketPanel = new CdaPacketPanel();
    private final JScrollingTextArea manifestArea = new JScrollingTextArea();

    public ArchivePreviewPanel() {
        this.addTab(JarArb.getString(95), this.cdaPacketPanel);
        this.addTab(JarArb.getString(96), this.manifestArea);
    }

    private ArchivePreviewPanel(ArchivePreviewPacket previewPacket) {
        this();
        this.load(previewPacket);
    }

    private void load(ArchivePreviewPacket previewPacket) {
        block5: {
            Archive archive = previewPacket.archive;
            if (archive != null) {
                this.cdaPacketPanel.load(archive.getArchiveEntries());
                try {
                    String manifestContent = archive.getManifestAsString();
                    if (manifestContent == null) {
                        this.manifestArea.setText(JarArb.getString(98));
                        break block5;
                    }
                    this.manifestArea.setText(manifestContent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.manifestArea.setText(JarArb.getString(97));
                }
            } else {
                this.cdaPacketPanel.load((Iterator<ArchiveEntry>)null);
                this.manifestArea.setText("");
            }
        }
    }

    public static void showDialog(Component parent, ArchivePreviewPacket previewPacket) {
        ArchivePreviewPanel.showDialog(parent, previewPacket, JarArb.getString(99));
    }

    public static void showDialog(Component parent, ArchivePreviewPacket previewPacket, String title) {
        if (previewPacket == null) {
            return;
        }
        ArchivePreviewPanel panel = new ArchivePreviewPanel(previewPacket);
        Frame frame = IdeUtil.findFrame((Component)parent);
        JEWTDialog dialog = new JEWTDialog(frame, title, 5);
        dialog.setResizable(true);
        dialog.setContent((Component)panel);
        dialog.setPreferredSize(new Dimension(510, 340));
        String okButtonText = JarArb.getString(100);
        dialog.setOKButtonText(StringUtils.stripMnemonic((String)okButtonText));
        dialog.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)okButtonText));
        HelpUtils.setHelpID((JComponent)panel, (String)"f1_deparchivepreview_html");
        WizardLauncher.runDialog((JDialog)dialog);
    }
}

