/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.jar;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.jar.ArchiveEditor;
import oracle.jdevimpl.deploy.res.JarArb;

public class ArchiveOptionsPanel
extends DefaultTraversablePanel
implements GridBagConstants,
ActionListener,
ItemListener,
ListSelectionListener {
    private final JLabel _lblJarOutput = new JLabel();
    private final URLTextField _tfJarOutput = URLTextField.newForSavingFile();
    private final JButton _btnJarOutput = new JButton();
    private final JCheckBox _cbCompressed = new JCheckBox();
    private final JComboBox _cbCompressionLevel = new JComboBox();
    private final JLabel _lblCompressionLevel = new JLabel();
    private final JCheckBox _cbHasManifest = new JCheckBox();
    private final JLabel _lblBrowseClassesForProject = new JLabel();
    private final JComboBox _comboBrowseClassesForProject = new JComboBox();
    private final JLabel _lblMainClass = new JLabel();
    private final JTextField _tfMainClass = new JTextField();
    private BrowseHandler _browseHandler;
    private final JButton _btnMainClassBrowse = new JButton();
    private final JLabel _lblManifests = new JLabel();
    private final JList _listManifests = new JList();
    private final JButton _btnAdd = new JButton();
    private final JButton _btnDelete = new JButton();
    private final Vector _manifests = new Vector();
    private transient URLChooserInit _urlChooserInit;
    private transient Workspace _workspace;
    private transient Project _project;
    private transient Profile _profile;

    public ArchiveOptionsPanel() {
        ResourceUtils.resLabel((JLabel)this._lblJarOutput, (Component)this._tfJarOutput, (String)JarArb.getString(91));
        ResourceUtils.resLabel((JLabel)this._lblBrowseClassesForProject, (Component)this._comboBrowseClassesForProject, (String)JarArb.getString(94));
        ResourceUtils.resLabel((JLabel)this._lblMainClass, (Component)this._tfMainClass, (String)JarArb.getString(80));
        ResourceUtils.resButton((AbstractButton)this._btnMainClassBrowse, (String)JarArb.getString(93));
        this._btnMainClassBrowse.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._cbCompressed, (String)JarArb.getString(81));
        ResourceUtils.resButton((AbstractButton)this._cbHasManifest, (String)JarArb.getString(86));
        ResourceUtils.resLabel((JLabel)this._lblManifests, (Component)this._listManifests, (String)JarArb.getString(87));
        ResourceUtils.resButton((AbstractButton)this._btnAdd, (String)JarArb.getString(88));
        ResourceUtils.resButton((AbstractButton)this._btnDelete, (String)JarArb.getString(89));
        ResourceUtils.resButton((AbstractButton)this._btnJarOutput, (String)JarArb.getString(92));
        ResourceUtils.resLabel((JLabel)this._lblCompressionLevel, (Component)this._cbCompressionLevel, (String)JarArb.getString(82));
        this._tfMainClass.addActionListener(this);
        this._btnJarOutput.addActionListener((ActionListener)this._tfJarOutput);
        this._listManifests.setCellRenderer(new LCR());
        this._listManifests.setSelectionMode(0);
        JScrollPane spManifests = new JScrollPane();
        spManifests.getViewport().add((Component)this._listManifests, null);
        this._cbHasManifest.addItemListener(this);
        this._cbCompressed.addItemListener(this);
        this._listManifests.addListSelectionListener(this);
        this._btnAdd.addActionListener(this);
        this._btnDelete.addActionListener(this);
        this.updateManifestControls();
        this._comboBrowseClassesForProject.addActionListener(this);
        this._comboBrowseClassesForProject.addPopupMenuListener(new ProjectComboLoader());
        this._cbCompressionLevel.addItem(-1);
        for (int i = 1; i <= 9; ++i) {
            this._cbCompressionLevel.addItem(i);
        }
        this._cbCompressionLevel.setEnabled(false);
        this._cbCompressionLevel.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Integer v = (Integer)value;
                if (v == -1) {
                    value = JarArb.getString(83);
                } else if (v == 1) {
                    value = JarArb.getString(84);
                } else if (v == 9) {
                    value = JarArb.getString(85);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        Insets in52555 = new Insets(5, 25, 5, 5);
        int y = 0;
        this.add(this._lblJarOutput, this.gbc(0, y++, 1, 1, 0.0, 0.0, 18, 0, in5555));
        this.add((Component)this._tfJarOutput, this.gbc(0, ++y, 2, 1, 1.0, 0.0, 17, 2, in5555));
        this.add(this._btnJarOutput, this.gbc(2, y, 1, 1, 0.0, 0.0, 17, 2, in5555));
        this._lblJarOutput.setVisible(false);
        this._tfJarOutput.setVisible(false);
        this._btnJarOutput.setVisible(false);
        this.add(this._cbCompressed, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this._lblCompressionLevel, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 13, 0, in52555));
        this.add(this._cbCompressionLevel, this.gbc(1, y, 1, 1, 0.0, 0.0, 17, 2, in5555));
        this.add(this._cbHasManifest, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, in5555));
        this.add(this._lblBrowseClassesForProject, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 13, 0, in52555));
        this.add(this._comboBrowseClassesForProject, this.gbc(1, y, 1, 1, 0.0, 0.0, 17, 2, in5555));
        this.add(this._lblMainClass, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 13, 0, in52555));
        this.add(this._tfMainClass, this.gbc(1, y, 1, 1, 0.0, 0.0, 17, 2, in5555));
        this.add(this._btnMainClassBrowse, this.gbc(2, y, 1, 1, 0.0, 0.0, 17, 2, in5555));
        this.add(this._lblManifests, this.gbc(0, ++y, 3, 1, 0.0, 0.0, 18, 0, in52555));
        this.add(spManifests, this.gbc(0, ++y, 2, 2, 1.0, 1.0, 18, 1, in52555));
        this.add(this._btnAdd, this.gbc(2, y, 1, 1, 0.0, 0.0, 18, 2, in5555));
        this.add(this._btnDelete, this.gbc(2, ++y, 1, 1, 0.0, 0.0, 18, 2, in5555));
        this.setHelpID("f1_depjaropt_html");
    }

    public void onEntry(TraversableContext tc) {
        ArchiveProfile profile = ArchiveEditor.getArchiveProfile((Namespace)tc);
        this._profile = profile;
        if (profile != null) {
            if (profile.getJarURL() != null) {
                this._tfJarOutput.setURL(profile.getJarURL());
            }
            this._lblJarOutput.setVisible(true);
            this._tfJarOutput.setVisible(true);
            this._btnJarOutput.setVisible(true);
            DataContainer container = profile.getDataContainer();
            boolean isAppLevel = container instanceof Workspace;
            this._lblBrowseClassesForProject.setVisible(isAppLevel);
            this._comboBrowseClassesForProject.setVisible(isAppLevel);
        }
        ArchiveOptions opts = ArchiveEditor.getArchiveOptions((Namespace)tc);
        String mainClass = opts.getMainClass();
        this._tfMainClass.setText(mainClass);
        this._cbCompressed.setSelected(opts.isCompressed());
        this._cbCompressionLevel.setSelectedItem(opts.getCompressionLevel());
        this._cbHasManifest.setSelected(opts.getHasManifest());
        this._manifests.clear();
        URL[] addlManifests = opts.getAdditionalManifests();
        if (addlManifests != null) {
            this._manifests.addAll(Arrays.asList(addlManifests));
        }
        this._listManifests.setListData(this._manifests);
        this._urlChooserInit = ArchiveEditor.getURLChooserInit((Namespace)tc);
        final Context context = CommonEditor.getContext((Namespace)tc);
        if (context != null) {
            this._tfJarOutput.setChooserInit(new URLChooserInit(){

                public void initURLChooser(URLChooser urlChooser) {
                    DialogUtil.addShortcutButtons((URLChooser)urlChooser, (Context)context);
                }
            });
            this._workspace = (Workspace)CommonEditor.getWorkspace((Namespace)tc);
            this.setProject(context.getProject());
        } else {
            this.setProject(null);
        }
        this._btnMainClassBrowse.setVisible(this._project != null);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ArchiveProfile profile = ArchiveEditor.getArchiveProfile((Namespace)tc);
        if (profile != null) {
            profile.setJarURL(this._tfJarOutput.getURL());
        }
        ArchiveOptions opts = ArchiveEditor.getArchiveOptions((Namespace)tc);
        String mainClass = this._tfMainClass.getText();
        opts.setMainClass(ModelUtil.hasLength((String)mainClass) ? mainClass : null);
        opts.setCompressed(this._cbCompressed.isSelected());
        if (opts.isCompressed()) {
            opts.setCompressionLevel((Integer)this._cbCompressionLevel.getSelectedItem());
        }
        opts.setHasManifest(this._cbHasManifest.isSelected());
        URL[] addlManifests = this._manifests.toArray(new URL[this._manifests.size()]);
        if (addlManifests == null || addlManifests.length <= 0) {
            opts.setAdditionalManifests(null);
        } else {
            opts.setAdditionalManifests(addlManifests);
        }
    }

    private void setProject(Project project) {
        if (this._browseHandler != null) {
            this._browseHandler.dispose();
            this._browseHandler = null;
        }
        if (project != null) {
            this._project = project;
            this._browseHandler = BrowseHandler.createClassBrowserPopup(JavaManager.getJavaManager((Project)project), this._tfMainClass, this);
            this._browseHandler.setCopyQualifiedClassNameToField(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._btnMainClassBrowse) {
            String className;
            if (this._project != null && (className = ClassPackageBrowserV2.browseClassOrPackage((Component)((Object)this), this._project, 2, new ClassPackageBrowserFilterV2(){

                @Override
                public boolean acceptPackage(String pkg) {
                    return !"java".equals(pkg) && !"javax".equals(pkg) && !"sun".equals(pkg) && !"sunw".equals(pkg) && !"META-INF".equals(pkg);
                }

                @Override
                public boolean acceptClass(JavaClass cls) {
                    return true;
                }
            })) != null) {
                this._tfMainClass.setText(className);
            }
        } else if (source == this._comboBrowseClassesForProject) {
            if (this._profile != null && this._profile.getDataContainer() instanceof Workspace) {
                this.setProject((Project)this._comboBrowseClassesForProject.getSelectedItem());
                this.updateManifestControls();
            }
        } else if (source == this._tfMainClass) {
            String foo = this._browseHandler.getSelectedItem();
            this._tfMainClass.setText(foo);
        } else if (source == this._btnAdd) {
            URL[] urls;
            int result;
            URLChooser urlChooser = DialogUtil.newURLChooser();
            if (this._urlChooserInit != null) {
                this._urlChooserInit.initURLChooser(urlChooser);
            }
            if ((result = urlChooser.showOpenDialog((Component)((Object)this), JarArb.getString(90))) == 0 && (urls = urlChooser.getSelectedURLs()) != null) {
                this._manifests.addAll(Arrays.asList(urls));
                this._listManifests.setListData(this._manifests);
            }
        } else if (source == this._btnDelete) {
            int selected = this._listManifests.getSelectedIndex();
            if (selected >= 0) {
                this._manifests.remove(selected);
            }
            this._listManifests.setListData(this._manifests);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._cbHasManifest) {
            this.updateManifestControls();
        } else if (e.getSource() == this._cbCompressed) {
            this.updateCompressionControls();
        }
    }

    private void updateManifestControls() {
        boolean b = this._cbHasManifest.isSelected();
        this._lblMainClass.setEnabled(b);
        this._tfMainClass.setEnabled(b);
        this._lblBrowseClassesForProject.setEnabled(b);
        this._comboBrowseClassesForProject.setEnabled(b);
        this._btnMainClassBrowse.setVisible(this._project != null);
        this._btnMainClassBrowse.setEnabled(b);
        this._lblManifests.setEnabled(b);
        this._listManifests.setEnabled(b);
        this._btnAdd.setEnabled(b);
        if (b) {
            Object selectedManifest = this._listManifests.getSelectedValue();
            this._btnDelete.setEnabled(selectedManifest != null);
        } else {
            this._btnDelete.setEnabled(false);
        }
    }

    private void updateCompressionControls() {
        this._cbCompressionLevel.setEnabled(this._cbCompressed.isSelected());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selected = this._listManifests.getSelectedValue();
        this._btnDelete.setEnabled(selected != null);
    }

    class ProjectShortLabelComparator
    implements Comparator<Project> {
        ProjectShortLabelComparator() {
        }

        @Override
        public int compare(Project p1, Project p2) {
            return p1.getShortLabel().compareTo(p2.getShortLabel());
        }
    }

    private class ProjectComboLoader
    implements PopupMenuListener {
        private boolean _loaded = false;

        private ProjectComboLoader() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (!this._loaded && ArchiveOptionsPanel.this._workspace != null) {
                this._loaded = true;
                ArrayList list = new ArrayList();
                Iterator workspaceIterator = ArchiveOptionsPanel.this._workspace.getChildren();
                while (workspaceIterator.hasNext()) {
                    Object child = workspaceIterator.next();
                    if (!(child instanceof Project)) continue;
                    list.add(child);
                }
                Project[] projects = list.toArray(new Project[list.size()]);
                Arrays.sort(projects, new ProjectShortLabelComparator());
                for (int i = 0; i < projects.length; ++i) {
                    ArchiveOptionsPanel.this._comboBrowseClassesForProject.addItem(projects[i]);
                }
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private static class LCR
    extends DefaultListCellRenderer {
        private LCR() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String path = URLFileSystem.getPlatformPathName((URL)((URL)value));
            return super.getListCellRendererComponent((JList<?>)list, path, index, isSelected, cellHasFocus);
        }
    }
}

