/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.dt.wizard.spi;

import java.net.URL;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmd;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractDeploySummaryProvider;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.dt.wizard.res.Bundle;

public class DeployToArchiveSummaryProvider
extends AbstractDeploySummaryProvider {
    @Override
    protected boolean shouldCreateFor(Element element, ToolkitContext context, Class classOrIntf) {
        ProfileDeployCmd deployCommand;
        boolean shouldCreateFor = false;
        if (element instanceof ProfileDeployCmd && (deployCommand = (ProfileDeployCmd)element).getProfile() instanceof ArchiveProfile) {
            ArchiveProfile archiveProfile = (ArchiveProfile)deployCommand.getProfile();
            shouldCreateFor = !archiveProfile.showJarSummary() ? archiveProfile.showCustomSummary() : true;
        }
        return shouldCreateFor;
    }

    @Override
    protected TreeNode buildSummary(DeployCommand cmd, TraversableContext tc) {
        assert (cmd instanceof ProfileDeployCmd);
        ProfileDeployCmd pcmd = (ProfileDeployCmd)cmd;
        assert (pcmd.getProfile() instanceof ArchiveProfile);
        ArchiveProfile profile = (ArchiveProfile)pcmd.getProfile();
        return this.createRootNode(profile, cmd, tc);
    }

    protected TreeNode createRootNode(ArchiveProfile profile, DeployCommand cmd, TraversableContext tc) {
        DefaultMutableTreeNode root = null;
        if (profile.showJarSummary()) {
            root = new DefaultMutableTreeNode(this._s("DEPLOY_SUMMARY_ARCHIVE_NODE_TITLE"));
            this.createArchiveDetails(root, profile, cmd, tc);
        }
        DefaultMutableTreeNode customRoot = null;
        if (profile.showCustomSummary() && null != (customRoot = profile.getCustomSummary())) {
            if (null != root) {
                root.add(this.node(customRoot));
            } else {
                root = customRoot;
            }
        }
        return root;
    }

    protected void createArchiveDetails(DefaultMutableTreeNode root, ArchiveProfile profile, DeployCommand cmd, TraversableContext tc) {
        this.createFileUrlNode(root, profile, cmd, tc);
        this.createArchiveOptions(root, profile, cmd, tc);
        this.createFileGroups(root, profile, cmd, tc);
    }

    private void createFileUrlNode(DefaultMutableTreeNode node, ArchiveProfile profile, DeployCommand cmd, TraversableContext tc) {
        URL jarURL = profile.getJarURL();
        String s = String.format(this._s("DEPLOY_SUMMARY_ARCHIVE_OUTPUT_FILE"), URLFileSystem.getPlatformPathName((URL)jarURL));
        node.add(this.node(s));
    }

    private void createArchiveOptions(DefaultMutableTreeNode node, ArchiveProfile profile, DeployCommand cmd, TraversableContext tc) {
        ArchiveOptions options = profile.getArchiveOptions();
        boolean hasManif = options.getHasManifest();
        String s = String.format(this._s("DEPLOY_SUMMARY_ARCHIVE_INCLUDE_MANIFEST"), hasManif ? this._s("DEPLOY_SUMMARY_ARCHIVE_YES") : this._s("DEPLOY_SUMMARY_ARCHIVE_NO"));
        DefaultMutableTreeNode manif = this.node(s);
        node.add(manif);
        if (hasManif) {
            s = String.format(this._s("DEPLOY_SUMMARY_ARCHIVE_MAIN_CLASS"), options.getMainClass() == null ? "" : options.getMainClass());
            manif.add(this.node(s));
        }
        boolean compressed = options.isCompressed();
        s = String.format(this._s("DEPLOY_SUMMARY_ARCHIVE_IS_COMPRESSED"), compressed ? this._s("DEPLOY_SUMMARY_ARCHIVE_YES") : this._s("DEPLOY_SUMMARY_ARCHIVE_NO"));
        DefaultMutableTreeNode compression = this.node(s);
        if (compressed) {
            int level = options.getCompressionLevel();
            String slevel = String.valueOf(level);
            if (level == -1) {
                slevel = this._s("DEPLOY_SUMMARY_COMPRESSION_LEVEL_DEFAULT");
            } else if (level == 1) {
                slevel = this._s("DEPLOY_SUMMARY_COMPRESSION_LEVEL_MINIMUM");
            } else if (level == 9) {
                slevel = this._s("DEPLOY_SUMMARY_COMPRESSION_LEVEL_MAXIMUM");
            }
            s = String.format(this._s("DEPLOY_SUMMARY_COMPRESSION_LEVEL"), slevel);
            compression.add(this.node(s));
        }
        node.add(compression);
    }

    private void createFileGroups(DefaultMutableTreeNode node, ArchiveProfile profile, DeployCommand cmd, TraversableContext tc) {
    }

    @Override
    protected Class getTypeForNarrow() {
        return ArchiveProfile.class;
    }

    private String _s(String key) {
        return Bundle.get(key);
    }
}

