/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.dt.wizard.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Ide;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractDeployWizardPanel;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployAction;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployActionsToolkit;
import oracle.jdevimpl.deploy.dt.wizard.res.Bundle;

public class DeployCommandSelectionPanel
extends AbstractDeployWizardPanel {
    JList lDeployActions_;
    DeployActionsListModel model_;
    JLabel lblSelectionHint_;
    DescriptionScrollPane spdeployActionDesc_;
    DeployActionsToolkit deployActions_;
    DeployCommand cmd_;
    DeployAction action_;

    public DeployCommandSelectionPanel(DeployActionsToolkit deployActions) {
        this.deployActions_ = deployActions;
        this.jbInit();
    }

    protected void jbInit() {
        this.spdeployActionDesc_ = new DescriptionScrollPane();
        this.lblSelectionHint_ = new JLabel();
        this.lDeployActions_ = new JList();
        ResourceUtils.resLabel((JLabel)this.lblSelectionHint_, (Component)this.lDeployActions_, (String)Bundle.get("DEPLOY_COMMANDS_SELECT_ACTION_LABEL"));
        this.lDeployActions_.setModel(this.getListModel());
        this.lDeployActions_.setCellRenderer(new DeployActionRenderer());
        this.lDeployActions_.addListSelectionListener(new DeployActionSelectionListener());
        this.lDeployActions_.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(this.lblSelectionHint_, this.gbc(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 2, 0)));
        this.add(new JScrollPane(this.lDeployActions_), this.gbc(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(10, 0, 2, 0)));
        this.add((Component)this.spdeployActionDesc_, this.gbc(0, 3, 1, 1, 1.0, 1.0, 21, 1, new Insets(10, 0, 2, 0)));
        this.setHelpID("f1_deploydeploymentaction_html");
    }

    public void onEntry(TraversableContext dataContext) {
        this.setTraversableContext(dataContext);
        this.scatter(dataContext);
        this.updateDialogButtons();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.gather(dataContext);
    }

    private ListModel getListModel() {
        if (this.model_ == null) {
            this.model_ = new DeployActionsListModel();
            this.model_.setActions(this.deployActions_);
        }
        return this.model_;
    }

    @Override
    protected void scatter(TraversableContext dataContext) {
        this.action_ = (DeployAction)dataContext.find(DeployAction.class);
        this.cmd_ = (DeployCommand)((Object)dataContext.find(DeployCommand.class));
        int index = this.model_.actions_.indexOf(this.action_);
        index = index < 0 && this.model_.getSize() > 0 ? 0 : index;
        this.lDeployActions_.setSelectedIndex(index);
        this.selectionChanged();
    }

    @Override
    protected void gather(TraversableContext dataContext) {
        super.gather(dataContext);
        dataContext.put(DeployAction.class.getName(), (Object)this.action_);
        dataContext.put(this.action_.getDeployCommandClass().getName(), (Object)this.cmd_);
    }

    protected void selectionChanged() {
        this.action_ = (DeployAction)this.lDeployActions_.getSelectedValue();
        if (this.action_ != null) {
            this.cmd_ = this.action_.getDeployCommand();
            this.spdeployActionDesc_.setText(this.action_.getDescription());
            this.setExitTransition(DeployCommandSelectionPanel.getTransition(this.action_));
        } else {
            this.cmd_ = null;
        }
        this.updateDialogButtons();
    }

    @Override
    protected DeployCommand getDeployCommand() {
        return this.cmd_;
    }

    public static String getTransition(DeployAction action) {
        DeployCommand cmd = action.getDeployCommand();
        String cmdName = Ide.findCmdName((int)cmd.getId());
        return cmdName;
    }

    private class DeployActionSelectionListener
    implements ListSelectionListener {
        private DeployActionSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            DeployCommandSelectionPanel.this.selectionChanged();
        }
    }

    private class DeployActionRenderer
    extends DefaultListCellRenderer {
        private DeployActionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, ((DeployAction)value).getShortLabel(), index, isSelected, cellHasFocus);
        }
    }

    private class DeployActionsListModel
    extends AbstractListModel {
        List<DeployAction> actions_;

        private DeployActionsListModel() {
        }

        private void setActions(DeployActionsToolkit actions) {
            int firstIndex = 0;
            int lastIndex = 0;
            boolean fire = false;
            if (this.actions_ != null) {
                lastIndex = actions.getAllActions().size();
                fire = true;
            }
            this.actions_ = this.sort(actions.getAllActions().values());
            if (fire) {
                this.fireContentsChanged(this, firstIndex, lastIndex);
            }
        }

        private List<DeployAction> sort(Collection<DeployAction> actions) {
            ArrayList<DeployAction> list = new ArrayList<DeployAction>(actions);
            Collections.sort(list, new Comparator<DeployAction>(){

                @Override
                public int compare(DeployAction a, DeployAction b) {
                    return a.getShortLabel().compareTo(b.getShortLabel());
                }
            });
            return list;
        }

        @Override
        public Object getElementAt(int index) {
            return this.actions_.get(index);
        }

        @Override
        public int getSize() {
            return this.actions_.size();
        }
    }
}

