/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;
import oracle.jdevimpl.deploy.common.SelectionRulesPanel;
import oracle.jdevimpl.deploy.common.URLNodeComparator;
import oracle.jdevimpl.deploy.res.CommonArb;

public class SelectionRulesTreePanel
extends DefaultTraversablePanel
implements GridBagConstants,
TreeWillExpandListener,
TreeCellCheckedListener,
ActionListener {
    private final JWrappedLabel _hintText = new JWrappedLabel();
    private final JScrollPane _spFiles = new JScrollPane();
    private final JMutableTreeNode _root = new JMutableTreeNode();
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._root, true);
    private final CustomJTree _dirTree = new CustomJTree((TreeModel)this._treeModel);
    private final URLNodeComparator _urlComparator = new URLNodeComparator();
    private SelectionRules _selectionRules;
    private URLNode _rootURLNode;
    private JButton _expandBtn;
    private JButton _collapseBtn;
    private transient URLPath _contribPath;
    private transient boolean _isLibraryFileGroup;
    private static final String CONTRIB_URLPATH = "contrib-URLPath";

    public SelectionRulesTreePanel() {
        this._hintText.setText(CommonArb.getString(126));
        this._hintText.setForeground(Color.blue);
        this._spFiles.getViewport().add((Component)this._dirTree, null);
        this._dirTree.setRootVisible(false);
        this._dirTree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        this._dirTree.addTreeWillExpandListener((TreeWillExpandListener)this);
        this._dirTree.enableToolTips(true);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.add((Component)this._hintText, this.gbc(0, 0, 2, 1, 1.0, 0.0, 18, 2, in5555));
        this.add(this._spFiles, this.gbc(0, 1, 2, 1, 1.0, 1.0, 18, 1, in5555));
        this.setHelpID("f1_depfgpkgfilefilter_html");
        String text = CommonArb.getString(128);
        this._expandBtn = new JButton(StringUtils.stripMnemonic((String)text));
        this._expandBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._expandBtn.addActionListener(this);
        this.add(this._expandBtn, this.gbc(0, 2, 1, 1, 1.0, 0.0, 10, 0, in5555));
        text = CommonArb.getString(129);
        this._collapseBtn = new JButton(StringUtils.stripMnemonic((String)text));
        this._collapseBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._collapseBtn.addActionListener(this);
        this.add(this._collapseBtn, this.gbc(1, 2, 1, 1, 1.0, 0.0, 10, 0, in5555));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(final TraversableContext tc) {
        Profile profile = CommonEditor.getProfile((Namespace)tc);
        Object container = profile == null ? (Project)CommonEditor.getProject((Namespace)tc) : profile.getDataContainer();
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                this.updateHintTextVisibility(pfg);
                this._selectionRules = pfg.getFilters();
                this._contribPath = FileGroupsEditor.getContribPath(pfg, container);
                this.finishOnEntry(tc, fg);
                break;
            }
            case 3: {
                this._hintText.setVisible(false);
                final LibraryFileGroup lfg = (LibraryFileGroup)fg;
                this._selectionRules = lfg.getFilters();
                LibraryToolkitHelper libraryToolkitHelper = CommonEditor.getLibraryToolkitHelper((Namespace)tc);
                synchronized (libraryToolkitHelper) {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), CommonArb.getString(138));
                    progressMonitor.setMillisToPopup(1000);
                    progressMonitor.setCancellable(true);
                    progressMonitor.setCloseOnFinish(true);
                    progressMonitor.start();
                    SwingWorker swingWorker = new SwingWorker((DataContainer)container, profile, progressMonitor, fg){
                        final /* synthetic */ DataContainer val$container;
                        final /* synthetic */ Profile val$profile;
                        final /* synthetic */ IndeterminateProgressMonitor val$progressMonitor;
                        final /* synthetic */ FileGroup val$fg;
                        {
                            this.val$container = dataContainer;
                            this.val$profile = profile;
                            this.val$progressMonitor = indeterminateProgressMonitor;
                            this.val$fg = fileGroup;
                        }

                        public Object construct() {
                            SelectionRulesTreePanel.this._contribPath = FileGroupsEditor.getContribPath(CommonEditor.getLibraryToolkitHelper((Namespace)tc), lfg, this.val$container, this.val$profile, this.val$progressMonitor);
                            return null;
                        }

                        public void finished() {
                            this.val$progressMonitor.close();
                            SelectionRulesTreePanel.this.finishOnEntry(tc, this.val$fg);
                        }
                    };
                    swingWorker.start();
                    break;
                }
            }
            default: {
                SelectionRulesPanel.dumpUnknownFileGroupTypeException(fg);
                this._selectionRules = new SelectionRules();
                this._contribPath = new URLPath();
                this.finishOnEntry(tc, fg);
            }
        }
    }

    private void finishOnEntry(TraversableContext tc, FileGroup fg) {
        URL[] contribs = this._contribPath.getEntries();
        Arrays.sort(contribs, new URLParentSorter());
        this._contribPath = new URLPath(contribs);
        URLPath contribPath = (URLPath)tc.find(CONTRIB_URLPATH);
        if (this._contribPath != null && ModelUtil.areEqual((Object)this._contribPath, (Object)contribPath)) {
            this.updateCheckedStates(this._rootURLNode);
            return;
        }
        tc.put(CONTRIB_URLPATH, (Object)this._contribPath);
        this._isLibraryFileGroup = fg.type() == 3;
        this._rootURLNode = new URLNode();
        this._root.removeAllChildren();
        this._root.add((MutableTreeNode)((Object)this._rootURLNode));
        this._treeModel.nodeStructureChanged((TreeNode)this._root);
        this._dirTree.expandAllRows();
        this.updateCheckedStates(this._rootURLNode);
        IdeUtil.expandTreeToDepth((JTree)this._dirTree, (int)3);
    }

    public void onExit(TraversableContext tc) {
        FileGroup fg = FileGroupsEditor.getFileGroup((Namespace)tc);
        switch (fg.type()) {
            case 1: {
                PackagingFileGroup pfg = (PackagingFileGroup)fg;
                pfg.setFilters(this._selectionRules);
                break;
            }
            case 3: {
                LibraryFileGroup lfg = (LibraryFileGroup)fg;
                lfg.setFilters(this._selectionRules);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this._expandBtn)) {
            this._dirTree.expandAllRows();
        } else if (evt.getSource().equals(this._collapseBtn)) {
            for (int i = this._dirTree.getRowCount() - 1; i >= 0; --i) {
                this._dirTree.collapseRow(i);
            }
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath tp = e.getPath();
        URLNode node = (URLNode)((Object)tp.getLastPathComponent());
        node.maybeLoad();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.handleCheck(e, false);
    }

    private void handleCheck(TreeCellCheckedEvent e, boolean isInclude) {
        URLNode node = (URLNode)((Object)e.getSource());
        String name = node.isRootPath() ? "**" : this.toRelativePath(node.getURL());
        if (name != null) {
            if (this._selectionRules == null) {
                this._selectionRules = new SelectionRules();
            }
            if (isInclude) {
                this._selectionRules.addInclude(name, true);
            } else {
                this._selectionRules.addExclude(name, true);
            }
        }
    }

    private void updateHintTextVisibility(PackagingFileGroup pfg) {
        Contributor[] contributors = pfg.getContributors();
        if (contributors != null) {
            for (Contributor contrib : contributors) {
                if (contrib == null || contrib.getType() != 2) continue;
                this._hintText.setVisible(true);
                return;
            }
        }
        this._hintText.setVisible(false);
    }

    private void updateCheckedStates(URLNode node) {
        URL url = node.getURL();
        if (node.isLeaf()) {
            node.getModel().setCheckBoxState(this.isSelected(node._path));
            return;
        }
        if (node.isLoaded()) {
            Enumeration en = node.children();
            while (en.hasMoreElements()) {
                URLNode childNode = (URLNode)((Object)en.nextElement());
                if (childNode == null) continue;
                this.updateCheckedStates(childNode);
            }
            node.updateNodes();
        } else {
            TriStateBoolean checkBoxState = TriStateBoolean.FALSE;
            if (this._selectionRules != null) {
                checkBoxState = this._selectionRules.inferFromRules(this._contribPath.toRelativePath(url), true);
            }
            node.getModel().setCheckBoxState(checkBoxState);
        }
    }

    private String toRelativePath(URL url) {
        if (this._isLibraryFileGroup) {
            return this._contribPath.contains(url) ? URLFileSystem.getFileName((URL)url) : this._contribPath.toRelativePath(url);
        }
        return this._contribPath.toRelativePath(url);
    }

    private boolean isSelected(String relPath) {
        return this._selectionRules != null ? this._selectionRules.isIncluded(relPath) : false;
    }

    private TriStateBoolean isInitiallySelected(String relPath) {
        return this._selectionRules != null ? this._selectionRules.inferFromRules(relPath, true) : TriStateBoolean.FALSE;
    }

    private static String getLabel(String path) {
        if (path != null) {
            if (path.endsWith("/")) {
                int dirSlash = path.lastIndexOf(47);
                if (dirSlash > 0) {
                    int lastSlash = path.lastIndexOf(47, dirSlash - 1);
                    return path.substring(lastSlash >= 0 ? lastSlash + 1 : 0, dirSlash);
                }
            } else {
                int lastSlash = path.lastIndexOf("/");
                if (lastSlash >= 0) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        return path;
    }

    private static JTreeCellData newJTreeCellData(String path, URL url, String label) {
        String urlStr;
        JTreeCellData cellData = new JTreeCellData(label);
        if (url != null && ModelUtil.hasLength((String)(urlStr = URLFileSystem.getPlatformPathName((URL)url)))) {
            cellData.setToolTipText(urlStr);
        }
        return cellData;
    }

    public static class URLParentSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            boolean _caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
            if (o1 != null && o2 != null && o1 != o2 && o1 instanceof URL && o2 instanceof URL) {
                URL url1 = (URL)o1;
                URL url2 = (URL)o2;
                String file1 = url1.toString();
                String file2 = url2.toString();
                boolean isDir1 = URLFileSystem.isDirectoryPath((URL)url1);
                boolean isDir2 = URLFileSystem.isDirectoryPath((URL)url2);
                if (isDir1 && isDir2) {
                    if (!_caseSensitive) {
                        file1 = file1.toLowerCase();
                        file2 = file2.toLowerCase();
                    }
                    if (file1.contains(file2.subSequence(0, file2.length()))) {
                        return 1;
                    }
                    if (file2.contains(file1.subSequence(0, file1.length()))) {
                        return -1;
                    }
                }
                if (_caseSensitive) {
                    return file1.compareTo(file2);
                }
                return file1.compareToIgnoreCase(file2);
            }
            return 0;
        }
    }

    private class URLNode
    extends JMutableTreeNode {
        private final String _path;
        private final URL _url;
        private final boolean _isLeaf;
        private boolean _isLoaded;

        URLNode() {
            this("", null, CommonArb.getString(127));
        }

        URLNode(String path, URL url) {
            this(path, url, SelectionRulesTreePanel.getLabel(path));
        }

        private URLNode(String path, URL url, String label) {
            super(SelectionRulesTreePanel.newJTreeCellData(path, url, label));
            this._path = path;
            this._url = url;
            this._isLeaf = !this.isRootPath() && !URLFileSystem.isDirectoryPath((URL)this._url);
            this._treeCellData.setIcon(this._isLeaf ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon"));
            this._treeCellData.setCheckBoxState(SelectionRulesTreePanel.this.isInitiallySelected(path));
            this._treeCellData.setHasCheckBox(true);
        }

        private boolean isRootPath() {
            return "".equals(this._path);
        }

        public boolean getAllowsChildren() {
            return !this._isLeaf;
        }

        public boolean isLeaf() {
            return this._isLeaf;
        }

        boolean isLoaded() {
            return this._isLoaded;
        }

        URL getURL() {
            return this._url;
        }

        void maybeLoad() {
            if (this._isLoaded || this._url == null && !this.isRootPath()) {
                return;
            }
            final WaitCursor waitCursor = new WaitCursor((Component)((Object)SelectionRulesTreePanel.this));
            SwingWorker worker = new SwingWorker(){
                private URL[] _children;
                private URLPath _contribs;

                public Object construct() {
                    URLPath regularFiles;
                    if (URLNode.this.isRootPath()) {
                        this._contribs = new URLPath(SelectionRulesTreePanel.this._contribPath);
                        regularFiles = FileGroupPackager.stripRegularFiles(this._contribs);
                    } else {
                        this._contribs = SelectionRulesTreePanel.this._contribPath;
                        regularFiles = null;
                    }
                    List children = this._contribs.getFilesAndDirectories(URLNode.this._path, true);
                    if (regularFiles != null) {
                        children.addAll(Arrays.asList(regularFiles.getEntries()));
                    }
                    this._children = children.toArray(new URL[children.size()]);
                    Arrays.sort(this._children, SelectionRulesTreePanel.this._urlComparator);
                    return null;
                }

                public void finished() {
                    if (this._children != null) {
                        ArrayList<String> seenPaths = new ArrayList<String>();
                        for (URL childURL : this._children) {
                            String childPath = SelectionRulesTreePanel.this.toRelativePath(childURL);
                            if (seenPaths.contains(childPath)) continue;
                            seenPaths.add(childPath);
                            URLNode child = new URLNode(childPath, childURL);
                            URLNode.this.add((MutableTreeNode)((Object)child));
                        }
                        SelectionRulesTreePanel.this._treeModel.nodeStructureChanged((TreeNode)((Object)URLNode.this));
                    }
                    URLNode.this.updateNodes();
                    waitCursor.hide();
                }
            };
            waitCursor.show(400);
            this._isLoaded = true;
            worker.construct();
            worker.finished();
        }
    }
}

