/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.SelectedProjectFiles;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.ClassDependencyAnalyzer;
import oracle.jdevimpl.deploy.CommonHandler;
import oracle.jdevimpl.deploy.common.JProjectSelectionFilter;
import oracle.jdevimpl.deploy.common.ProjectCdaPackets;
import oracle.jdevimpl.deploy.common.SourceDerivatives;

public class SelectedProjectFilesDt {
    private static final String CONNECTIONS_XML = "connections.xml";
    private static final String XSQL_CONFIG_XML = "XSQLConfig.xml";
    private final Project _project;
    private final SelectedProjectFiles _spf;
    private final URLPath _classPath;
    private final ProjectCdaPackets _packetFactory;

    public SelectedProjectFilesDt(Project project) {
        this(project, new SelectedProjectFiles());
    }

    public SelectedProjectFilesDt(Project project, SelectedProjectFiles spf) {
        if (project == null || spf == null) {
            throw new IllegalArgumentException();
        }
        this._project = project;
        this._spf = spf;
        this._classPath = PathsConfiguration.getInstance((Project)this._project).getRunClassPath();
        this._packetFactory = new ProjectCdaPackets((DataContainer)project);
    }

    public Map getEntryURLMap(CdaSettings cdaSettings, Map entryURLMap) {
        URL outputDir;
        boolean asSource;
        Set explicitSet = this.getExplicitSet();
        SourceDerivatives sourceDerivatives = new SourceDerivatives(this._project);
        HashSet classSet = new HashSet();
        HashSet extraOutputURLs = new HashSet();
        if (entryURLMap == null) {
            entryURLMap = new HashMap<String, CdaPacket>();
        }
        Iterator explicitIter = explicitSet.iterator();
        int deploySourceAs = this._spf.getDeploySourceAs();
        boolean asCompiled = deploySourceAs != 1;
        boolean bl = asSource = deploySourceAs != 0;
        while (explicitIter.hasNext()) {
            URL url = (URL)explicitIter.next();
            boolean foundSourceDerivative = true;
            if (asCompiled) {
                foundSourceDerivative = sourceDerivatives.getDerivatives(this._project, url, classSet);
            }
            if (!asSource && foundSourceDerivative) continue;
            CdaPacket cdaPacket = this._packetFactory.createCdaPacket(url);
            entryURLMap.put(cdaPacket.getName(), cdaPacket);
        }
        ClassDependencyAnalyzer cda = CommonHandler.newCDA(this._project, cdaSettings);
        cda.addInitialEntries(classSet);
        cda.analyze(entryURLMap);
        for (URL url : extraOutputURLs) {
            CdaPacket cdaPacket = this._packetFactory.createCdaPacket(url);
            entryURLMap.put(cdaPacket.getName(), cdaPacket);
        }
        if (this._classPath.toQualifiedURL("oracle/jdeveloper/cm/ConnectionManager.class") != null) {
            outputDir = JavaProject.getInstance((Project)this._project).getOutputDirectory();
            URL connectionsXmlURL = URLFactory.newURL((URL)outputDir, (String)CONNECTIONS_XML);
            if (!URLFileSystem.exists((URL)connectionsXmlURL)) {
                connectionsXmlURL = null;
            }
            entryURLMap.put(CONNECTIONS_XML, new CdaPacket(CONNECTIONS_XML, connectionsXmlURL));
        }
        if (this._classPath.toQualifiedURL("oracle/xml/xsql/XSQLServlet.class") != null) {
            outputDir = JavaProject.getInstance((Project)this._project).getOutputDirectory();
            URL xsqlConfigXmlURL = URLFactory.newURL((URL)outputDir, (String)XSQL_CONFIG_XML);
            if (!URLFileSystem.exists((URL)xsqlConfigXmlURL)) {
                xsqlConfigXmlURL = null;
            }
            entryURLMap.put(XSQL_CONFIG_XML, new CdaPacket(XSQL_CONFIG_XML, xsqlConfigXmlURL));
        }
        return entryURLMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getExplicitSet() {
        HashSet<URL> spfSet = new HashSet<URL>();
        URL[] spfFiles = this._spf.getFiles();
        if (spfFiles != null) {
            int numSpfFiles = spfFiles.length;
            for (int i = 0; i < numSpfFiles; ++i) {
                spfSet.add(spfFiles[i]);
            }
        }
        HashSet<URL> selectedFiles = new HashSet<URL>();
        if (this._spf.isAutoInclude()) {
            JProjectSelectionFilter[] filters = JProjectSelectionFilter.createFilters(this._spf.getSelectionFilters(), this._project);
            Index index = IndexManager.getIndexManager().getIndex(this._project);
            QueryCriteria criteria = new QueryCriteria();
            criteria.put((Object)"file.all", null);
            BackgroundTask query = index.query(criteria);
            try {
                URL[] results;
                for (URL url : results = (URL[])query.get()) {
                    URL childURL;
                    Node childElem;
                    Node childNode = NodeFactory.findOrCreate((URL)url);
                    if (childNode instanceof Element && !JProjectSelectionFilter.canBeSelected((Object)(childElem = childNode), filters) || spfSet.contains(childURL = childNode.getURL())) continue;
                    selectedFiles.add(childURL);
                }
            }
            catch (Exception e) {
            }
            finally {
                index.release();
            }
        } else {
            URL[] files = this._spf.getFiles();
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                selectedFiles.add(files[i]);
            }
        }
        return selectedFiles;
    }
}

