/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.ArrayElementList;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.TablePanel;

public class PackagingOtherPanel
extends TablePanel {
    transient ArrayElementList _list;

    public PackagingOtherPanel() {
        super(CommonArb.getString(101), "need help ID", 1, true);
    }

    @Override
    protected void onEntryImpl(TraversableContext tc) {
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        Object[] contribs = pfg.getContributors();
        this._list = new ArrayElementList(Contributor.class, contribs);
        this.setElementList(this._list);
        NiceTableCellRenderer tcr = new NiceTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Contributor contrib = (Contributor)PackagingOtherPanel.this.getElementList().get(row);
                String displayString = PackagingOtherPanel.toDisplayString(contrib);
                JLabel cellRenderer = (JLabel)super.getTableCellRendererComponent(table, (Object)displayString, isSelected, hasFocus, row, column);
                return cellRenderer;
            }
        };
        this.setColumnCellRenderer(0, (TableCellRenderer)tcr);
        final URLTextField urlField = new URLTextField();
        class E
        extends DefaultCellEditor {
            E(final URLTextField field) {
                super(new JTextField());
                this.editorComponent = field;
                this.delegate = new DefaultCellEditor.EditorDelegate(){

                    @Override
                    public void setValue(Object value) {
                        field.setURL((URL)value);
                    }

                    @Override
                    public Object getCellEditorValue() {
                        return field.getURL();
                    }
                };
                urlField.addActionListener((ActionListener)this.delegate);
            }
        }
        this.setCellEditor(0, new E(urlField));
    }

    @Override
    protected void onExitImpl(TraversableContext tc) {
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        pfg.setContributors((Contributor[])this._list.getData());
    }

    @Override
    protected String getElementListItemKey() {
        return "file-group";
    }

    @Override
    protected DetailPanel newCreatePanel() {
        return new Details(true);
    }

    @Override
    protected void initTable(JTable table) {
        table.setTableHeader(null);
        table.setShowGrid(false);
        table.setFont(new Font("Monospaced", 0, 12));
    }

    @Override
    protected int getTableColumnCount() {
        return 1;
    }

    @Override
    protected String getTableColumnName(int column) {
        switch (column) {
            case 0: {
                return CommonArb.getString(102);
            }
        }
        return CommonArb.getString(103);
    }

    @Override
    protected Object getTableValueAt(Object data, int row, int column) {
        Contributor contrib = (Contributor)data;
        switch (column) {
            case 0: {
                return contrib.getLocation();
            }
        }
        return CommonArb.getString(103);
    }

    @Override
    protected boolean isTableCellEditable(int row, int column) {
        Contributor contrib = (Contributor)this.getElementList().get(row);
        return contrib.getType() == 1;
    }

    @Override
    protected boolean isTableRowRemoveable(int row) {
        return true;
    }

    @Override
    protected void setTableValueAt(Object data, Object value, int row, int column) {
        Contributor contrib = (Contributor)data;
        switch (column) {
            case 0: {
                contrib.setLocation((URL)value);
            }
        }
    }

    public Iterator getIterator() {
        return this._list.iterator();
    }

    public void addListItem(Object o) {
        this._list.add(o);
    }

    private static String toDisplayString(Contributor contrib) {
        if (contrib != null) {
            switch (contrib.getType()) {
                case 1: {
                    return URLFileSystem.getPlatformPathName((URL)contrib.getLocation());
                }
                case 2: {
                    return CommonArb.getString(104);
                }
                case 3: {
                    return CommonArb.getString(105);
                }
                case 4: {
                    return URLFileSystem.getPlatformPathName((URL)contrib.getLocation());
                }
                case 5: {
                    return CommonArb.getString(106);
                }
                case 6: {
                    return CommonArb.getString(107);
                }
                case 7: {
                    return CommonArb.getString(108);
                }
                case 8: {
                    return CommonArb.getString(109);
                }
                case 9: {
                    return CommonArb.getString(114);
                }
                case 10: {
                    return CommonArb.getString(115);
                }
            }
        }
        return CommonArb.getString(110);
    }

    private static class Details
    extends DetailPanel {
        private final JButton _btnBrowse = new JButton();
        private final URLTextField _tfLocation;

        Details(boolean isForDialog) {
            super(isForDialog, "f1_depfgdlgpkgcont_html");
            ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)CommonArb.getString(111));
            this._tfLocation = this.addLabeledURLTextFieldButton(CommonArb.getString(112), true, this._btnBrowse);
            Dimension prefSize = this._tfLocation.getPreferredSize();
            prefSize.width = 350;
            this._tfLocation.setPreferredSize(prefSize);
            this._btnBrowse.addActionListener((ActionListener)this._tfLocation);
        }

        @Override
        protected void onEntryImpl(TraversableContext tc, Object data) {
            Contributor contrib = (Contributor)data;
            this._tfLocation.setURL(contrib.getLocation());
        }

        @Override
        protected void onExitImpl(TraversableContext tc, Object data) {
            Contributor contrib = (Contributor)data;
            contrib.setType(1);
            contrib.setLocation(this._tfLocation.getURL());
        }

        @Override
        protected String getDialogTitle() {
            return CommonArb.getString(113);
        }
    }
}

