/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.TriStateBoolean;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;

public class PackagingLibrariesPanel
extends DefaultTraversablePanel {
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final CustomJTree tree = new CustomJTree();

    public PackagingLibrariesPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.tree, null);
    }

    public void onEntry(TraversableContext tc) {
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        List archivesList = pfg.getContributorsByType(4);
        JMutableTreeNode root = new JMutableTreeNode(CommonArb.getString(60));
        Project project = (Project)CommonEditor.getProject((Namespace)tc);
        PackagingLibrariesPanel.addActiveConfigLibs(root, project, archivesList);
        this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        IdeUtil.expandAllTreeRows((JTree)this.tree);
        root.descendingUpdateNodes();
    }

    public void onExit(TraversableContext tc) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        JMutableTreeNode root = (JMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object userObj;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData data = node.getModel();
            if (data == null || !((userObj = data.getUserObject()) instanceof URL) || data.getCheckBoxState() != TriStateBoolean.TRUE) continue;
            resultList.add(userObj);
        }
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        ArrayList<Contributor> contribList = new ArrayList<Contributor>();
        Contributor[] contributors = pfg.getContributors();
        if (contributors != null) {
            contribList.addAll(Arrays.asList(contributors));
        }
        Iterator iter = contribList.iterator();
        while (iter.hasNext()) {
            URL uRL;
            Contributor contrib = (Contributor)iter.next();
            if (contrib == null) {
                iter.remove();
                continue;
            }
            if (contrib.getType() != 4 || (uRL = contrib.getLocation()) == null) continue;
            int index = resultList.indexOf(uRL);
            if (index < 0) {
                iter.remove();
                continue;
            }
            resultList.remove(index);
        }
        for (URL uRL : resultList) {
            Contributor contrib = new Contributor(4, uRL);
            contribList.add(contrib);
        }
        Contributor[] contributorArray = contribList.toArray(new Contributor[contribList.size()]);
        pfg.setContributors((Contributor[])(contributorArray.length > 0 ? contributorArray : null));
    }

    Component getLabelFor() {
        return this.tree;
    }

    private static void addActiveConfigLibs(JMutableTreeNode root, Project project, List archivesList) {
        if (project == null) {
            return;
        }
        JProjectLibraries jLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        VersionNumber jdkVer = jLibs.getJdkVersionNumber();
        JLibrary[] libs = jLibs.getLibraries();
        PackagingLibrariesPanel.addLibraryNodes(root, jLibs, jdkVer, libs, archivesList);
    }

    private static void addLibraryNodes(JMutableTreeNode configNode, JProjectLibraries jLibs, VersionNumber jdkVer, JLibrary[] libs, List archivesList) {
        Icon libIcon = ModelArb.getIcon((int)14);
        if (libs != null) {
            for (JLibrary lib : libs) {
                URLPath classPath;
                JLibraryDefinition libDef;
                JTreeCellData libCellData = new JTreeCellData(libIcon, lib.getName(), true);
                libCellData.setUserObject((Object)lib);
                JMutableTreeNode libNode = new JMutableTreeNode(libCellData);
                configNode.add((MutableTreeNode)libNode);
                if (lib == null || (libDef = lib.getLibraryDefinition(jdkVer)) == null || (classPath = libDef.getClassPath()) == null) continue;
                PackagingLibrariesPanel.addArchiveNodes(libNode, classPath, archivesList);
            }
        }
    }

    private static void addArchiveNodes(JMutableTreeNode libNode, URLPath classPath, List archivesList) {
        Icon jarIcon = OracleIcons.getIcon((String)"archivefile.png");
        for (URL entry : classPath.getEntries()) {
            String name = URLFileSystem.getFileName((URL)entry);
            JTreeCellData archCellData = new JTreeCellData(jarIcon, name, true);
            archCellData.setUserObject((Object)entry);
            archCellData.setCheckBoxState(archivesList.contains(entry));
            JMutableTreeNode archNode = new JMutableTreeNode(archCellData);
            libNode.add((MutableTreeNode)archNode);
        }
    }
}

