/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Element;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.DependentLibrary;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;
import oracle.jdevimpl.deploy.res.CommonArb;

public class LibraryContributorsPanel
extends DefaultTraversablePanel {
    private Profile _profile;
    private final JScrollPane spTree = new JScrollPane();
    private final CustomJTree tree = new CustomJTree();

    public LibraryContributorsPanel() {
        this.setLayout(new GridBagLayout());
        JLabel lblTree = new JLabel();
        ResourceUtils.resLabel((JLabel)lblTree, (Component)this.tree, (String)CommonArb.getString(93));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        this.spTree.getViewport().add((Component)this.tree, null);
        this.add(lblTree, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5)));
        this.add(this.spTree, this.gbc(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5)));
        this.setHelpID("f1_depfglibcont_html");
    }

    public void onEntry(TraversableContext tc) {
        this._profile = CommonEditor.getProfile((Namespace)tc);
        LibraryFileGroup lfg = FileGroupsEditor.getLibraryFileGroup((Namespace)tc);
        Object[] selLibs = lfg.getSelectedLibraries();
        this.load(tc, Arrays.asList(selLibs != null ? selLibs : new Object[]{}));
    }

    public void onExit(TraversableContext tc) {
        LibraryFileGroup lfg = FileGroupsEditor.getLibraryFileGroup((Namespace)tc);
        lfg.setSelectedLibraries(this.commit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(final TraversableContext tc, final List selLibs) {
        final JMutableTreeNode root = new JMutableTreeNode();
        LibraryToolkitHelper libraryToolkitHelper = CommonEditor.getLibraryToolkitHelper((Namespace)tc);
        synchronized (libraryToolkitHelper) {
            final IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), CommonArb.getString(138));
            progressMonitor.setMillisToPopup(1000);
            progressMonitor.setCancellable(true);
            progressMonitor.setCloseOnFinish(true);
            progressMonitor.start();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    LibraryContributorsPanel.loadLibraries(tc, root, LibraryContributorsPanel.this._profile, selLibs, progressMonitor);
                    return null;
                }

                public void finished() {
                    progressMonitor.close();
                    LibraryContributorsPanel.this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
                    IdeUtil.expandAllTreeRows((JTree)LibraryContributorsPanel.this.tree);
                    root.descendingUpdateNodes();
                }
            };
            swingWorker.start();
        }
    }

    private static boolean anyNonIgnoredDependentLibraries(Map<JLibrary, List<DependentLibrary>> libraryMap, JLibrary library) {
        List<DependentLibrary> dependentLibraryList = libraryMap.get(library);
        for (DependentLibrary dependentLibrary : dependentLibraryList) {
            if (dependentLibrary.getIgnoredBy() != null) continue;
            return true;
        }
        return false;
    }

    private static void loadLibraries(TraversableContext tc, JMutableTreeNode root, Profile profile, List selLibs, IndeterminateProgressMonitor progressMonitor) {
        LibraryToolkitHelper helper = CommonEditor.getLibraryToolkitHelper((Namespace)tc);
        Context context = new Context();
        context.setElement((Element)profile);
        context.setProperty("ProgressMonitor", (Object)progressMonitor);
        helper.buildDependentLibraries(context);
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"libraries.unresolvedByDependents", (Object)Boolean.TRUE);
        criteria.put((Object)"libraries.excluded", (Object)Boolean.FALSE);
        Map<JLibrary, List<DependentLibrary>> libraryMap = helper.getLibraryMap(criteria);
        Set<JLibrary> keySet = libraryMap.keySet();
        for (JLibrary library : keySet) {
            if (library == null) continue;
            Object libID = library.getID();
            if (DeployUtil.isDirectoryLibrary(library)) continue;
            JTreeCellData libCellData = new JTreeCellData(library.getIcon(), library.getName(), true);
            libCellData.setUserObject((Object)library);
            if (Boolean.TRUE.equals(library.getDeployedByDefault()) && LibraryContributorsPanel.anyNonIgnoredDependentLibraries(libraryMap, library)) {
                libCellData.setCheckBoxState(true);
                libCellData.setCheckBoxSelectable(false);
                libCellData.setCheckBoxEnabled(false);
            } else {
                libCellData.setCheckBoxState(selLibs.contains(libID));
            }
            JMutableTreeNode libNode = new JMutableTreeNode(libCellData);
            root.add((MutableTreeNode)libNode);
        }
    }

    private Object[] commit() {
        ArrayList<Object> resultList = new ArrayList<Object>();
        JMutableTreeNode root = (JMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object userObj;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData data = node.getModel();
            if (data == null || !((userObj = data.getUserObject()) instanceof Library) || data.getCheckBoxState() != TriStateBoolean.TRUE || !data.isCheckBoxEnabled()) continue;
            resultList.add(((Library)userObj).getID());
        }
        return resultList.toArray(new Object[resultList.size()]);
    }
}

