/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.FileGroupsNavigable;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.ArrayElementList;
import oracle.jdevimpl.xml.CreateSupport;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.NDRPanel;

public class FileGroupsPanel
extends NDRPanel
implements CreateSupport {
    private transient ArrayElementList _groupList;

    public FileGroupsPanel() {
        this.addWrappedLabel(CommonArb.getString(80));
        this.addWrappedLabel(CommonArb.getString(81));
        this.addFill();
        this.setHelpID("f1_depfg_html");
    }

    @Override
    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        FileGroups fileGroups = FileGroupsEditor.getFileGroups((Namespace)tc);
        Object[] groups = fileGroups.getGroups();
        this._groupList = new ArrayElementList(FileGroup.class, groups, false);
        this.setElementList(this._groupList);
    }

    @Override
    public void onExit(TraversableContext tc) throws TraversalException {
        super.onExit(tc);
        FileGroups fileGroups = FileGroupsEditor.getFileGroups((Namespace)tc);
        fileGroups.setGroups((FileGroup[])this._groupList.getData());
    }

    @Override
    protected DetailPanel newCreatePanel() {
        return new Details(true);
    }

    @Override
    protected String getElementListItemKey() {
        return "file-group";
    }

    @Override
    protected DefaultMutableTreeNode createTreeNode(NavigableContext nc, Object data) {
        return FileGroupsNavigable.createTreeNodeImpl(nc, (FileGroup)data);
    }

    private class Details
    extends DetailPanel
    implements ChangeListener {
        private TraversableContext _tc;
        private final JTextField _tfName;
        private final JRadioButton _rbPackagingFileGroup;
        private final JRadioButton _rbProjectFileGroup;
        private final JRadioButton _rbLibraryFileGroup;

        Details(boolean isForDialog) {
            super(isForDialog, "f1_depfgdlgfg_html");
            this._tfName = this.addWatchedTextField(CommonArb.getString(82));
            this.addWrappedLabel(CommonArb.getString(83));
            this._rbPackagingFileGroup = this.addRadioButton(CommonArb.getString(84));
            this._rbProjectFileGroup = this.addRadioButton(CommonArb.getString(85));
            this._rbLibraryFileGroup = this.addRadioButton(CommonArb.getString(86));
            this._rbLibraryFileGroup.addChangeListener(this);
            this.addFill();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._rbPackagingFileGroup);
            buttonGroup.add(this._rbProjectFileGroup);
            buttonGroup.add(this._rbLibraryFileGroup);
        }

        @Override
        protected void onEntryImpl(TraversableContext tc, Object data) {
            this._tfName.setText("");
            DataContainer container = this.getDataContainer(tc);
            this._tc = tc;
            this._rbPackagingFileGroup.setSelected(true);
            this._rbProjectFileGroup.setEnabled(container instanceof Project);
        }

        @Override
        protected void onExitImpl(TraversableContext tc, Object data) {
            FileGroup group;
            String displayName = this._tfName.getText();
            if (this._rbProjectFileGroup.isSelected()) {
                group = new ProjectFileGroup(displayName);
            } else if (this._rbLibraryFileGroup.isSelected()) {
                group = LibraryFileGroup.newDefaultGroup(displayName);
            } else {
                Class profileContainerClass = this.getProfileContainerClass(tc);
                group = PackagingFileGroup.newDefaultGroup(profileContainerClass, displayName, null);
            }
            tc.findAndReplace(FileGroupsPanel.this.getElementListItemKey(), (Object)group);
        }

        private DataContainer getDataContainer(TraversableContext tc) {
            if (tc.find("stored-proc-profile") != null) {
                return (Project)CommonEditor.getProject((Namespace)tc);
            }
            Profile profile = CommonEditor.getProfile((Namespace)tc);
            if (profile == null) {
                throw new RuntimeException("profile is null in TraversableContext");
            }
            return profile.getDataContainer();
        }

        private Class getProfileContainerClass(TraversableContext tc) {
            DataContainer container = this.getDataContainer(tc);
            return container.getClass();
        }

        @Override
        protected String getDialogTitle() {
            return CommonArb.getString(88);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object obj = e.getSource();
            if (obj instanceof JRadioButton && ((JRadioButton)obj).isSelected()) {
                String defaultLibraryFileGroupName;
                Profile profile = CommonEditor.getProfile((Namespace)this._tc);
                if (this._tfName != null && (this._tfName.getText() == null || this._tfName.getText().length() == 0) && (defaultLibraryFileGroupName = profile.getDefaultLibraryFileGroupName()) != null) {
                    this._tfName.setText(defaultLibraryFileGroupName);
                }
            }
        }
    }
}

