/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.XMLDataNode;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.JarPackaging;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.deploy.common.DependencyIterator;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;

public class FileGroupsEditor {
    private static final String FILE_GROUPS_KEY = "file-groups";
    public static final String FILE_GROUP_KEY = "file-group";

    public static FileGroups getFileGroups(Namespace data) {
        return (FileGroups)data.find(FILE_GROUPS_KEY);
    }

    public static void setFileGroups(FileGroups fileGroups, Namespace data) {
        data.findAndReplace(FILE_GROUPS_KEY, (Object)fileGroups);
    }

    public static FileGroup getFileGroup(Namespace data) {
        return (FileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setFileGroup(FileGroup fileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)fileGroup);
    }

    public static PackagingFileGroup getPackagingFileGroup(Namespace data) {
        return (PackagingFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setPackagingFileGroup(PackagingFileGroup packagingFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)packagingFileGroup);
    }

    public static ProjectFileGroup getProjectFileGroup(Namespace data) {
        return (ProjectFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setProjectFileGroup(ProjectFileGroup projectFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)projectFileGroup);
    }

    public static LibraryFileGroup getLibraryFileGroup(Namespace data) {
        return (LibraryFileGroup)data.find(FILE_GROUP_KEY);
    }

    public static void setLibraryFileGroup(LibraryFileGroup libraryFileGroup, Namespace data) {
        data.findAndReplace(FILE_GROUP_KEY, (Object)libraryFileGroup);
    }

    public static URLPath getContribPath(PackagingFileGroup group, DataContainer container) {
        URLPath contribPath = new URLPath();
        Contributor[] contributors = group.getContributors();
        if (contributors != null) {
            block12: for (Contributor contrib : contributors) {
                if (contrib == null) continue;
                switch (contrib.getType()) {
                    case 1: {
                        contribPath.add(contrib.getLocation());
                        continue block12;
                    }
                    case 2: {
                        Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                        contribPath.add(JavaProject.getInstance((Project)((Project)container)).getOutputDirectory());
                        continue block12;
                    }
                    case 3: {
                        Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                        contribPath.add(JProjectPaths.getInstance((PropertyStorage)((Project)container)).getAdditionalClassPath());
                        continue block12;
                    }
                    case 4: {
                        Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                        contribPath.add(contrib.getLocation());
                        continue block12;
                    }
                    case 5: {
                        Assert.check((boolean)(container instanceof Project), (String)"Project output directory only available for Project-profiles");
                        contribPath.add(J2eeSettings.getInstance((Project)container).getHtmlRootDirectory());
                        continue block12;
                    }
                    case 6: {
                        contribPath.add(PathsConfiguration.getInstance((Project)((Project)container)).getProjectSourcePath());
                        continue block12;
                    }
                    case 7: {
                        FileGroupsEditor.addProjectDependencies(contribPath, (Project)container);
                        continue block12;
                    }
                    case 8: {
                        FileGroupsEditor.addProfileDependencies(contribPath, (Project)container, null);
                        continue block12;
                    }
                    case 9: {
                        contribPath.add(ApplicationContent.getInstance((Workspace)((Workspace)container)).getSourceURL());
                        continue block12;
                    }
                    case 10: {
                        contribPath.add(ApplicationContent.getInstance((Workspace)((Workspace)container)).getADFSourceURL());
                        continue block12;
                    }
                }
            }
        }
        return contribPath;
    }

    public static URLPath oldgetContribPath(LibraryFileGroup group, Project project) {
        boolean asFiles;
        ArrayList<JLibrary> deployedLibs = new ArrayList<JLibrary>();
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        VersionNumber jdkVer = projectLibs.getJdkVersionNumber();
        JLibrary[] projectLibraries = projectLibs.getLibraries();
        if (projectLibraries != null) {
            for (int i = 0; i < projectLibraries.length; ++i) {
                JLibrary lib = projectLibraries[i];
                if (lib == null || DeployUtil.isDirectoryLibrary(lib) || !Boolean.TRUE.equals(lib.getDeployedByDefault())) continue;
                deployedLibs.add(lib);
            }
        }
        FileGroupsEditor.getDeployedLibraries((DataContainer)project, group.getSelectedLibraries(), deployedLibs);
        URLPath contribPath = new URLPath();
        Iterator iter = deployedLibs.iterator();
        boolean bl = asFiles = group.getSelectionMode() == 0;
        while (iter.hasNext()) {
            URL[] entries;
            URLPath cp;
            JLibrary libDef = (JLibrary)iter.next();
            if (libDef == null || (cp = libDef.getClassPath()) == null || (entries = cp.getEntries()) == null) continue;
            int n = entries.length;
            for (int i = 0; i < n; ++i) {
                URL entry = entries[i];
                URL contrib = asFiles ? JarUtil.getJarFileURL((URL)entry) : entry;
                contribPath.add(contrib);
            }
        }
        return contribPath;
    }

    public static URLPath getContribPath(LibraryFileGroup group, DataContainer dataContainer, Element libraryElement) {
        return FileGroupsEditor.getContribPath(null, group, dataContainer, libraryElement, null);
    }

    public static URLPath getContribPath(LibraryToolkitHelper libraryToolkitHelper, LibraryFileGroup group, DataContainer dataContainer, Element libraryElement, IndeterminateProgressMonitor progressMonitor) {
        boolean asFiles;
        ArrayList<JLibrary> deployedLibs = new ArrayList<JLibrary>();
        if (libraryToolkitHelper == null) {
            libraryToolkitHelper = new LibraryToolkitHelper();
        }
        Context context = new Context();
        if (libraryElement == null) {
            context.setProperty("traverseDependencies", (Object)Boolean.FALSE);
            context.setElement((Element)dataContainer);
        } else {
            context.setElement(libraryElement);
        }
        context.setElement(libraryElement);
        context.setProperty("ProgressMonitor", (Object)progressMonitor);
        libraryToolkitHelper.buildDependentLibraries(context);
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"libraries.unresolvedByDependents", (Object)Boolean.TRUE);
        criteria.put((Object)"libraries.ignored", (Object)Boolean.FALSE);
        criteria.put((Object)"libraries.excluded", (Object)Boolean.FALSE);
        criteria.put((Object)"libraries.deployByDefault", (Object)Boolean.TRUE);
        Set<JLibrary> keySet = libraryToolkitHelper.getLibraryMap(criteria).keySet();
        for (JLibrary library : keySet) {
            deployedLibs.add(library);
        }
        FileGroupsEditor.getDeployedLibraries(dataContainer, group.getSelectedLibraries(), deployedLibs);
        URLPath contribPath = new URLPath();
        Iterator iter = deployedLibs.iterator();
        boolean bl = asFiles = group.getSelectionMode() == 0;
        while (iter.hasNext()) {
            URL[] entries;
            URLPath cp;
            JLibrary libDef = (JLibrary)iter.next();
            if (libDef == null || (cp = libDef.getClassPath()) == null || (entries = cp.getEntries()) == null) continue;
            int n = entries.length;
            for (int i = 0; i < n; ++i) {
                URL entry = entries[i];
                URL contrib = asFiles ? JarUtil.getJarFileURL((URL)entry) : entry;
                contribPath.add(contrib);
            }
        }
        return contribPath;
    }

    private static void getDeployedLibraries(DataContainer dataContainer, Object[] libNames, ArrayList deployedLibs) {
        if (libNames != null) {
            JProjectLibraryList projectLibList = dataContainer instanceof Project ? JProjectLibraries.getInstance((PropertyStorage)((Project)dataContainer)).getProjectLibraryList() : null;
            for (Object libName : libNames) {
                JLibrary lib = JLibraryManager.findLibrary((Object)libName);
                if (lib == null && projectLibList != null) {
                    lib = projectLibList.findLibrary(libName);
                }
                if (lib == null) continue;
                deployedLibs.add(lib);
            }
        }
    }

    private static void addProjectDependencies(URLPath contribPath, Project jProject) {
        DependencyIterator iter = new DependencyIterator(jProject);
        while (iter.hasNext()) {
            Object profileObj;
            iter.next();
            if (iter.isOwnerWorkspace()) {
                Project project = iter.getProject();
                if (project == null) continue;
                contribPath.add(JavaProject.getInstance((Project)project).getOutputDirectory());
                continue;
            }
            XMLDataNode profileNode = iter.getProfile();
            if (profileNode == null || !((profileObj = profileNode.getData()) instanceof ArchiveProfile)) continue;
            ArchiveProfile profile = (ArchiveProfile)profileObj;
            contribPath.add(URLFactory.newJarURL((URL)profile.getJarURL(), null));
        }
    }

    private static void addProfileDependencies(URLPath contribPath, Project project, JarPackaging profile) {
    }
}

