/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.LinkedList;
import java.util.List;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdevimpl.deploy.common.LibraryToolkit;

public class DependentLibrary
extends LibraryToolkit {
    private JLibrary _library;
    private Element _ignoredBy;
    private Element _resolvedBy;
    private Element _excludedBy;

    public DependentLibrary() {
    }

    DependentLibrary(JLibrary library) {
        this();
        this._library = library;
    }

    public JLibrary getLibrary() {
        return this._library;
    }

    public boolean isDeployByDefault() {
        return this._library.getDeployedByDefault().equals(Boolean.TRUE);
    }

    public void setIgnoredBy(Element element) {
        this._ignoredBy = element;
    }

    public Element getIgnoredBy() {
        return this._ignoredBy;
    }

    public void setExcludedBy(Element element) {
        this._excludedBy = element;
    }

    public Element getExcludedBy() {
        return this._excludedBy;
    }

    public void setResolvedBy(Element element) {
        this._resolvedBy = element;
    }

    public Element getResolvedBy() {
        return this._resolvedBy;
    }

    private Boolean getBooleanValue(Object object) {
        if (object == null) {
            return null;
        }
        boolean booleanValue = false;
        if (object instanceof Boolean) {
            booleanValue = object.equals(Boolean.TRUE);
        }
        return booleanValue;
    }

    private boolean cantPackageResolvedBy(Element originatingElement) {
        if (originatingElement == null || !(originatingElement instanceof ArchiveProfile)) {
            return false;
        }
        if (this.getResolvedBy() == null) {
            return false;
        }
        ArchiveProfile originatingProfile = (ArchiveProfile)originatingElement;
        return !originatingProfile.canPackage(this.getResolvedBy());
    }

    @Override
    public List<DependentLibrary> getDependentLibraries(QueryCriteria criteria) {
        LinkedList<DependentLibrary> result = new LinkedList<DependentLibrary>();
        boolean allCriteriaSatisfied = false;
        if (criteria == null) {
            allCriteriaSatisfied = true;
        } else {
            Object originatingElementObject = criteria.get((Object)"OriginalBuildElement");
            Element originatingElement = originatingElementObject != null && originatingElementObject instanceof Element ? (Element)originatingElementObject : null;
            Boolean deployByDefault = this.getBooleanValue(criteria.get((Object)"libraries.deployByDefault"));
            Boolean unresolved = this.getBooleanValue(criteria.get((Object)"libraries.unresolved"));
            Boolean unresolvedByDependents = this.getBooleanValue(criteria.get((Object)"libraries.unresolvedByDependents"));
            Boolean ignored = this.getBooleanValue(criteria.get((Object)"libraries.ignored"));
            Boolean excluded = this.getBooleanValue(criteria.get((Object)"libraries.excluded"));
            Boolean excludedByDependents = this.getBooleanValue(criteria.get((Object)"libraries.excludedByDependents"));
            boolean deployByDefaultCriteriaSatisfied = deployByDefault == null || this.getLibrary().getDeployedByDefault().booleanValue() == deployByDefault.booleanValue();
            boolean unresolvedCriteriaSatisfied = unresolved == null || unresolved == true && this.getResolvedBy() == null || unresolved == false && this.getResolvedBy() != null || this.cantPackageResolvedBy(originatingElement);
            boolean unresolvedByDependentsSatisfied = unresolvedByDependents == null || this.getResolvedBy() == null || this.getResolvedBy().equals(originatingElement) || this.cantPackageResolvedBy(originatingElement);
            boolean ignoredSatisfied = ignored == null || ignored == true && this.getIgnoredBy() != null || ignored == false && this.getIgnoredBy() == null;
            boolean excludedSatisfied = excluded == null || excluded == true && this.getExcludedBy() != null || excluded == false && this.getExcludedBy() == null;
            boolean excludedByDependentsSatisfied = excludedByDependents == null || excludedByDependents == true && this.getExcludedBy() != null && !this.getExcludedBy().equals(originatingElement) || excludedByDependents == false && (this.getExcludedBy() == null || this.getExcludedBy().equals(originatingElement));
            boolean bl = allCriteriaSatisfied = deployByDefaultCriteriaSatisfied && unresolvedCriteriaSatisfied && unresolvedByDependentsSatisfied && ignoredSatisfied && excludedSatisfied && excludedByDependentsSatisfied;
        }
        if (allCriteriaSatisfied) {
            result.add(this);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DependentLibrary)o);
    }

    private boolean areEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected final boolean equalsImpl(DependentLibrary dependentLibrary) {
        if (dependentLibrary.getLibrary() == null || this.getLibrary() == null) {
            return false;
        }
        boolean libraryEquals = dependentLibrary.getLibrary().equals(this.getLibrary());
        boolean excludedByEquals = this.areEqual(dependentLibrary._excludedBy, this._excludedBy);
        boolean ignoredByEquals = this.areEqual(dependentLibrary._ignoredBy, this._ignoredBy);
        boolean resolvedByEquals = this.areEqual(dependentLibrary._resolvedBy, this._resolvedBy);
        boolean sameParentToolkit = this.areEqual(dependentLibrary.getParentLibraryToolkit(), this.getParentLibraryToolkit());
        return libraryEquals && excludedByEquals && ignoredByEquals && resolvedByEquals && sameParentToolkit;
    }

    @Override
    protected final void copyToImpl(Object object) {
        super.copyToImpl(object);
        DependentLibrary dependentLibrary = (DependentLibrary)object;
        dependentLibrary._library = this._library;
        dependentLibrary._excludedBy = this._excludedBy;
        dependentLibrary._ignoredBy = this._ignoredBy;
        dependentLibrary._resolvedBy = this._resolvedBy;
    }

    public String toString() {
        if (this.getLibrary() == null) {
            return super.toString();
        }
        String s = this.getLibrary().toString();
        return this.getLibrary().getID() + "\n" + "      ResolvedBy:" + this.getResolvedBy() + "\n" + "      ExcludedBy:" + this.getExcludedBy() + "\n" + "      IgnoredBy :" + this.getIgnoredBy() + "\n" + "      Origin    :" + this.getOriginStack();
    }
}

