/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.LibraryArb;
import oracle.jdevimpl.deploy.res.CommonArb;

public class DefaultProfileDependable
extends AbstractHashDependable
implements ProfileDependable,
ArchiveElement,
JLibrary {
    public static final String PROFILE_NAME_KEY = "profileName";
    Profile profile_;

    public DefaultProfileDependable(Profile profile) {
        this(profile, profile.getDataContainer().getURL());
    }

    public DefaultProfileDependable(Profile profile, URL folder) {
        this.setProfileName(profile.getName());
        this.setFolderURL(folder);
        this.profile_ = profile;
        this.setReload(false);
    }

    public DefaultProfileDependable(HashStructure hash) {
        super(hash);
    }

    @Override
    public Profile getProfile() {
        return (Profile)this.getSource();
    }

    @Override
    public Profile getSourceImpl() {
        return this.profile_;
    }

    @Override
    public Folder getSourceOwnerImpl() {
        Profile profile = this.getProfile();
        if (profile != null) {
            return profile.getDataContainer();
        }
        return null;
    }

    @Override
    public boolean cache() {
        String profileName = this._hash.getString(PROFILE_NAME_KEY);
        URL folderURL = this._hash.getURL("ownerURL");
        this.profile_ = null;
        if (URLFileSystem.exists((URL)folderURL)) {
            try {
                DataContainer folder_ = (DataContainer)NodeFactory.findOrCreate((URL)folderURL);
                this.profile_ = DeploymentProfiles.getInstance(folder_).getProfileByName(profileName);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    void setProfileName(String name) {
        String oldName = this._hash.getString(PROFILE_NAME_KEY);
        this._hash.putString(PROFILE_NAME_KEY, name);
        this.maybeSetReload(name, oldName);
    }

    void setFolderURL(URL url) {
        URL oldurl = this._hash.getURL("ownerURL");
        this._hash.putURL("ownerURL", url);
        this.maybeSetReload(url, oldurl);
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        Profile profile = this.getProfile();
        if (profile == null) {
            return new ArrayList().iterator();
        }
        return profile.getDependencies();
    }

    @Override
    public <T> T getProfile(Class<T> clazz) {
        Profile profile = this.getProfile();
        return (T)(clazz.isAssignableFrom(profile.getClass()) ? profile : null);
    }

    @Override
    public DataContainer getDataContainer() {
        return (DataContainer)this.getSourceOwner();
    }

    @Override
    public boolean doesExist() {
        return this.getSource() != null;
    }

    @Override
    public String toString() {
        String sourceOwnerString = "";
        String sourceString = "";
        String suffix = "";
        Folder sourceOwner = this.getSourceOwner();
        if (sourceOwner == null) {
            URL sourceOwnerURL = this._hash.getURL("ownerURL");
            if (!URLFileSystem.exists((URL)sourceOwnerURL)) {
                if (sourceOwnerURL != null) {
                    sourceOwnerString = URLFileSystem.getFileName((URL)this._hash.getURL("ownerURL"));
                }
                suffix = " - " + JProjectArb.getString((int)175);
            } else if (sourceOwnerURL != null) {
                sourceOwnerString = URLFileSystem.getFileName((URL)this._hash.getURL("ownerURL"));
            }
        } else {
            sourceOwnerString = sourceOwner.toString();
        }
        Element source = this.getSource();
        if (source == null) {
            sourceString = this._hash.getString(PROFILE_NAME_KEY);
            if (suffix.length() == 0) {
                suffix = " - " + CommonArb.getString(134);
            }
        } else {
            sourceString = source.toString();
        }
        return sourceOwnerString + ":" + sourceString + suffix;
    }

    @Override
    @Deprecated
    public String getPathInArchive() {
        return this._hash.getString("pathInEar");
    }

    @Override
    @Deprecated
    public void setPathInArchive(String path) {
        this._hash.putString("pathInEar", path);
    }

    public Boolean getDeployedByDefault() {
        return Boolean.TRUE;
    }

    public void setDeployedByDefault(Boolean deploy) {
    }

    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    public String getName() {
        if (this.profile_ == null) {
            return null;
        }
        return this.profile_.getShortLabel();
    }

    public void setName(String name) {
    }

    public Object getID() {
        return this.getName();
    }

    public boolean equivalent(Library library) {
        JLibrary jlib;
        JLibrary jLibrary = jlib = library instanceof JLibrary ? (JLibrary)library : null;
        if (library == null) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)library.getClassPath(), (Object)this.getClassPath())) {
            return false;
        }
        if (library.isLocked() != this.isLocked()) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jlib.getDeployedByDefault(), (Object)this.getDeployedByDefault());
    }

    public void initFromLibrary(Library library) {
    }

    public URLPath getDefaultClassPath() {
        return this.getClassPath();
    }

    public void setDefaultClassPath(URLPath clsPath) {
        this.setClassPath(clsPath);
    }

    public URLPath getDefaultSourcePath() {
        return this.getSourcePath();
    }

    public void setDefaultSourcePath(URLPath srcPath) {
        this.setSourcePath(srcPath);
    }

    public URLPath getDefaultDocPath() {
        return null;
    }

    public void setDefaultDocPath(URLPath docPath) {
        this.setDocPath(docPath);
    }

    public String getShortLabel() {
        if (this.profile_ == null) {
            return null;
        }
        return this.profile_.getShortLabel();
    }

    public String getLongLabel() {
        if (this.profile_ == null) {
            return null;
        }
        return this.profile_.getLongLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon((int)7);
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public URLPath getClassPath() {
        if (this.profile_ == null || !(this.profile_ instanceof ArchiveProfile) || ((ArchiveProfile)this.profile_).getJarURL() == null) {
            return null;
        }
        return new URLPath(((ArchiveProfile)this.profile_).getJarURL());
    }

    public void setClassPath(URLPath path) {
    }

    public URLPath getSourcePath() {
        return null;
    }

    public void setSourcePath(URLPath sourcePath) {
    }

    public URLPath getDocPath() {
        return null;
    }

    public void setDocPath(URLPath docPath) {
    }

    public boolean isLocked() {
        return false;
    }

    public void setLocked(boolean locked) {
    }
}

