/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.common.SelectedArchives;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;

public final class CommonEditor {
    private static final String PROJECT_KEY = "project";
    public static final String SELECTED_ARCHIVES_KEY = "selected-archives";
    private static final String WORKSPACE_KEY = "workspace";
    private static final String CONTEXT_KEY = "ide-context";
    public static final String DESCRIPTOR_OBJECT_KEY = "descriptor-object";
    private static final String PROFILE_KEY = "profile";
    private static final String LIBRARY_TOOLKIT_HELPER = "LibraryToolkitHelper";

    public static URLPath getClassPath(Namespace data) {
        try {
            Project project = (Project)data.find(PROJECT_KEY);
            return PathsConfiguration.getInstance((Project)project).getClassPath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node getProject(Namespace data) {
        return (Node)data.find(PROJECT_KEY);
    }

    public static void putProject(Node project, Namespace data) {
        data.findAndReplace(PROJECT_KEY, (Object)project);
    }

    public static SelectedArchives getSelectedArchives(Namespace data) {
        return (SelectedArchives)data.find(SELECTED_ARCHIVES_KEY);
    }

    public static void putSelectedArchives(SelectedArchives sa, Namespace data) {
        data.findAndReplace(SELECTED_ARCHIVES_KEY, (Object)(sa != null ? sa : new SelectedArchives()));
    }

    public static Node getWorkspace(Namespace data) {
        return (Node)data.find(WORKSPACE_KEY);
    }

    public static void putWorkspace(Node workspace, Namespace data) {
        data.findAndReplace(WORKSPACE_KEY, (Object)workspace);
    }

    public static Context getContext(Namespace data) {
        return (Context)data.find(CONTEXT_KEY);
    }

    public static void putContext(Context context, Namespace data) {
        data.findAndReplace(CONTEXT_KEY, (Object)context);
    }

    public static Object getDescriptor(Namespace data) {
        return data.find(DESCRIPTOR_OBJECT_KEY);
    }

    public static void setDescriptor(Object descriptor, Namespace data) {
        data.findAndReplace(DESCRIPTOR_OBJECT_KEY, descriptor);
    }

    public static Profile getProfile(Namespace data) {
        return (Profile)data.find(PROFILE_KEY);
    }

    public static void putProfile(Profile profile, Namespace data) {
        data.findAndReplace(PROFILE_KEY, (Object)profile);
    }

    public static LibraryToolkitHelper getLibraryToolkitHelper(Namespace data) {
        return (LibraryToolkitHelper)data.find(LIBRARY_TOOLKIT_HELPER);
    }

    public static void putLibraryToolkitHelper(LibraryToolkitHelper libraryToolkitHelper, Namespace data) {
        data.findAndReplace(LIBRARY_TOOLKIT_HELPER, (Object)libraryToolkitHelper);
    }
}

