/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import javax.swing.SwingUtilities;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;

public abstract class SwingClosure {
    public static void run(final Runnable runnable) {
        SwingClosure closure = new SwingClosure(){

            @Override
            protected void deployImpl(DeployShell dsh) throws Exception {
                runnable.run();
            }
        };
        try {
            closure.deploy(null);
        }
        catch (DeployException deployException) {
            // empty catch block
        }
    }

    public static void run(SwingClosure closure) throws DeployException {
        closure.deploy(null);
    }

    public final void deploy(final DeployShell dsh) throws DeployException {
        class Closure
        implements Runnable {
            DeployException _exception = null;

            Closure() {
            }

            @Override
            public void run() {
                try {
                    SwingClosure.this.deployImpl(dsh);
                }
                catch (DeployException e) {
                    this._exception = e;
                }
                catch (Exception e) {
                    this._exception = new DeployException(e);
                }
            }
        }
        Closure closure = new Closure();
        if (SwingUtilities.isEventDispatchThread()) {
            closure.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(closure);
            }
            catch (Exception e) {
                throw new DeployException(e);
            }
        }
        if (closure._exception != null) {
            throw closure._exception;
        }
    }

    protected abstract void deployImpl(DeployShell var1) throws Exception;
}

