/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.util.Collection;
import java.util.LinkedHashSet;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.prf.spi.Recognizer;
import oracle.jdeveloper.deploy.prf.spi.Recognizers;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProviders;

public final class DeploymentHookHandler
extends ExtensionHook
implements IdeListener {
    static final ElementName ELEMENT = DeploymentHookHandler.e("deployment-hook");
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-deployment";
    private Collection<MetaClass> _deployAddins = new LinkedHashSet<MetaClass>();
    private Collection<MetaClass<Recognizer>> _profileRecognizers = new LinkedHashSet<MetaClass<Recognizer>>();
    private Collection<MetaClass<ToolkitProvider>> _toolkitProviders = new LinkedHashSet<MetaClass<ToolkitProvider>>();
    private ElementVisitor _deploymentclasshandler = new DeploymentClassHandler();
    private ElementVisitor _profileRecognizerHandler = new ProfileRecognizerHandler();
    private ElementVisitor _toolkitProvidersHandler = new ToolkitProvidersHandler();

    public DeploymentHookHandler() {
        Ide.addIdeListener((IdeListener)this);
    }

    private static final ElementName e(String name) {
        return new ElementName(NS, name);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(DeploymentHookHandler.e("deployment-class"), this._deploymentclasshandler);
        context.registerChildVisitor(DeploymentHookHandler.e("profile-recognizers"), this._profileRecognizerHandler);
        context.registerChildVisitor(DeploymentHookHandler.e("toolkit-providers"), this._toolkitProvidersHandler);
    }

    public void addinsLoaded(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        if (this._deployAddins.size() > 0) {
            for (MetaClass deployAddin : this._deployAddins) {
                Deployment.loadDeployAddin(deployAddin.getClassLoader(), deployAddin.getClassName());
            }
            Deployment.processLoad();
        }
        Recognizers prRegistry = Recognizers.getRecognizers();
        for (MetaClass<Recognizer> prmc : this._profileRecognizers) {
            prRegistry.register(prmc);
        }
        this._profileRecognizers = null;
        ToolkitProviders tkRegistry = ToolkitProviders.getToolkitProviders();
        for (MetaClass<ToolkitProvider> tkpmc : this._toolkitProviders) {
            tkRegistry.register(tkpmc);
        }
        this._toolkitProviders = null;
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    private class ToolkitProvidersHandler
    extends ElementVisitor {
        private TkProviderClassHandler tkProviderClassHandler = new TkProviderClassHandler();

        private ToolkitProvidersHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(DeploymentHookHandler.e("provider-class"), (ElementVisitor)this.tkProviderClassHandler);
        }

        private class TkProviderClassHandler
        extends ElementVisitor {
            private TkProviderClassHandler() {
            }

            public void end(ElementEndContext context) {
                String tkproviderClass = context.getText().trim();
                assert (this.classExists(tkproviderClass, context.getClass().getClassLoader()));
                MetaClass mc = new MetaClass(context.getClass().getClassLoader(), tkproviderClass);
                DeploymentHookHandler.this._toolkitProviders.add(mc);
            }

            boolean classExists(String className, ClassLoader cl) {
                try {
                    cl.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        }
    }

    private class ProfileRecognizerHandler
    extends ElementVisitor {
        private RecognizerClassHandler recognizerClassHandler = new RecognizerClassHandler();

        private ProfileRecognizerHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(DeploymentHookHandler.e("recognizer-class"), (ElementVisitor)this.recognizerClassHandler);
        }

        private class RecognizerClassHandler
        extends ElementVisitor {
            private RecognizerClassHandler() {
            }

            public void end(ElementEndContext context) {
                String recognizerClass = context.getText().trim();
                assert (this.classExists(recognizerClass, context.getClass().getClassLoader()));
                MetaClass mc = new MetaClass(context.getClass().getClassLoader(), recognizerClass);
                DeploymentHookHandler.this._profileRecognizers.add(mc);
            }

            boolean classExists(String className, ClassLoader cl) {
                try {
                    cl.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
        }
    }

    private class DeploymentClassHandler
    extends ElementVisitor {
        private DeploymentClassHandler() {
        }

        public void end(ElementEndContext context) {
            String deployclazz = context.getText().trim();
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            DeploymentHookHandler.this._deployAddins.add(new MetaClass(loader, deployclazz));
        }
    }
}

