/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.util.Iterator;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.DataContainer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmd;

public class DeployCommandHistory
extends HashStructureAdapter {
    private static String DEPLOY_COMMAND_HISTORY_KEY = "deployCommandHistory";
    private static String COMMANDS_KEY = "commands";
    private static String DEPLOY_COMMAND_LABEL_KEY = "shortLabel";
    DataContainer container_ = null;
    int limit_ = 5;

    private DeployCommandHistory(HashStructure hash) {
        super(hash);
    }

    public static DeployCommandHistory getInstance(DataContainer container) {
        DeployCommandHistory dch;
        HashStructure hash = container.getUserPropertiesOnly().getHashStructure(DEPLOY_COMMAND_HISTORY_KEY);
        if (hash == null) {
            dch = new DeployCommandHistory(HashStructure.newInstance());
            dch.setContainer(container);
        } else {
            dch = new DeployCommandHistory(hash);
        }
        return dch;
    }

    private void setContainer(DataContainer container) {
        this.container_ = container;
    }

    public void addCommand(DeployCommand cmd) {
        if (this.limit_ == 0) {
            return;
        }
        HashStructure hash = HashStructure.newInstance();
        cmd.getState().saveTo(hash);
        String cmdLabel = cmd.getLongLabel();
        ListStructure list = this._hash.getOrCreateListStructure(COMMANDS_KEY);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                HashStructure storedHash = (HashStructure)list.get(i);
                String label = storedHash.getString(DEPLOY_COMMAND_LABEL_KEY);
                if (!cmdLabel.equals(label)) continue;
                list.remove(i);
                break;
            }
        }
        if (list.size() == this.limit_) {
            list.remove(this.limit_ - 1);
        }
        hash.putString(DEPLOY_COMMAND_LABEL_KEY, cmdLabel);
        list.add(0, (Object)hash);
        this.write();
    }

    public void clear() {
        this._hash.clear();
        this.write();
    }

    public Iterator<DeployCommand> iterator() {
        ListStructure list = this._hash.getOrCreateListStructure(COMMANDS_KEY);
        Iterator iter = list.iterator();
        return new CommandIterator(iter);
    }

    private void write() {
        if (this.container_ != null) {
            this.container_.getUserPropertiesOnly().putHashStructure(DEPLOY_COMMAND_HISTORY_KEY, this._hash);
            this.container_ = null;
        }
    }

    int getLimit() {
        return this.limit_;
    }

    void setLimit(int limit) {
        this.limit_ = limit;
    }

    private class CommandIterator
    implements Iterator {
        final Iterator hashIter_;
        DeployCommand cmd_ = null;

        CommandIterator(Iterator iter) {
            this.hashIter_ = iter;
        }

        @Override
        public boolean hasNext() {
            if (this.cmd_ != null) {
                return true;
            }
            while (this.hashIter_.hasNext() && this.cmd_ == null) {
                HashStructure h = (HashStructure)this.hashIter_.next();
                try {
                    HashStructure newHash = HashStructure.newInstance();
                    h.copyTo(newHash);
                    newHash.remove(DEPLOY_COMMAND_LABEL_KEY);
                    this.cmd_ = DeployCommand.create(newHash);
                }
                catch (ProfileDeployCmd.ProfileNotFoundException e) {
                }
                catch (DeployCommand.CommandInstantiationException e) {
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
                if (this.cmd_ != null) continue;
                this.hashIter_.remove();
            }
            return this.cmd_ != null;
        }

        public Object next() {
            DeployCommand c = this.cmd_;
            this.cmd_ = null;
            return c;
        }

        @Override
        public void remove() {
            this.hashIter_.remove();
        }
    }
}

