/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.util.macro.StringMacroConverter;

public class CommandLineTokenizer {
    public String[] toArgs(String cmd, Map macros) {
        return CommandLineTokenizer.expandMacros(CommandLineTokenizer.extractArgs(cmd), macros);
    }

    static String[] expandMacros(String[] args, Map macros) {
        ArrayList<String> result = new ArrayList<String>();
        int n = args.length;
        StringMacroConverter converter = StringMacroConverter.getConverter((int)3);
        for (int i = 0; i < n; ++i) {
            String expandedArg = converter.expandString(args[i], macros);
            if (expandedArg == null || expandedArg.length() <= 0) continue;
            StringTokenizer st = new StringTokenizer(expandedArg, "\u0000");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    static String[] extractArgs(String cmd) {
        StringBuffer curArg = new StringBuffer();
        int n = cmd.length();
        boolean doubleQuoteSeen = false;
        boolean singleQuoteSeen = false;
        ArrayList<String> args = new ArrayList<String>();
        block9: for (int i = 0; i < n; ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i < n) {
                        char c2 = cmd.charAt(i);
                        switch (c2) {
                            case '\"': 
                            case '\'': 
                            case '\\': {
                                curArg.append(c2);
                                continue block9;
                            }
                        }
                        curArg.append('\\').append(c2);
                        continue block9;
                    }
                    curArg.append('\\');
                    continue block9;
                }
                case '\"': {
                    if (singleQuoteSeen) {
                        curArg.append('\"');
                        continue block9;
                    }
                    doubleQuoteSeen = !doubleQuoteSeen;
                    continue block9;
                }
                case '\'': {
                    if (doubleQuoteSeen) {
                        curArg.append('\'');
                        continue block9;
                    }
                    singleQuoteSeen = !singleQuoteSeen;
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (doubleQuoteSeen || singleQuoteSeen) {
                        curArg.append(c);
                        continue block9;
                    }
                    if (curArg.length() <= 0) continue block9;
                    args.add(curArg.toString());
                    curArg.setLength(0);
                    continue block9;
                }
                default: {
                    curArg.append(c);
                }
            }
        }
        if (curArg.length() > 0) {
            args.add(curArg.toString());
        }
        return args.toArray(new String[args.size()]);
    }
}

