/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.PrintWriter;
import oracle.ide.Context;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;

public class BuildSystemFacade {
    public void deploy(boolean isAssembly, PrintWriter log, Context context) {
        Profile profile = null;
        try {
            DeployShell dsh = DefaultDeployShellFactory.getInstance().create(DeploymentConstants.DEFAULT_SEQUENCE, context, null);
            profile = DeployUtil.getProfile(dsh);
            dsh.put("ignoreDependencies", Boolean.TRUE);
            dsh.put("isAssembly", isAssembly ? Boolean.TRUE : Boolean.FALSE);
            DeploymentManager.deploy(DeploymentConstants.DEFAULT_SEQUENCE, dsh);
        }
        catch (Exception e) {
            String logMessage = e.getMessage();
            if (e.getCause() != null && e.getCause().getMessage() != null && e.getMessage() != null && !e.getMessage().endsWith(e.getCause().getMessage())) {
                logMessage = e.getMessage() + " " + e.getCause().getMessage();
            }
            if (profile != null && profile.getDataContainer() != null) {
                logMessage = DeployArb.format(89, profile.getName(), profile.getDataContainer().getShortLabel(), logMessage);
            }
            log.println(logMessage);
        }
    }
}

