/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.DataContainer;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.GalleryArb;
import oracle.ide.xml.XMLUtil;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.dt.DeployMenuItem;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.AbstractProfileDt;
import oracle.jdevimpl.deploy.jar.ArchiveEditor;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.deploy.res.JarArb;
import oracle.jdevimpl.xml.ModalEditor;

public class ArchiveProfileDt
extends AbstractProfileDt {
    protected DeployMenuItem _ctxDeployToJarFile;

    protected ArchiveProfileDt() {
    }

    @Override
    protected String getDefaultCommand() {
        return "ArchiveProfile.deployToJarFile";
    }

    @Override
    protected String getLabelForCommand(String cmdName) {
        if (cmdName.equals("ArchiveProfile.deployToJarFile")) {
            return JarArb.getString(46);
        }
        if (cmdName.equals("ArchiveProfile.settingsDialog")) {
            return DeployArb.getString(55);
        }
        return null;
    }

    @Override
    protected boolean launchDialog(Context context, Profile profile) {
        return this.newDialog(context, (ArchiveProfile)profile).showDialog();
    }

    protected ModalEditor newDialog(Context context, ArchiveProfile profile) {
        return new ArchiveEditor(this.getSettingsDialogTitle(), profile, context);
    }

    protected String getSettingsDialogTitle() {
        return JarArb.getString(34);
    }

    @Override
    protected boolean handleEventImpl(String cmdName, IdeAction action, Context context) {
        ArchiveProfile profile = (ArchiveProfile)DeployUtil.getProfile(context);
        if (cmdName.equals("ArchiveProfile.settingsDialog")) {
            ArchiveProfile profileCopy = (ArchiveProfile)Deployment.createDeploymentProfile(profile.getDataContainer(), profile.getName(), profile.getClass());
            profile.copyTo(profileCopy);
            boolean userSaidOk = this.launchDialog(context, profileCopy);
            if (userSaidOk) {
                profileCopy.copyTo(profile);
            }
            return true;
        }
        if (cmdName.equals("ArchiveProfile.deployToJarFile")) {
            ArchiveProfileDt.packageAsync(context);
            return true;
        }
        return false;
    }

    public Class getDataClass() {
        return ArchiveProfile.class;
    }

    public String getXMLRootElement() {
        return "simple-archive-deployment";
    }

    @Override
    public String getXMLNamespaceURI() {
        return XMLUtil.toNamespaceURI((String)"deploy/jar");
    }

    @Override
    public Icon getIcon() {
        return DeployArb.getIcon(36);
    }

    @Override
    public String getMostRecentDeployTarget() {
        return DtArb.getString(30);
    }

    @Override
    public String getShortLabel() {
        return GalleryArb.getString((int)125);
    }

    @Override
    public String getLongLabel() {
        return GalleryArb.getString((int)126);
    }

    @Override
    protected String[] getTechnologyKeys() {
        return new String[]{"General"};
    }

    @Override
    protected String getDisplayName() {
        return JarArb.getString(32);
    }

    @Override
    protected String getDefaultProfileName() {
        return JarArb.getString(33);
    }

    @Override
    public void addDeploymentSubmenu(Context menuContext, JMenu profileSubMenu) {
        Context context = new Context(menuContext);
        this.initializeContextMenuItems((ArchiveProfile)DeployUtil.getProfile(context));
        profileSubMenu.add(this._ctxDeployToJarFile.menuItem);
    }

    private void initializeContextMenuItems(ArchiveProfile profile) {
        this._ctxDeployToJarFile = this.createDeployMenuItem("ArchiveProfile.deployToJarFile", profile);
    }

    @Override
    protected Profile newProfileInstance(DataContainer container, String profileName) {
        ArchiveProfile profile = ArchiveProfile.newDefaultArchiveProfile(this.getDataClass());
        this.initProfileInstance(profile, container, profileName);
        profile.setName(profileName);
        return profile;
    }

    protected void initProfileInstance(ArchiveProfile profile, DataContainer container, String profileName) {
        URL deployOutputDir = Deployment.getDeployOutputDir(container.getURL());
        URL jarURL = URLFactory.newURL((URL)deployOutputDir, (String)(profileName + ".jar"));
        profile.setJarURL(jarURL);
    }

    public static URL promptForURL(ArchiveProfile profile, Context context) {
        URL selectedTargetURL;
        URL defaultTargetURL = profile.getJarURL();
        if (defaultTargetURL == null) {
            URL nodeURL = DeployUtil.getDeployPathURL(context.getProject().getURL(), context.getNode().getURL());
            defaultTargetURL = Deployment.convertSuffix(nodeURL, ".jar");
        }
        if ((selectedTargetURL = ArchiveProfileDt.getSaveURL(context, defaultTargetURL, ".jar", JarArb.getString(29), JarArb.getString(30))) != null && !selectedTargetURL.equals(defaultTargetURL)) {
            profile.setJarURL(selectedTargetURL);
        }
        return selectedTargetURL;
    }

    private static URL getSaveURL(Context context, URL defaultSaveURL, String ext, String title, String prompt) {
        URLChooser urlChooser = DialogUtil.newURLChooser((Context)context);
        if (defaultSaveURL != null) {
            urlChooser.setSelectedURL(defaultSaveURL);
        }
        urlChooser.setURLFilter((URLFilter)new DefaultURLFilter(JarArb.getString(26), new String[]{".jar", ".zip"}));
        urlChooser.setShowJarsAsDirs(false);
        int result = urlChooser.showSaveDialog((Component)Ide.getMainWindow(), title);
        if (result == 0) {
            URL selectedURL = urlChooser.getSelectedURL();
            if (URLFileSystem.hasSuffix((URL)selectedURL, (String)ext) || URLFileSystem.hasSuffix((URL)selectedURL, (String)".jar") || URLFileSystem.hasSuffix((URL)selectedURL, (String)".zip")) {
                return selectedURL;
            }
            return URLFileSystem.ensureSuffix((URL)selectedURL, (String)ext);
        }
        return null;
    }

    private static void packageAsync(Context context) {
        ArchiveProfile profile = (ArchiveProfile)DeployUtil.getProfile(context);
        try {
            DeployShell dsh = ArchiveProfileDt.getDeployShell(profile, context);
            Deployment.maybeShowLogPage();
            DeploymentManager.deploy(DeploymentConstants.PACKAGING_SEQUENCE, dsh, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    implements ActionListener {
        private final Context _context;

        Action(Context context) {
            this._context = context;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArchiveProfile profile = (ArchiveProfile)DeployUtil.getProfile(this._context);
            String cmdName = e.getActionCommand();
            if (cmdName == "ArchiveProfile.settingsDialog") {
                ArchiveProfile profileCopy = (ArchiveProfile)Deployment.createDeploymentProfile(profile.getDataContainer(), profile.getName(), profile.getClass());
                profile.copyTo(profileCopy);
                boolean userSaidOk = ArchiveProfileDt.this.launchDialog(this._context, profileCopy);
                if (userSaidOk) {
                    profileCopy.copyTo(profile);
                }
            } else if (cmdName == "ArchiveProfile.deployToJarFile") {
                ArchiveProfileDt.packageAsync(this._context);
            }
        }
    }
}

