/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.PrintWriter;
import java.net.URL;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.DataContainer;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.dt.Profile;

abstract class AbstractProfileDt
extends DeployProfileDt {
    AbstractProfileDt() {
    }

    protected String getBasePath(URL saveURL) {
        URL containerURL = AbstractProfileDt.getContainerURL(this.getCreationContext());
        if (containerURL == null && (containerURL = AbstractProfileDt.getContainerURL(Context.newIdeContext())) == null) {
            containerURL = saveURL;
        }
        return URLFileSystem.getPathNoExt((URL)DeployUtil.getDeployPathURL(containerURL, saveURL));
    }

    protected static DeployShell getDeployShellImpl(Profile profile, Context context, PrintWriter log) throws DeployException {
        DeployUtil.setProfile(context, (Profile)profile.copyTo(null));
        DefaultDeployShellFactory dsf = DefaultDeployShellFactory.getInstance();
        DeployShell dsh = dsf.create(DeploymentConstants.DEFAULT_SEQUENCE, context, null);
        return AbstractProfileDt.initDeployShell(dsh, false);
    }

    static DeployShell getDeployShell(Profile profile, Context context, PrintWriter log) throws DeployException {
        DeployShell dsh = AbstractProfileDt.getDeployShellImpl(profile, context, log);
        DeploymentOptions opts = DeployUtil.getDeploymentOptions(context);
        if (opts.isCompileBeforeDeploy()) {
            dsh.put("isCompileBeforeDeploy", Boolean.TRUE);
        }
        if (opts.isCleanBeforeCompile()) {
            dsh.put("isCleanBeforeCompile", Boolean.TRUE);
        }
        if (!opts.isFollowDependencies()) {
            dsh.put("ignoreDependencies", Boolean.TRUE);
        }
        return dsh;
    }

    private static DeployShell initDeployShell(DeployShell dsh, boolean isConnectionDefault) {
        dsh.put("isConnectionDefault", isConnectionDefault ? Boolean.TRUE : Boolean.FALSE);
        return dsh;
    }

    static DeployShell getDeployShell(Profile profile, Context context) throws DeployException {
        DeployShell dsh = AbstractProfileDt.getDeployShell(profile, context, Deployment.getLogPrintWriter());
        return dsh;
    }

    private static URL getContainerURL(Context context) {
        DataContainer container;
        if (context != null && (container = DeployUtil.getProfileDataContainer(context)) != null) {
            return container.getURL();
        }
        return null;
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        String cmdName = action != null ? DeployUtil.getShortCommandKey((Action)action) : this.getDefaultCommand();
        return this.handleEventImpl(cmdName, action, context);
    }

    abstract boolean handleEventImpl(String var1, IdeAction var2, Context var3);
}

