/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceArrayAccessExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.cmtimpl.JbMethodCall;
import oracle.jdevimpl.cmtimpl.Res;

final class JbValue
implements CmtValue {
    CmtComponent outer;
    SourceExpression value;
    CmtSubcomponent subcomponent;
    private static URL UNKNOWN_IMAGE;

    public JbValue(CmtComponent c, SourceExpression v, CmtSubcomponent s) {
        this.outer = c;
        this.value = v;
        this.subcomponent = s;
    }

    public JbValue(CmtComponent c, SourceExpression v) {
        this.outer = c;
        this.value = v;
        if (this.outer != null) {
            this.subcomponent = this.outer.getSubcomponent(this.value.getText());
        }
    }

    @Override
    public CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    @Override
    public SourceExpression getExpression() {
        return this.value;
    }

    @Override
    public String getText() {
        if (this.subcomponent != null) {
            return this.subcomponent.getName();
        }
        if (this.value != null) {
            return this.value.getText();
        }
        return null;
    }

    @Override
    public void setText(String text) {
        try {
            SourceFile jFile = this.value.getOwningSourceFile();
            SourceTransaction transaction = jFile.getTransaction();
            boolean transactionCreated = false;
            if (transaction == null) {
                jFile.beginTransaction();
                transactionCreated = true;
            }
            SourceFactory jFactory = jFile.getFactory();
            SourceExpression jExpr = jFactory.createExpressionFromText(text);
            this.value.replaceSelf((SourceElement)jExpr);
            jFile.getTransaction().savepoint();
            if (transactionCreated) {
                jFile.getTransaction().commit();
            }
            this.value = jExpr;
            this.subcomponent = this.outer.getSubcomponent(this.value.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Class loadClass(CmtComponent outer, String type) {
        JavaClass clazz = outer.getComponents().getPackages().getClass(type);
        if (clazz == null) {
            return null;
        }
        String sigName = JotNames.typeToDotSignature(clazz.getQualifiedName());
        Class c = null;
        try {
            c = outer.getComponents().getPackages().loadClass(sigName, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c == null) {
            try {
                sigName = JotNames.typeToDotSignature(JotNames.getShortClassName(clazz.getQualifiedName()));
                c = outer.getComponents().getPackages().loadClass(sigName, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                sigName = clazz.getVMName().replace('/', '.');
                c = outer.getComponents().getPackages().loadClass(sigName, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return c;
    }

    @Override
    public Object getValue(JavaType type) throws CmtParseException {
        if (this.subcomponent != null) {
            return this.subcomponent.getLiveInstance();
        }
        if (this.value != null && type != null && type.getQualifiedName() != null) {
            return JbValue.getValue(this.value, type.getQualifiedName(), this.outer);
        }
        return null;
    }

    public static synchronized Object getValue(SourceExpression value, String type, CmtComponent outer) throws CmtParseException {
        switch (value.getSymbolKind()) {
            case 47: {
                Iterator iIter;
                SourceArrayAccessExpression jRef = (SourceArrayAccessExpression)value;
                Object lhs = JbValue.getValue(jRef.getLhsOperand(), "java.lang.Object", outer);
                SourceListExpression eList = (SourceListExpression)jRef.getSecondOperand();
                List indices = eList.getOperands();
                Iterator iterator = iIter = indices != null ? indices.iterator() : null;
                if (iIter != null && iIter.hasNext()) {
                    while (iIter.hasNext()) {
                        SourceExpression jExpr = (SourceExpression)iIter.next();
                        Object index = JbValue.getValue(jExpr, "int", outer);
                        if (lhs != null && lhs.getClass().isArray() && index instanceof Integer) {
                            lhs = Array.get(lhs, (Integer)index);
                            continue;
                        }
                        return null;
                    }
                    return lhs;
                }
                return null;
            }
            case 54: {
                SourceNewArrayExpression jArrayAlloc = (SourceNewArrayExpression)value;
                return JbValue.evaluateArrayInitializer(jArrayAlloc, outer);
            }
            case 48: {
                SourceAssignmentExpression jAssignment = (SourceAssignmentExpression)value;
                int operator = 0;
                switch (jAssignment.getOperatorCode()) {
                    case 2: {
                        operator = 1;
                        break;
                    }
                    case 32: {
                        operator = 31;
                        break;
                    }
                    case 36: {
                        operator = 35;
                        break;
                    }
                    case 18: {
                        operator = 17;
                        break;
                    }
                    case 34: {
                        operator = 33;
                        break;
                    }
                    case 8: {
                        operator = 7;
                        break;
                    }
                    case 11: {
                        operator = 10;
                        break;
                    }
                    case 13: {
                        operator = 12;
                        break;
                    }
                    case 29: {
                        operator = 28;
                        break;
                    }
                    case 52: {
                        operator = 51;
                        break;
                    }
                    case 57: {
                        operator = 56;
                        break;
                    }
                    default: {
                        return JbValue.getValue(jAssignment.getSecondOperand(), type, outer);
                    }
                }
                SourceFile jFile = jAssignment.getOwningSourceFile();
                SourceFactory jFactory = jFile.getFactory();
                SourceInfixExpression inExpr = jFactory.createInfixExpression(operator, (SourceExpression)jAssignment.getFirstOperand().cloneSelf(jFile), (SourceExpression)jAssignment.getSecondOperand().cloneSelf(jFile));
                return JbValue.evaluateOperation((SourceExpression)inExpr, type, outer);
            }
            case 55: {
                SourceNewClassExpression jClsAlloc = (SourceNewClassExpression)value;
                SourceClass jCls = jClsAlloc.getAnonymousClass();
                if (jCls != null) {
                    outer.logMessage(Res.format(61, new String[]{jCls.getResolvedType().getQualifiedName()}), jClsAlloc.getStartOffset(), jClsAlloc.getEndOffset(), 0);
                }
                return JbValue.evaluateClassAllocation(jClsAlloc, outer);
            }
            case 49: {
                SourceDotExpression jDot = (SourceDotExpression)value;
                String name = jDot.getName();
                SourceExpression jExpr = jDot.getLhsOperand();
                Object lhs = JbValue.getValue(jExpr, "java.lang.Object", outer);
                try {
                    if (lhs instanceof JavaPackage) {
                        CmtPackages jMgr = outer.getComponents().getPackages();
                        JavaClass jCls = jMgr.getClass(value.getText());
                        if (jCls != null) {
                            return jMgr.loadClass(value.getText(), true);
                        }
                        lhs = jMgr.getPackage(value.getText());
                        if (lhs != null) {
                            return lhs;
                        }
                        return null;
                    }
                    Field field = JbValue.getField(lhs, name);
                    return field.get(lhs);
                }
                catch (Exception e) {
                    String clsName = lhs instanceof Class ? ((Class)lhs).getName() : lhs.getClass().getName();
                    outer.logMessage(Res.format(47, new String[]{name, clsName}), value.getStartOffset(), value.getEndOffset(), 2);
                    return null;
                }
            }
            case 50: {
                return JbValue.evaluateOperation(value, type, outer);
            }
            case 51: {
                int code = value.getExpressionCode();
                if (code == 5) {
                    int[] dimensions = Jot2Utils.getDimensions(type);
                    int offset = type.indexOf("[");
                    if (offset > 0) {
                        type = type.substring(0, offset);
                    }
                    Class c = null;
                    try {
                        c = outer.getComponents().getPackages().loadClass(JotNames.typeToDotSignature(type), true);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return JbValue.createArrayFromInitializer((SourceListExpression)value, dimensions, c, type, outer);
                }
                return null;
            }
            case 52: {
                return JbValue.evaluatePrimaryExpression((SourceLiteralExpression)value, outer);
            }
            case 53: {
                SourceMethodCallExpression jMethodCall = (SourceMethodCallExpression)value;
                return JbValue.callMethod(jMethodCall, outer, true);
            }
            case 57: {
                String name = ((SourceSimpleNameExpression)value).getName();
                CmtSubcomponent sub = outer.getSubcomponent(name);
                if (sub != null) {
                    return sub.getLiveInstance();
                }
                CmtPackages jMgr = outer.getComponents().getPackages();
                JavaClass jCls = jMgr.getClass((SourceFile)outer.getFile(), name);
                if (jCls != null) {
                    try {
                        return jMgr.loadClass(jCls.getQualifiedName(), true);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                JavaPackage jPkg = jMgr.getPackage(name);
                if (jPkg != null) {
                    return jPkg;
                }
                outer.logMessage(Res.format(47, new String[]{name, outer.getType().getQualifiedName()}), value.getStartOffset(), value.getEndOffset(), 2);
                return null;
            }
            case 56: {
                return null;
            }
            case 58: {
                SourceTypeExpression jExpr = (SourceTypeExpression)value;
                SourceTypeReference jType = jExpr.getSourceType();
                String name = jType.getResolvedType().getQualifiedName();
                CmtPackages jMgr = outer.getComponents().getPackages();
                try {
                    return jMgr.loadClass(name, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            case 59: {
                SourceTypecastExpression jTypecast = (SourceTypecastExpression)value;
                return JbValue.getValue(jTypecast.getSecondOperand(), type, outer);
            }
            case 60: {
                return JbValue.evaluateOperation(value, type, outer);
            }
            case 61: {
                SourceWrapperExpression jWrapper = (SourceWrapperExpression)value;
                List list = jWrapper.getOperands();
                if (list != null && list.size() == 1) {
                    return JbValue.getValue((SourceExpression)list.get(0), type, outer);
                }
                return null;
            }
        }
        Assert.printStackTrace((boolean)true, (String)"Unrecognized SourceExpression element type");
        return null;
    }

    private static Object evaluateClassAllocation(SourceNewClassExpression jClsAlloc, CmtComponent outer) {
        try {
            List list;
            String clsName = jClsAlloc.getSourceType().getResolvedType().getQualifiedName();
            String proxy = UIManager.getConcreteProxy(clsName);
            Class c = null;
            if (proxy != null) {
                if (outer != null) {
                    CmtPackages pkgs = outer.getComponents().getPackages();
                    pkgs.addDesignTimePath(UIManager.getProxyPath(clsName));
                }
                c = JbValue.loadClass(outer, proxy);
            }
            if (c == null) {
                c = JbValue.loadClass(outer, clsName);
            }
            SourceListExpression args = (list = jClsAlloc.getOperands()) != null ? (SourceListExpression)list.get(0) : null;
            SourceExpression[] clsAllocArgs = new SourceExpression[args != null ? args.getOperandCount() : 0];
            String[] clsAllocArgTypes = new String[clsAllocArgs.length];
            Constructor<?>[] ctors = c.getConstructors();
            if (clsAllocArgs.length > 0) {
                Iterator lIter;
                list = args.getOperands();
                Iterator iterator = lIter = list != null ? list.iterator() : null;
                if (lIter != null) {
                    int i = 0;
                    while (lIter.hasNext()) {
                        clsAllocArgs[i] = (SourceExpression)lIter.next();
                        clsAllocArgTypes[i] = JbValue.getTypeOfExpression(clsAllocArgs[i], outer);
                        if (clsAllocArgTypes[i] != null && clsAllocArgTypes[i].equals("null")) {
                            clsAllocArgTypes[i] = null;
                        }
                        ++i;
                    }
                }
            }
            block7: for (int ci = 0; ci < ctors.length; ++ci) {
                Class<?>[] ctorParamTypes;
                int modifiers = ctors[ci].getModifiers();
                if (!Modifier.isPublic(modifiers) || (ctorParamTypes = ctors[ci].getParameterTypes()).length != clsAllocArgs.length) continue;
                Object[] liveArgs = new Object[ctorParamTypes.length];
                for (int ai = 0; ai < ctorParamTypes.length; ++ai) {
                    Class foundClass;
                    String ctorParamType = ctorParamTypes[ai].getName();
                    String clsAllocArgType = clsAllocArgTypes[ai];
                    if (clsAllocArgType != null && !JbValue.typesMatch(ctorParamTypes[ai], foundClass = JbValue.loadClass(outer, clsAllocArgType), clsAllocArgs[ai].getText())) {
                        clsAllocArgType = null;
                        if (ctorParamTypes[ai].isPrimitive() && foundClass.isPrimitive()) {
                            if (ctorParamTypes[ai] == Double.TYPE) {
                                clsAllocArgType = ctorParamType;
                            } else if (ctorParamTypes[ai] == Float.TYPE) {
                                if (foundClass != Double.TYPE) {
                                    clsAllocArgType = ctorParamType;
                                }
                            } else if (ctorParamTypes[ai] == Long.TYPE) {
                                if (foundClass != Double.TYPE && foundClass != Float.TYPE) {
                                    clsAllocArgType = ctorParamType;
                                }
                            } else if (ctorParamTypes[ai] == Integer.TYPE) {
                                if (foundClass != Double.TYPE && foundClass != Float.TYPE && foundClass != Long.TYPE) {
                                    clsAllocArgType = ctorParamType;
                                }
                            } else if (ctorParamTypes[ai] == Short.TYPE && foundClass == Byte.TYPE) {
                                clsAllocArgType = ctorParamType;
                            }
                        }
                        if (clsAllocArgType == null) continue block7;
                    }
                    if (clsAllocArgType == null) {
                        clsAllocArgType = ctorParamType;
                    }
                    if (ctorParamTypes[ai] != null && !ctorParamTypes[ai].isPrimitive() && !ctorParamTypes[ai].isArray() && Modifier.isAbstract(ctorParamTypes[ai].getModifiers())) {
                        ctorParamType = clsAllocArgType;
                    }
                    try {
                        liveArgs[ai] = JbValue.getValue(clsAllocArgs[ai], clsAllocArgType, outer);
                        continue;
                    }
                    catch (CmtParseException e) {
                        liveArgs[ai] = null;
                    }
                }
                try {
                    return ctors[ci].newInstance(liveArgs);
                }
                catch (Exception x) {
                    if (!ImageIcon.class.isAssignableFrom(c)) continue;
                    return new ImageIcon(JbValue.getUnknownImageURL());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object evaluatePrimaryExpression(SourceLiteralExpression jPrimary, CmtComponent outer) throws CmtParseException {
        String strValue = jPrimary.getText();
        char charValue = '\u0000';
        int type = jPrimary.getTokenValue();
        try {
            if (strValue != null && strValue.startsWith("'") && strValue.endsWith("'")) {
                charValue = FastStringBuffer.charFromString((String)strValue.substring(1));
            }
            switch (type) {
                case 12: {
                    return new Boolean(strValue);
                }
                case 13: {
                    return new Character(charValue);
                }
                case 8: {
                    if (charValue != '\u0000') {
                        return new Integer(charValue);
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    return Integer.valueOf(strValue);
                }
                case 9: {
                    if (charValue != '\u0000') {
                        return new Long(charValue);
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    return Long.valueOf(strValue);
                }
                case 10: {
                    if (charValue != '\u0000') {
                        return new Float(charValue);
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    return Float.valueOf(strValue);
                }
                case 11: {
                    if (charValue != '\u0000') {
                        return new Double(charValue);
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    return Double.valueOf(strValue);
                }
                case 14: {
                    return FastStringBuffer.sourceToText((String)strValue).toString();
                }
                case 15: {
                    return null;
                }
            }
            throw new CmtParseException(strValue);
        }
        catch (CmtParseException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object evaluateOperationGetValue(SourceExpression jExpr, String type, CmtComponent outer) throws CmtParseException {
        if (jExpr == null) {
            return null;
        }
        switch (jExpr.getSymbolKind()) {
            case 50: 
            case 59: 
            case 60: {
                return JbValue.evaluateOperation(jExpr, type, outer);
            }
        }
        return JbValue.getValue(jExpr, type, outer);
    }

    private static Object evaluateOperation(SourceExpression jExpr, String type, CmtComponent outer) throws CmtParseException {
        try {
            if (jExpr == null) {
                return null;
            }
            switch (jExpr.getSymbolKind()) {
                case 60: {
                    Class<?> cls;
                    SourceUnaryExpression jUnary = (SourceUnaryExpression)jExpr;
                    int op = jUnary.getOperatorCode();
                    Object o = JbValue.getValue(jUnary.getFirstOperand(), type, outer);
                    Class<?> clazz = cls = o != null ? o.getClass() : null;
                    if (op == 14) {
                        return cls;
                    }
                    if (cls != null) {
                        if (cls == Boolean.class) {
                            switch (op) {
                                case 41: {
                                    return (Boolean)o != false ? Boolean.FALSE : Boolean.TRUE;
                                }
                            }
                        } else if (cls == Character.class) {
                            switch (op) {
                                case 9: {
                                    return new Integer(~((Character)o).charValue());
                                }
                                case 37: {
                                    return new Integer(-((Character)o).charValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    char c = ((Character)o).charValue();
                                    c = (char)(c - '\u0001');
                                    return new Character(c);
                                }
                                case 48: {
                                    char c = ((Character)o).charValue();
                                    c = (char)(c + '\u0001');
                                    return new Character(c);
                                }
                            }
                        } else if (cls == Byte.class) {
                            switch (op) {
                                case 9: {
                                    return new Integer(~((Byte)o).byteValue());
                                }
                                case 37: {
                                    return new Integer(-((Byte)o).byteValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    byte b = (Byte)o;
                                    b = (byte)(b - 1);
                                    return new Byte(b);
                                }
                                case 48: {
                                    byte b = (Byte)o;
                                    b = (byte)(b + 1);
                                    return new Byte(b);
                                }
                            }
                        } else if (cls == Short.class) {
                            switch (op) {
                                case 9: {
                                    return new Integer(~((Short)o).shortValue());
                                }
                                case 37: {
                                    return new Integer(-((Short)o).shortValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    short s = (Short)o;
                                    s = (short)(s - 1);
                                    return new Short(s);
                                }
                                case 48: {
                                    short s = (Short)o;
                                    s = (short)(s + 1);
                                    return new Short(s);
                                }
                            }
                        } else if (cls == Integer.class) {
                            switch (op) {
                                case 9: {
                                    return new Integer(~((Integer)o).intValue());
                                }
                                case 37: {
                                    return new Integer(-((Integer)o).intValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    int i = (Integer)o;
                                    return new Integer(--i);
                                }
                                case 48: {
                                    int i = (Integer)o;
                                    return new Integer(++i);
                                }
                            }
                        } else if (cls == Long.class) {
                            switch (op) {
                                case 9: {
                                    return new Long((long)((Long)o ^ 0xFFFFFFFFFFFFFFFFL));
                                }
                                case 37: {
                                    return new Long(-((Long)o).longValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    long l = (Long)o;
                                    return new Long(--l);
                                }
                                case 48: {
                                    long l = (Long)o;
                                    return new Long(++l);
                                }
                            }
                        } else if (cls == Float.class) {
                            switch (op) {
                                case 37: {
                                    return new Float(-((Float)o).floatValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    float f = ((Float)o).floatValue();
                                    return new Float(f -= 1.0f);
                                }
                                case 48: {
                                    float f = ((Float)o).floatValue();
                                    return new Float(f += 1.0f);
                                }
                            }
                        } else if (cls == Double.class) {
                            switch (op) {
                                case 37: {
                                    return new Double(-((Double)o).doubleValue());
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    return o;
                                }
                                case 47: {
                                    double d = (Double)o;
                                    return new Double(d -= 1.0);
                                }
                                case 48: {
                                    double d = (Double)o;
                                    return new Double(d += 1.0);
                                }
                            }
                        }
                    }
                    return o;
                }
                case 59: {
                    SourceTypecastExpression jTypecast = (SourceTypecastExpression)jExpr;
                    return JbValue.getValue(jTypecast.getSecondOperand(), type, outer);
                }
                case 50: {
                    SourceInfixExpression binOp = (SourceInfixExpression)jExpr;
                    int operator = binOp.getOperatorCode();
                    SourceExpression lhs = binOp.getFirstOperand();
                    SourceExpression rhs = binOp.getSecondOperand();
                    Object o1 = JbValue.evaluateOperationGetValue(lhs, type, outer);
                    Object o2 = JbValue.evaluateOperationGetValue(rhs, type, outer);
                    if (o1 == null && o2 == null) {
                        return null;
                    }
                    if (type.equals("java.lang.String")) {
                        if (operator != 1) break;
                        String s = o1 == null ? o2.toString() : (o2 == null ? o1.toString() : o1.toString() + o2.toString());
                        return s;
                    }
                    if (!type.equals("int")) break;
                    switch (operator) {
                        case 1: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 + (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 31: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 - (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 35: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 * (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 33: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 % (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 17: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 / (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 10: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 | (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 7: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 & (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        case 12: {
                            try {
                                int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 ^ (Integer)o2);
                                return new Integer(result);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    }
                    Assert.println((String)("*** currently no support for " + jExpr.getText()));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Field getField(Object base, String name) throws NoSuchFieldException {
        if (base instanceof Class) {
            return ((Class)base).getField(name);
        }
        if (base != null) {
            return base.getClass().getField(name);
        }
        return null;
    }

    private static boolean typesMatch(Class expectedClass, Class foundClass, String sourceText) {
        if (expectedClass == null) {
            return false;
        }
        if (expectedClass.isAssignableFrom(foundClass)) {
            return true;
        }
        Field[] fields = foundClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String shortName = JotNames.getShortClassName(fields[i].getName());
            if (sourceText.indexOf(shortName) < 0 && sourceText.indexOf(fields[i].getName()) < 0 || !expectedClass.isAssignableFrom(fields[i].getType())) continue;
            return true;
        }
        return false;
    }

    private static String getTypeOfExpression(SourceExpression e, CmtComponent outer) {
        if (e != null) {
            JavaType jType = e.getResolvedType();
            return jType != null ? jType.getQualifiedName() : null;
        }
        return null;
    }

    public String toString() {
        return this.getText();
    }

    static void fillArray(Object array, SourceExpression[] elements, int[] dimensions, int nDim, String type, CmtComponent outer, Class c) {
        try {
            if (nDim + 1 >= dimensions.length) {
                for (int i = 0; i < elements.length; ++i) {
                    try {
                        Array.set(array, i, JbValue.getValue(elements[i], type, outer));
                        continue;
                    }
                    catch (CmtParseException e) {
                        Array.set(array, i, null);
                    }
                }
            } else {
                for (int j = 0; j < dimensions[nDim]; ++j) {
                    SourceExpression[] elems;
                    SourceListExpression expr = elements != null ? (SourceListExpression)elements[j] : null;
                    List list = expr != null ? expr.getOperands() : null;
                    SourceExpression[] sourceExpressionArray = elems = list != null && list.size() > 0 ? new SourceExpression[list.size()] : null;
                    if (elems != null) {
                        list.toArray(elems);
                    }
                    JbValue.fillArray(Array.get(array, j), elems, dimensions, nDim + 1, type, outer, c);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    static int getDimensionality(SourceExpression[] elements, int[] dimensions, int nDimensions) {
        if (dimensions != null) {
            dimensions[nDimensions] = elements.length;
        }
        ++nDimensions;
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getSymbolKind() == 51) {
            List list = ((SourceListExpression)elements[0]).getOperands();
            SourceExpression[] sourceExpressionArray = elements = list.size() > 0 ? new SourceExpression[list.size()] : null;
            if (elements != null) {
                list.toArray(elements);
            }
            return JbValue.getDimensionality(elements, dimensions, nDimensions);
        }
        return nDimensions;
    }

    static Object evaluateArrayInitializer(SourceNewArrayExpression jotNew, CmtComponent outer) {
        List init;
        JavaType jType = jotNew.getResolvedType();
        String name = jType.getQualifiedName();
        int[] dimensions = Jot2Utils.getDimensions(name);
        int offset = name.indexOf("[");
        if (offset > 0) {
            name = name.substring(0, offset);
        }
        SourceListExpression expr = (init = jotNew.getOperands()) != null && init.size() == 1 ? (SourceListExpression)init.get(0) : null;
        Class c = null;
        try {
            c = outer.getComponents().getPackages().loadClass(JotNames.typeToDotSignature(name), true);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return JbValue.createArrayFromInitializer(expr, dimensions, c, name, outer);
    }

    static Object createArrayFromInitializer(SourceListExpression init, int[] dimensions, Class c, String type, CmtComponent outer) {
        try {
            List list = init != null ? init.getOperands() : null;
            SourceExpression[] elements = null;
            if (list != null && list.size() > 0) {
                SourceExpression elem = (SourceExpression)list.get(0);
                int kind = elem.getSymbolKind();
                if (kind == 61) {
                    for (int i = 0; i < dimensions.length; ++i) {
                        elem = (SourceExpression)list.get(i);
                        dimensions[i] = (Integer)JbValue.getValue(elem, type, outer);
                    }
                } else {
                    elements = new SourceExpression[list.size()];
                    list.toArray(elements);
                    JbValue.getDimensionality(elements, dimensions, 0);
                }
            }
            Object array = Array.newInstance(c, dimensions);
            if (elements != null) {
                JbValue.fillArray(array, elements, dimensions, 0, type, outer, c);
            }
            return array;
        }
        catch (Exception ex) {
            return null;
        }
    }

    static Object callMethod(SourceMethodCallExpression jMethodCall, CmtComponent outer, boolean doInvoke) {
        Object result = null;
        try {
            if (jMethodCall == null) {
                return null;
            }
            JbMethodCall jbMethodCall = new JbMethodCall(jMethodCall, outer);
            return doInvoke ? jbMethodCall.invoke() : jbMethodCall.getReturnType();
        }
        catch (Throwable t) {
            return result;
        }
    }

    private static URL getUnknownImageURL() {
        if (UNKNOWN_IMAGE == null) {
            UNKNOWN_IMAGE = CmtValue.class.getResource("images/unknownImage.gif");
        }
        return UNKNOWN_IMAGE;
    }
}

