/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.jdeveloper.cmt.CmtEventSet;
import oracle.jdeveloper.cmt.CmtMethodCall;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertySetting;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.cmtimpl.JbMethodCall;
import oracle.jdevimpl.cmtimpl.JbProperty;

final class JbPropertySetting
implements CmtPropertySetting {
    public static final String EVENT_SET_SUFFIX = "<es>";
    private CmtSubcomponent subcomponent;
    private CmtProperty property;
    private JbMethodCall methodCall;
    private CmtValue value;
    private Object liveValue;
    private boolean isEventSetting;

    public JbPropertySetting(CmtSubcomponent subcomponent, CmtProperty property) {
        this.subcomponent = subcomponent;
        this.property = property;
    }

    public JbPropertySetting(CmtSubcomponent subcomponent, CmtProperty property, JbMethodCall methodCall) {
        this(subcomponent, property);
        this.setMethodCall(methodCall);
    }

    public JbPropertySetting(CmtSubcomponent subcomponent, CmtEventSet eventSet, JbMethodCall methodCall) {
        this(subcomponent, new JbProperty((JbComponent)eventSet.getComponent(), eventSet.getName() + EVENT_SET_SUFFIX, eventSet.getListenerType().getResolvedType(), eventSet.getAddListenerMethod()));
        this.isEventSetting = true;
        this.setMethodCall(methodCall);
    }

    @Override
    public boolean isEventSetting() {
        return this.isEventSetting || this.property != null && this.property.isEvent();
    }

    @Override
    public CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    @Override
    public CmtProperty getProperty() {
        return this.property;
    }

    @Override
    public CmtMethodCall getMethodCall() {
        return this.methodCall;
    }

    public void setMethodCall(JbMethodCall call) {
        CmtValue[] args;
        this.methodCall = call;
        if (this.methodCall != null && (args = this.methodCall.getArguments()) != null && args.length > 0) {
            this.updateValue(args[0]);
        }
    }

    @Override
    public String getValueSource() {
        return this.value != null ? this.value.getText() : "";
    }

    @Override
    public void setValueSource(String src) {
        try {
            this.value.setText(src);
            this.updateValue(this.value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Object getLiveValue() {
        return this.liveValue;
    }

    public SourceExpression getValueExpression() {
        return this.value != null ? this.value.getExpression() : null;
    }

    public String toString() {
        SourceMethodCallExpression jMethodCall = this.methodCall != null ? this.methodCall.getJotMethodCall() : null;
        return jMethodCall != null ? jMethodCall.getText() : "";
    }

    private void updateValue(CmtValue value) {
        this.value = value;
        if (this.isEventSetting || this.property != null && this.property.isEvent()) {
            return;
        }
        if (value != null) {
            try {
                this.liveValue = value.getValue(this.property.getType());
            }
            catch (CmtParseException e) {
                this.liveValue = null;
            }
        } else {
            this.liveValue = null;
        }
    }
}

