/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.audit.java.CreateJavaFileCommand;
import oracle.jdevimpl.audit.java.JavaHelper;

public class CreateTypeCommand
extends CreateJavaFileCommand {
    private String typeName;
    private int modifiers;
    Collection imports;
    private String[] superTypes;
    private String[] constructorTypes;
    private String body;
    protected static String COMMAND_NAME = "create-type-command";
    private static int commandId = 0;

    public CreateTypeCommand(URL url, String typeName, int modifiers, Collection imports, String body, Project project, Workspace workspace) {
        this(url, typeName, modifiers, imports, null, null, project, workspace);
        this.body = body;
    }

    public CreateTypeCommand(URL url, String typeName, int modifiers, Collection imports, String[] superTypes, String[] constructorTypes, Project project, Workspace workspace) {
        super(CreateTypeCommand.id(COMMAND_NAME), "Create " + URLFileSystem.getName((URL)url), url, project, workspace);
        this.typeName = typeName;
        this.modifiers = modifiers;
        this.imports = imports;
        this.superTypes = superTypes;
        this.constructorTypes = constructorTypes;
    }

    @Override
    protected void doCreateContents(SourceFile file, Project project, Workspace workspace) {
        SourceClass type;
        JavaManager manager = JavaManager.getJavaManager((Project)project);
        SourceFactory factory = file.getFactory();
        String className = this.typeName;
        int dot = this.typeName.lastIndexOf(46);
        if (dot > 0) {
            className = this.typeName.substring(dot + 1);
            file.setPackageName(this.typeName.substring(0, dot));
        }
        this.ensureImports(this.imports);
        if (this.body == null) {
            SourceInterfacesClause interfacesClause;
            SourceSuperclassClause superclassClause;
            int kind = Modifier.isInterface(this.modifiers) ? 1 : 0;
            SourceTypeReference superClass = null;
            ArrayList<SourceTypeReference> superInterfaces = new ArrayList<SourceTypeReference>();
            if (this.superTypes != null) {
                for (int i = 0; i < this.superTypes.length; ++i) {
                    JavaClass superType = manager.getClass(this.superTypes[i]);
                    if (superType == null) continue;
                    if (superType.isInterface()) {
                        superInterfaces.add(factory.createType(superType.getName()));
                    } else {
                        superClass = factory.createType(superType.getName());
                    }
                    this.ensureImport((JavaHasType)superType);
                }
            }
            if (!(type = factory.createClass(kind, className, null, superclassClause = factory.createSuperclassClause(superClass), interfacesClause = factory.createInterfacesClause(superInterfaces.toArray(new SourceTypeReference[superInterfaces.size()])), null)).isInterface() && this.constructorTypes != null && this.constructorTypes.length > 0) {
                JavaHelper.createConstructor(type, this.constructorTypes);
                this.ensureImports(this.constructorTypes);
            }
        } else {
            type = factory.createClass(this.body);
        }
        file.getSourceClasses().add(type);
        type.setModifiers(this.modifiers);
    }

    protected static int id(String name) {
        if (commandId == 0) {
            commandId = Ide.findOrCreateCmdID((String)name);
        }
        return commandId;
    }
}

