/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdevimpl.audit.java.CreateFileCommand;
import oracle.jdevimpl.audit.java.JavaHelper;

public abstract class CreateJavaFileCommand
extends CreateFileCommand {
    private boolean removeUnusedImports = true;
    private SourceFile file;

    public void setRemoveUnusedImports(boolean removeUnusedImports) {
        this.removeUnusedImports = removeUnusedImports;
    }

    protected CreateJavaFileCommand(int id, String name, URL url, Project project, Workspace workspace) {
        super(id, name, url, project, workspace);
    }

    protected abstract void doCreateContents(SourceFile var1, Project var2, Workspace var3) throws Exception;

    protected void ensureImport(JavaHasType hasType) {
        if (this.file == null) {
            throw new IllegalStateException("file == null");
        }
        if (hasType == null) {
            return;
        }
        if (hasType instanceof JavaType) {
            JavaType type = (JavaType)hasType;
            if (type.isPrimitive()) {
                return;
            }
            String packageName = type.getPackageName();
            if (packageName.equals("java.lang")) {
                return;
            }
            if (packageName.equals(this.file.getPackageName())) {
                return;
            }
            SourceImport impor = this.file.getFactory().createImportDeclaration(type.getQualifiedName());
            this.file.getSourceImports().add(impor);
        } else {
            JavaMember member = (JavaMember)hasType;
            JavaClass type = member.getOwningClass();
            String name = member.getName();
            SourceImport impor = this.file.getFactory().createImportDeclaration(8, type.getQualifiedName() + "." + name);
            this.file.getSourceImports().add(impor);
        }
    }

    protected void ensureImport(String typeName) {
        JavaHelper.addImport(this.file, typeName);
    }

    protected void ensureImports(Collection types) {
        if (types == null) {
            return;
        }
        Iterator i = types.iterator();
        while (i.hasNext()) {
            this.ensureImport((JavaHasType)i.next());
        }
    }

    protected void ensureImports(String[] typeNames) {
        if (typeNames == null) {
            return;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            this.ensureImport(typeNames[i]);
        }
    }

    protected JavaModel getJavaManager(Project project) {
        return JavaManager.getJavaManager((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCreateContents(URL url, Project project, Workspace workspace) throws Exception {
        JavaModel manager = this.getJavaManager(project);
        SourceFile file = manager.createSourceFile(url);
        if (file == null) {
            throw new IllegalStateException("file not created");
        }
        SourceTransaction transaction = file.beginTransaction();
        try {
            this.file = file;
            this.doCreateContents(file, project, workspace);
            this.file = null;
            transaction.savepoint();
            file.clearCompiledInfo();
            file.compile();
            if (this.removeUnusedImports) {
                this.removeUnusedImports(file);
            }
            transaction.commit();
            transaction = null;
        }
        finally {
            if (transaction != null) {
                transaction.abort();
            }
        }
        file.expire();
        manager.getCacheSupport().flushCache();
    }

    private void removeUnusedImports(SourceFile file) {
        List imports = file.getSourceImports();
        ArrayList<SourceImport> unusedImports = new ArrayList<SourceImport>();
        for (SourceImport impor : imports) {
            if (impor.isUsed()) continue;
            unusedImports.add(impor);
        }
        imports.removeAll(unusedImports);
    }
}

