/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigator.DeleteActionHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ideimpl.navigator.ConcurrencySupport;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeBuilder;
import oracle.ideimpl.navigator.delete.ui.UIUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.DialogsArb;

public class DirectoryDeleteActionHandler
extends DeleteActionHandler<RelativeDirectoryContextFolder> {
    private volatile IdeModelTree m_ideModel = null;
    private volatile JTree m_contentsTree = null;
    private volatile JTree m_errorTree = null;
    private JPanel m_detailsPanel = null;
    private JScrollPane m_detailsContents = null;
    private JLabel m_detailsHint = null;

    private boolean hasError() {
        return this.m_errorTree != null;
    }

    public DirectoryDeleteActionHandler(List<RelativeDirectoryContextFolder> list) {
        super(list);
        this.setDeleteStrategy(new DeleteFolderStrategy());
    }

    public DirectoryDeleteActionHandler(Context context) {
        super(context);
        this.setDeleteStrategy(new DeleteFolderStrategy());
    }

    private void buildWorkspaceContentsTree() {
        Runnable buildAppTreeRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IdeModelTreeBuilder treeBuilder = new IdeModelTreeBuilder();
                try {
                    for (RelativeDirectoryContextFolder f : DirectoryDeleteActionHandler.this.getNodes()) {
                        String relativePath = f.getRelativePath().replace('.', File.separatorChar);
                        URLPath urlPath = f.getRootDirectories();
                        for (URL url : urlPath.asList()) {
                            URL directoryUrl = URLFactory.newDirURL((URL)url, (String)relativePath);
                            treeBuilder.folder(FileSystemModelUtils.urlToFile((URL)directoryUrl));
                        }
                    }
                    DirectoryDeleteActionHandler.this.m_ideModel = treeBuilder.build();
                    DirectoryDeleteActionHandler.this.m_contentsTree = DirectoryDeleteActionHandler.this.m_ideModel.getTree();
                }
                catch (Throwable t) {
                    try {
                        DirectoryDeleteActionHandler.this.m_errorTree = UIUtils.createErrorTree((Throwable)t);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DirectoryDeleteActionHandler.this.m_detailsContents.setViewportView(DirectoryDeleteActionHandler.this.m_contentsTree);
                                if (DirectoryDeleteActionHandler.this.m_ideModel != null && DirectoryDeleteActionHandler.this.m_ideModel.hasOptionalItems()) {
                                    DirectoryDeleteActionHandler.this.m_detailsHint.setText(DeleteDialogArb.getString((int)28));
                                }
                                DirectoryDeleteActionHandler.this.deleteDetailsAvailable(true);
                                DirectoryDeleteActionHandler.this.clearStatus();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        ConcurrencySupport.getSharedExecutor().execute(buildAppTreeRunnable);
    }

    protected DeleteActionHandler.DetailsTextConfig getDetailsTextConfig() {
        return new DeleteActionHandler.DetailsTextConfigBuilder().title(DialogsArb.getString(20)).header(MessageFormat.format(DialogsArb.getString(21), this.getNodes().get(0))).description(DialogsArb.getString(22)).showDetails(DialogsArb.getString(23)).hideDetails(DialogsArb.getString(24)).confirmTitle(DeleteDialogArb.getString((int)26)).confirmMessage(DialogsArb.getString(27)).helpTopicId("f1_ideconfirmfolderdelete_html").build();
    }

    protected Component createDeleteDetailsComponent() {
        this.m_detailsPanel = new JPanel(new GridBagLayout());
        this.m_detailsHint = new JLabel();
        this.m_detailsContents = new JScrollPane();
        this.m_detailsPanel.add((Component)this.m_detailsContents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_detailsPanel.add((Component)this.m_detailsHint, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(4, 0, 8, 0), 0, 0));
        return this.m_detailsPanel;
    }

    protected void preLaunchDialog() {
        super.preLaunchDialog();
        this.deleteDetailsAvailable(false);
        this.setStatus(DialogsArb.getString(28), OracleIcons.getIcon((String)"throbber.gif"));
        this.buildWorkspaceContentsTree();
    }

    public boolean requireConfirm() {
        return true;
    }

    private class DeleteFolderStrategy
    extends DeleteActionHandler.DeleteStrategy<RelativeDirectoryContextFolder> {
        private DeleteFolderStrategy() {
        }

        public boolean delete(RelativeDirectoryContextFolder element) {
            if (!DirectoryDeleteActionHandler.this.hasError()) {
                String relativePath = element.getRelativePath().replace('.', File.separatorChar);
                URLPath urlPath = element.getRootDirectories();
                DeleteFileVisitor deleteFileVisitor = new DeleteFileVisitor();
                for (URL url : urlPath.asList()) {
                    URL directoryUrl = URLFactory.newDirURL((URL)url, (String)relativePath);
                    FileSystemModelUtils.deleteFolderRecursively((File)FileSystemModelUtils.urlToFile((URL)directoryUrl), (DeleteFileVisitor)deleteFileVisitor);
                }
                super.addAllToNondeleted(deleteFileVisitor.getUndeleted());
                return true;
            }
            return false;
        }
    }
}

