/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.common;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Wizard;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public abstract class BaliWizard
extends Wizard {
    protected JEWTDialog _dlg;
    protected Icon largeIcon;
    protected BaliWizardState state;
    protected String wizName = "Unnamed Wizard";

    protected BaliWizardState buildState(Context context) {
        return null;
    }

    protected JEWTDialog buildDialog(Context context, BaliWizardState state) {
        JPanel content = (JPanel)((Object)this.buildPanel(context, state));
        IdeMainWindow f = Ide.getMainWindow();
        int btnMask = 7;
        JEWTDialog dlg = new JEWTDialog((Frame)f, this.wizName, btnMask);
        dlg.setContent((Component)content);
        dlg.setTitle(this.getDialogTitle());
        DialogHeader header = new DialogHeader();
        header.setHeaderImage(this.getHeaderImage());
        header.setHeaderDescription(this.getHeaderDescription());
        dlg.setDialogHeader((Component)header);
        return dlg;
    }

    protected abstract BaliWizardPanel buildPanel(Context var1, BaliWizardState var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context) {
        Project project = context.getProject();
        boolean OKed = false;
        if (project != null) {
            this.state = this.buildState(context);
            if (this.state != null) {
                try {
                    JEWTDialog dlg = this.buildDialog(context, this.state);
                    final BaliWizardPanel panel = (BaliWizardPanel)((Object)dlg.getContent());
                    dlg.addVetoableChangeListener(new VetoableChangeListener(){

                        @Override
                        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                            String propName = evt.getPropertyName();
                            Object newValue = evt.getNewValue();
                            if (propName.equals("closed") && Boolean.TRUE.equals(newValue)) {
                                if (!panel.validateAndWriteToState(BaliWizard.this.state)) {
                                    throw new PropertyVetoException("panel", evt);
                                }
                                BaliWizard.this.finish();
                            }
                        }
                    });
                    this._dlg = dlg;
                    if (dlg != null) {
                        panel.initializeFromState(this.state);
                        OKed = WizardLauncher.runDialog((JDialog)dlg);
                    }
                }
                catch (Exception e) {
                }
                finally {
                    this.dispose();
                    if (!OKed) {
                        this.cancel();
                    }
                }
            }
        }
        this.state = null;
        return OKed;
    }

    public Icon getIcon() {
        return this.largeIcon;
    }

    public String getShortLabel() {
        return this.wizName;
    }

    public boolean isAvailable(Context context) {
        return context != null && context.getProject() != null;
    }

    public void commitAndFinish() {
        BaliWizardPanel pnl = (BaliWizardPanel)((Object)this._dlg.getContent());
        if (pnl != null && pnl.validateAndWriteToState(this.state)) {
            this.finish();
            this.dispose();
        }
    }

    private void dispose() {
        if (this._dlg != null) {
            this._dlg.dispose();
            this._dlg = null;
        }
    }

    protected void finish() {
        if (this.state != null) {
            final BaliWizardState wizardState = this.state;
            IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                @Override
                public void run() {
                    wizardState.commitWizardState();
                }
            });
        }
    }

    protected void cancel() {
    }

    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/simpleFile.png"));
    }

    protected String getHeaderTitle() {
        return this.getShortLabel();
    }

    protected String getHeaderDescription() {
        return null;
    }

    protected String getDialogTitle() {
        return StringUtils.stripMnemonic((String)this.wizName);
    }

    protected final void displayErrorMessage(String title, String msg, String helpID) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)msg, (String)title, (String)helpID);
    }
}

