/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.addin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;

class ExportDialog {
    private JRadioButton _radioSelection;
    private JRadioButton _clipboardButton;
    private JTextField _fileNameField;
    private JTextField _directoryField;
    private JCheckBox _lineNumbers;
    private JCheckBox _links;
    private static boolean _hadLineNumbers;
    private static boolean _hadLinks;

    ExportDialog() {
    }

    private JPanel init(boolean hasSelection, boolean hasMultiFile) {
        JPanel outputPanel;
        Insets insets = new Insets(2, 2, 2, 2);
        final JPanel panel = new JPanel(new GridBagLayout());
        if (hasMultiFile) {
            JLabel outputDirLabel = new JLabel();
            this._directoryField = new JTextField(40);
            ResourceUtils.resLabel((JLabel)outputDirLabel, (Component)this._directoryField, (String)"&Output Directory");
            JButton browse = new JButton("...");
            browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLChooser urlChooser = DialogUtil.newURLChooser();
                    urlChooser.setShowJarsAsDirs(false);
                    urlChooser.setSelectionScope(1);
                    JPanel parent = panel;
                    int ret = urlChooser.showSaveDialog((Component)parent, "Export");
                    if (ret == 0) {
                        URL selectedURL = urlChooser.getSelectedURL();
                        String platformPathName = URLFileSystem.getPlatformPathName((URL)selectedURL);
                        ExportDialog.this._directoryField.setText(platformPathName);
                    }
                }
            });
            outputPanel = new JPanel(new GridBagLayout());
            outputPanel.add((Component)outputDirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
            outputPanel.add((Component)this._directoryField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, insets, 0, 0));
            outputPanel.add((Component)browse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
        } else {
            if (hasSelection) {
                this._radioSelection = new JRadioButton();
                ResourceUtils.resButton((AbstractButton)this._radioSelection, (String)"&Selection");
                JRadioButton radioFile = new JRadioButton();
                ResourceUtils.resButton((AbstractButton)radioFile, (String)"Whole &File");
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this._radioSelection);
                buttonGroup.add(radioFile);
                this._radioSelection.setSelected(true);
                Box inputPanel = new Box(1);
                inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
                inputPanel.add(this._radioSelection);
                inputPanel.add(radioFile);
                panel.add((Component)inputPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 2, insets, 0, 0));
            }
            this._clipboardButton = new JRadioButton("Clipboard");
            final JRadioButton fileOutputButton = new JRadioButton("File:");
            ButtonGroup outputButtonGroup = new ButtonGroup();
            outputButtonGroup.add(this._clipboardButton);
            outputButtonGroup.add(fileOutputButton);
            this._clipboardButton.setSelected(true);
            this._fileNameField = new JTextField(40);
            fileOutputButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExportDialog.this._fileNameField.setEnabled(fileOutputButton.isSelected());
                }
            });
            this._fileNameField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    fileOutputButton.setSelected(true);
                    ExportDialog.this._fileNameField.setEnabled(true);
                    ExportDialog.this._fileNameField.requestFocus();
                }
            });
            JButton browse = new JButton("...");
            browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLChooser urlChooser = DialogUtil.newURLChooser();
                    urlChooser.clearChooseableURLFilters();
                    WildcardURLFilter urlFilter = new WildcardURLFilter("*.html", false, "HTML File");
                    urlChooser.addChooseableURLFilter((URLFilter)urlFilter);
                    urlChooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
                    JPanel parent = panel;
                    int ret = urlChooser.showSaveDialog((Component)parent, "Export");
                    if (ret == 0) {
                        URL selectedURL = urlChooser.getSelectedURL();
                        String platformPathName = URLFileSystem.getPlatformPathName((URL)selectedURL);
                        ExportDialog.this._fileNameField.setText(platformPathName);
                        fileOutputButton.setSelected(true);
                    }
                }
            });
            outputPanel = new JPanel(new GridBagLayout());
            outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
            outputPanel.add((Component)this._clipboardButton, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, insets, 0, 0));
            outputPanel.add((Component)fileOutputButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 0, insets, 0, 0));
            outputPanel.add((Component)this._fileNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 1, insets, 0, 0));
            outputPanel.add((Component)browse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 0, insets, 0, 0));
        }
        this._lineNumbers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._lineNumbers, (String)"Line &Numbers");
        this._lineNumbers.setSelected(_hadLineNumbers);
        this._links = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._links, (String)"Hyperlin&ks");
        this._links.setSelected(_hadLinks);
        panel.add((Component)outputPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, insets, 0, 0));
        panel.add((Component)this._lineNumbers, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        panel.add((Component)this._links, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        return panel;
    }

    public boolean runDialog(boolean hasSelection, boolean hasMultiFile) {
        JPanel panel = this.init(hasSelection, hasMultiFile);
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), "Export to HTML", 3);
        dialog.setContent((Component)panel);
        boolean ret = dialog.runDialog();
        _hadLineNumbers = this.isLineNumberSelected();
        _hadLinks = this.isLinksSelected();
        return ret;
    }

    public boolean isExportSelection() {
        return this._radioSelection != null && this._radioSelection.isSelected();
    }

    public boolean isExportToClipboard() {
        return this._clipboardButton != null && this._clipboardButton.isSelected();
    }

    public String getOutputFileName() {
        return this._fileNameField.getText();
    }

    public String getOutputDirectoryName() {
        return this._directoryField.getText();
    }

    public boolean isLineNumberSelected() {
        return this._lineNumbers.isSelected();
    }

    public boolean isLinksSelected() {
        return this._links.isSelected();
    }
}

