/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.model.ProjectDependencyFactory;
import oracle.jdeveloper.resource.JProjectArb;

class SelectDependenciesPanel
extends DefaultTraversablePanel {
    public static final String DEPENDENCIES_KEY = SelectDependenciesPanel.class.getName() + ".dependencies.key";
    public static final String PROJECT_URL_KEY = SelectDependenciesPanel.class.getName() + ".project.url";
    public static final String DEPENDABLE_UNDER_EDIT_KEY = SelectDependenciesPanel.class.getName() + ".active.dependable";
    public static final String WORKSPACE_KEY = "Application";
    private static final String HELP_TOPIC_ID = "f1_idededitdependencies_html";
    private final JWrappedLabel _headerText = new JWrappedLabel();
    private JMutableTreeNode _rootNode = new JMutableTreeNode();
    private final DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
    private final CustomJTree _depsTree = new CustomJTree((TreeModel)this._treeModel);
    private final JLabel _treeLabel = new JLabel();
    private final SearchField _searchField = new SearchField();
    private final EventAdapter _eventAdapter = new EventAdapter();
    private final ArrayList _expanded = new ArrayList();
    private transient Workspace _curWorkspace;
    private transient URL _curProjectURL;
    private transient List _deps;
    private Dependable _dependableUnderEdit;
    private JEWTDialog _dialog;

    public SelectDependenciesPanel() {
        try {
            this.jbInit();
            this.setHelpID(HELP_TOPIC_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setInstructionText(String text) {
        this._headerText.setText(text);
    }

    void setDialog(JEWTDialog dialog) {
        this._dialog = dialog;
    }

    private void jbInit() throws Exception {
        this.setDefaultTitle(JProjectArb.getString((int)177));
        this._headerText.setForeground(Colors.HINT_TEXT);
        this._headerText.setText(JProjectArb.getString((int)187));
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._depsTree, (String)JProjectArb.getString((int)188));
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.setPrompt(JProjectArb.getString((int)189));
        this._searchField.addSearchListener((SearchListener)this._eventAdapter);
        this._depsTree.getSelectionModel().setSelectionMode(1);
        this._depsTree.setRootVisible(false);
        this._depsTree.setShowsRootHandles(true);
        this._depsTree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this._depsTree.setScrollsOnExpand(true);
        this._depsTree.setPropagateCheckState(false);
        this._depsTree.addTreeExpansionListener((TreeExpansionListener)this._eventAdapter);
        this._depsTree.addTreeCellCheckedListener((TreeCellCheckedListener)this._eventAdapter);
        JScrollPane treeScroller = new JScrollPane((Component)this._depsTree);
        ComponentWithTitlebar titledTree = new ComponentWithTitlebar((JComponent)treeScroller, this._treeLabel, null);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._headerText, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this._searchField, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 150, 0));
        this.add((Component)titledTree, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        this._curProjectURL = (URL)dataContext.get(PROJECT_URL_KEY);
        this._curWorkspace = (Workspace)dataContext.get(WORKSPACE_KEY);
        this._deps = (List)dataContext.get(DEPENDENCIES_KEY);
        if (dataContext.contains(DEPENDABLE_UNDER_EDIT_KEY)) {
            this._dependableUnderEdit = (Dependable)dataContext.get(DEPENDABLE_UNDER_EDIT_KEY);
        }
        this.initTree(this._curWorkspace);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        dataContext.put(DEPENDENCIES_KEY, (Object)this._deps);
    }

    private void initTree(Workspace workspace) {
        Enumeration descendents = this.getExpandedProjects();
        this._rootNode = new JMutableTreeNode();
        this._rootNode.setUserObject((Object)workspace);
        this.addChildren((Element)workspace, this._rootNode);
        this._treeModel.setRoot((TreeNode)this._rootNode);
        this.restoreOrInitExpandedTreeNodes(this._rootNode, descendents != null, this._expanded);
    }

    private Enumeration getExpandedProjects() {
        Enumeration descendents = this._depsTree.getExpandedDescendants(new TreePath(this._rootNode));
        if (descendents != null) {
            while (descendents.hasMoreElements()) {
                TreePath tp = (TreePath)descendents.nextElement();
                JMutableTreeNode node = (JMutableTreeNode)tp.getLastPathComponent();
                Object object = node.getUserObject();
                if (this._expanded.contains(object)) continue;
                this._expanded.add(object);
            }
        }
        return descendents;
    }

    private void restoreOrInitExpandedTreeNodes(JMutableTreeNode parent, boolean restore, ArrayList expandedElems) {
        Enumeration iter = parent.children();
        while (iter.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)iter.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof Element) {
                Element elem = (Element)userObject;
                boolean shouldExpand = false;
                if (restore && expandedElems.contains(elem)) {
                    shouldExpand = true;
                } else if (!restore && this.maybeSelected(elem)) {
                    shouldExpand = true;
                    if (!expandedElems.contains(elem)) {
                        expandedElems.add(elem);
                    }
                }
                if (shouldExpand) {
                    TreePath path = new TreePath(node.getPath());
                    this._depsTree.expandPath(path);
                }
            }
            if (node.isLeaf()) continue;
            this.restoreOrInitExpandedTreeNodes(node, restore, expandedElems);
        }
    }

    private static boolean isCurrentProject(Element child, URL curProjectURL) {
        return child instanceof Project && URLFileSystem.equals((URL)curProjectURL, (URL)((Project)child).getURL());
    }

    private boolean depsListContains(Dependable dependable) {
        return SelectDependenciesPanel.listContainsDependable(dependable, this._deps);
    }

    private static boolean listContainsDependable(Dependable dependable, List<Dependable> list) {
        if (list != null && list.size() > 0) {
            for (Dependable d : list) {
                if (!SelectDependenciesPanel.matches(d, dependable)) continue;
                return true;
            }
        }
        return false;
    }

    private static URL tryGetURL(Element element, Element parent) {
        if (element instanceof Profile && parent instanceof Project) {
            return DeployUtil.getProfileURL((DataContainer)((Project)parent), (Profile)element);
        }
        return element instanceof Locatable ? ((Locatable)element).getURL() : null;
    }

    private static boolean matches(Dependable dep, Dependable dep2) {
        if (dep == null || dep2 == null) {
            return false;
        }
        URL url1 = SelectDependenciesPanel.tryGetURL(dep.getSource(), (Element)dep.getSourceOwner());
        URL url2 = SelectDependenciesPanel.tryGetURL(dep2.getSource(), (Element)dep2.getSourceOwner());
        return URLFileSystem.equals((URL)url1, (URL)url2);
    }

    private boolean maybeSelected(Element elem) {
        if (this._deps != null && !this._deps.isEmpty()) {
            for (Dependable next : this._deps) {
                if (next == null || elem != next.getSource() && elem != next.getSourceOwner()) continue;
                return true;
            }
        }
        return false;
    }

    protected void addChildren(Element parentElement, JMutableTreeNode parentTreeNode) {
        for (Dependable dep : DependableGatherer.getChildDependables(parentElement)) {
            JMutableTreeNode depNode;
            JMutableTreeNode depenableParent;
            TriStateBoolean isSelected = TriStateBoolean.getState((boolean)this.depsListContains(dep));
            Element source = dep.getSource();
            if (source instanceof Project) {
                if (this._dependableUnderEdit == null && SelectDependenciesPanel.isCurrentProject(source, this._curProjectURL)) continue;
                DependableCellData projectData = new DependableCellData(source.getIcon(), source.getShortLabel(), false);
                JMutableTreeNode projectNode = new JMutableTreeNode(projectData){

                    public boolean isLeaf() {
                        return !this.allowsChildren;
                    }
                };
                projectNode.setUserObject((Object)source);
                parentTreeNode.add((MutableTreeNode)projectNode);
                depenableParent = projectNode;
                if (this._dependableUnderEdit != null && SelectDependenciesPanel.isCurrentProject(source, this._curProjectURL)) continue;
                String label = JProjectArb.getString((int)190);
                DependableCellData cellData = new DependableCellData(OracleIcons.getIcon((String)"make.png"), label, true, isSelected);
                depNode = new JMutableTreeNode((JTreeCellData)cellData);
            } else {
                if (this._dependableUnderEdit != null && SelectDependenciesPanel.matches(this._dependableUnderEdit, dep)) continue;
                DependableCellData cellData = new DependableCellData(source.getIcon(), source.getShortLabel(), true, isSelected);
                depNode = new JMutableTreeNode((JTreeCellData)cellData);
                depenableParent = parentTreeNode;
            }
            depNode.setUserObject((Object)dep);
            depenableParent.add((MutableTreeNode)depNode);
        }
    }

    private void setDialogOkButtonEnabled(boolean enabled) {
        if (this._dialog != null) {
            this._dialog.setOKButtonEnabled(enabled);
        }
    }

    private static class DependableCellData
    extends JTreeCellData {
        private boolean _childrenLoaded = false;

        public DependableCellData(Icon icon, String text, boolean hasCheckBox) {
            super(icon, text, hasCheckBox);
        }

        public DependableCellData(Icon icon, String text, boolean hasCheckBox, TriStateBoolean checkBoxState) {
            super(icon, text, hasCheckBox, checkBoxState);
        }

        void setChildrenLoaded(boolean loaded) {
            this._childrenLoaded = loaded;
        }

        boolean isChildrenLoaded() {
            return this._childrenLoaded;
        }
    }

    private static class DependableGatherer {
        private DependableGatherer() {
        }

        private static List<Dependable> getChildDependables(Element parentElement) {
            ArrayList<Dependable> list;
            block14: {
                Profile[] profiles;
                block13: {
                    if (!parentElement.mayHaveChildren()) {
                        return Collections.emptyList();
                    }
                    list = new ArrayList<Dependable>();
                    if (!(parentElement instanceof Workspace)) break block13;
                    ArrayList<Element> sortedList = new ArrayList<Element>();
                    Iterator children = parentElement.getChildren();
                    while (children.hasNext()) {
                        sortedList.add((Element)children.next());
                    }
                    Collections.sort(sortedList, new Comparator<Element>(){

                        @Override
                        public int compare(Element o1, Element o2) {
                            return o1.getShortLabel().compareToIgnoreCase(o2.getShortLabel());
                        }
                    });
                    for (Element childElement : sortedList) {
                        if (!ProjectDependencyFactory.hasFactory((Element)childElement)) continue;
                        try {
                            Dependable d = ProjectDependencyFactory.findOrCreate((Element)childElement, (Folder)((Folder)parentElement));
                            if (d == null || SelectDependenciesPanel.listContainsDependable(d, list)) continue;
                            list.add(d);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break block14;
                }
                if (!(parentElement instanceof Profile)) {
                    Iterator children;
                    if (parentElement instanceof Project) {
                        ResourcePaths resourcePaths = ResourcePaths.getInstance((PropertyStorage)((Project)parentElement));
                        children = resourcePaths.getResourcesContentSet().nodeIterator("");
                    } else {
                        children = parentElement.getChildren();
                    }
                    while (children.hasNext()) {
                        Element child = (Element)children.next();
                        if (!ProjectDependencyFactory.hasFactory((Element)child) && !Deployment.isDeploymentContainerProfile(child)) continue;
                        try {
                            Dependable d = ProjectDependencyFactory.findOrCreate((Element)child, (Folder)((Folder)parentElement));
                            if (d == null || SelectDependenciesPanel.listContainsDependable(d, list)) continue;
                            list.add(d);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (!(parentElement instanceof Project)) break block14;
                Project project = (Project)parentElement;
                DeploymentProfiles mgr = DeploymentProfiles.getInstance((DataContainer)project);
                for (Profile profile : profiles = mgr.getProfiles()) {
                    DependableGatherer.addProfileDependable(profile, parentElement, list);
                    if (!profile.mayHaveChildren()) continue;
                    Iterator iter = profile.getChildren();
                    while (iter != null && iter.hasNext()) {
                        Profile childProfile = (Profile)iter.next();
                        DependableGatherer.addProfileDependable(childProfile, parentElement, list);
                    }
                }
            }
            return list;
        }

        private static void addProfileDependable(Profile profile, Element parentElement, List<Dependable> list) {
            try {
                Dependable d = Deployment.getDependableFactory().findOrCreate((Element)profile, (Folder)parentElement);
                if (d != null && !SelectDependenciesPanel.listContainsDependable(d, list)) {
                    list.add(d);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class EventAdapter
    implements SearchListener,
    TreeCellCheckedListener,
    TreeExpansionListener {
        private EventAdapter() {
        }

        public void searchPerformed(SearchEvent se) {
            String text = se.isFromClear() ? "" : se.getSearchText();
            this.applyTreeFilter(text);
        }

        public void searchCategoryChanged(SearchEvent se) {
        }

        private void applyTreeFilter(String filterText) {
            if ((filterText == null || filterText.length() == 0) && SelectDependenciesPanel.this._treeModel != null) {
                SelectDependenciesPanel.this._depsTree.setModel((TreeModel)SelectDependenciesPanel.this._treeModel);
                SelectDependenciesPanel.this.restoreOrInitExpandedTreeNodes(SelectDependenciesPanel.this._rootNode, true, SelectDependenciesPanel.this._expanded);
            } else {
                SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)filterText, (boolean)true, (boolean)false);
                JMutableTreeNode newRoot = this.cloneTree(SelectDependenciesPanel.this._rootNode);
                this.filter(newRoot, matcher);
                SelectDependenciesPanel.this._depsTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)newRoot));
                SelectDependenciesPanel.this.restoreOrInitExpandedTreeNodes(newRoot, true, SelectDependenciesPanel.this._expanded);
                for (int i = 0; i < SelectDependenciesPanel.this._depsTree.getRowCount(); ++i) {
                    TreePath path = SelectDependenciesPanel.this._depsTree.getPathForRow(i);
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!matcher.matches((CharSequence)String.valueOf(last))) continue;
                    SelectDependenciesPanel.this._depsTree.setSelectionRow(i);
                    SelectDependenciesPanel.this._depsTree.scrollPathToVisible(path);
                    return;
                }
                if (SelectDependenciesPanel.this._depsTree.getRowCount() > 0) {
                    SelectDependenciesPanel.this._depsTree.setSelectionRow(0);
                }
            }
        }

        private JMutableTreeNode cloneTree(JMutableTreeNode root) {
            if (root != null) {
                JMutableTreeNode newRoot = new JMutableTreeNode(root.getModel(), root.getAllowsChildren());
                newRoot.setUserObject(root.getUserObject());
                for (int i = 0; i < root.getChildCount(); ++i) {
                    JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                    JMutableTreeNode newChild = this.cloneTree(child);
                    if (newChild == null) continue;
                    newRoot.add((MutableTreeNode)newChild);
                }
                return newRoot;
            }
            return null;
        }

        private void filter(JMutableTreeNode root, SearchMatcher matcher) {
            ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                if (matcher.matches((CharSequence)String.valueOf(child.getModel().getText()))) continue;
                nodesToRemove.add(i);
            }
            int removedCount = 0;
            Iterator i$ = nodesToRemove.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                root.remove(i - removedCount++);
            }
        }

        public void cellChecked(TreeCellCheckedEvent e) {
            JMutableTreeNode node = (JMutableTreeNode)e.getSource();
            try {
                Dependable dep = (Dependable)node.getUserObject();
                this.handleCellChecked(node, dep);
                SelectDependenciesPanel.this.setDialogOkButtonEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void cellUnchecked(TreeCellCheckedEvent e) {
            if (SelectDependenciesPanel.this._deps != null) {
                JMutableTreeNode node = (JMutableTreeNode)e.getSource();
                this.removeDependency(node);
                SelectDependenciesPanel.this.setDialogOkButtonEnabled(true);
            }
        }

        private void removeDependency(JMutableTreeNode node) {
            Dependable d = (Dependable)node.getUserObject();
            for (int i = 0; i < SelectDependenciesPanel.this._deps.size(); ++i) {
                Dependable dep = (Dependable)SelectDependenciesPanel.this._deps.get(i);
                if (!SelectDependenciesPanel.matches(dep, d)) continue;
                SelectDependenciesPanel.this._deps.remove(i);
                break;
            }
        }

        private void handleCellChecked(JMutableTreeNode node, Dependable dep) {
            if (SelectDependenciesPanel.this._deps == null) {
                SelectDependenciesPanel.this._deps = new ArrayList();
                SelectDependenciesPanel.this._deps.add(dep);
            } else if (!SelectDependenciesPanel.this.depsListContains(dep)) {
                boolean profileNodeSelected = dep.getSource() instanceof Profile;
                JMutableTreeNode parent = (JMutableTreeNode)node.getParent();
                boolean removed = false;
                Enumeration e = parent.children();
                while (e.hasMoreElements()) {
                    JMutableTreeNode childNode = (JMutableTreeNode)e.nextElement();
                    if (!childNode.getModel().getCheckBoxState().isTrue()) continue;
                    Dependable dependable = (Dependable)childNode.getUserObject();
                    boolean isProfileNode = dependable.getSource() instanceof Profile;
                    if ((!profileNodeSelected || isProfileNode) && (profileNodeSelected || !isProfileNode)) continue;
                    childNode.getModel().setCheckBoxState(false);
                    this.removeDependency(childNode);
                    removed = true;
                    if (!profileNodeSelected) continue;
                    break;
                }
                if (removed) {
                    this.maybeConfirm();
                }
                SelectDependenciesPanel.this._deps.add(dep);
            }
        }

        private void maybeConfirm() {
            MessageDialog.optionalInformation((String)"confirm-mutually-exclusive-dependencies", (Component)((Object)SelectDependenciesPanel.this), (String)JProjectArb.getString((int)192), (String)JProjectArb.getString((int)191), null);
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            final JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) {
                if (!SelectDependenciesPanel.this._expanded.contains(node.getUserObject())) {
                    SelectDependenciesPanel.this._expanded.add(node.getUserObject());
                }
                Ide.getWaitCursor().show();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DependableCellData cellModel;
                        if (node.getChildCount() <= 1 && !(cellModel = (DependableCellData)node.getModel()).isChildrenLoaded()) {
                            SelectDependenciesPanel.this.addChildren((Element)node.getUserObject(), node);
                            cellModel.setChildrenLoaded(true);
                            ((DefaultTreeModel)SelectDependenciesPanel.this._depsTree.getModel()).reload((TreeNode)node);
                        }
                        Ide.getWaitCursor().hide();
                    }
                });
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
            if (SelectDependenciesPanel.this._expanded.contains(node.getUserObject())) {
                SelectDependenciesPanel.this._expanded.remove(node.getUserObject());
            }
        }
    }
}

