/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.File;
import java.net.URL;
import javax.naming.InitialContext;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ResourcePathsMigrator;
import oracle.ide.model.WorkingSetsMigratorHelper;
import oracle.ide.model.Workspace;
import oracle.ide.model.WorkspaceMigrator;
import oracle.ide.model.panels.ProjectContentNavigable;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.library.ProjectLibraryMigrator;
import oracle.jdeveloper.model.JProjectDependencyPanel;
import oracle.jdeveloper.model.JProjectLibrariesPanel;
import oracle.jdeveloper.model.JProjectPanel;
import oracle.jdeveloper.model.JavaContentSetHelper;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.Jpr10120to101301;
import oracle.jdeveloper.model.LibraryObserver;
import oracle.jdeveloper.model.OutputDirectoryMigrator;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.TechnologiesPanel;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdeveloper.resource.TechArb;
import oracle.jdeveloper.resources.GenericPanel;
import oracle.jdeveloper.resources.ResourcesPanel;

final class JavaEditionAddin
implements Addin {
    private static final String PROJECT_XML_ROOT_ELEMENT_NAME = "project";
    private static final String WORKSPACE_XML_ROOT_ELEMENT_NAME = "workspace";

    JavaEditionAddin() {
    }

    public void initialize() {
        this.registerProjectChangeListeners();
        this.registerJavaContentSet();
        this.registerResourcesContentSetProvider();
        this.registerRecognizerExtensions();
        this.registerNodeMigrators();
        if (Ide.getIdeArgs().getCreateUI()) {
            this.registerProjectPropertyPanels();
        }
    }

    private void registerResourcesContentSetProvider() {
        ContentSetProvider resourcesContentSetProvider = new ContentSetProvider("oracle.ide.model.ResourcePaths/resourcesContentSet", ModelArb.getString((int)7)){

            public void initContentSet(ContentSet contentSet, URL projectDir, Context context) {
                contentSet.getURLPath().add(projectDir);
                PatternFilters filters = contentSet.getPatternFilters();
                filters.addInclude("*");
            }

            public Navigable getNavigable() {
                return new Navigable(ModelArb.getString((int)137), ResourcesPanel.class){

                    public DefaultMutableTreeNode createTreeNode(NavigableContext nc) {
                        boolean isDefaultProject = ProjectSettingsTraversablePanel.isDefaultProject((Namespace)nc.getScope());
                        return isDefaultProject ? null : super.createTreeNode(nc);
                    }
                };
            }
        };
        ProjectContent.registerContentSetProvider((ContentSetProvider)resourcesContentSetProvider);
    }

    private void registerProjectChangeListeners() {
        Jpr10120to101301.init();
        LibraryObserver.init();
        JavaProject.init();
    }

    private void registerJavaContentSet() {
        ContentSetProvider javaContentSetProvider = new ContentSetProvider(PathsConfiguration.JAVA_CONTENT_SET_KEY, ModelArb.getString((int)51)){

            public boolean displayFoldersAsPackages() {
                return true;
            }

            public boolean canContainJavaSources() {
                return true;
            }

            public void initContentSet(ContentSet contentSet, URL projectDir, Context context) {
                if (contentSet.getURLPath().getEntries().length == 0) {
                    URL srcDir = URLFactory.newDirURL((URL)projectDir, (String)"src");
                    contentSet.getURLPath().add(srcDir);
                }
                PatternFilters filters = contentSet.getPatternFilters();
                filters.addInclude("**");
            }

            public Navigable getNavigable() {
                return new Navigable(JProjectArb.getString((int)133), JProjectPanel.class);
            }

            public ContentSetHelper getContentSetHelper() {
                return new JavaContentSetHelper(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            }
        };
        ProjectContent.registerContentSetProvider((ContentSetProvider)javaContentSetProvider);
        ProjectContentNavigable.setDefaultContentSet((String)PathsConfiguration.JAVA_CONTENT_SET_KEY);
        AddContentCommand.registerPreferredContentSet(JavaSourceNode.class, (String)PathsConfiguration.JAVA_CONTENT_SET_KEY);
        NewEmptyProjectCommand.registerProjectInitializer(new NewEmptyProjectCommand.ProjectInitializer(){

            @Override
            public void initializeProject(Project newProject, Workspace workspace) {
                JavaProject javaProject = JavaProject.getInstance((Project)newProject);
                if (!javaProject.containsKey(JavaProject.OUTPUT_DIRECTORY)) {
                    URL projectDir = URLFileSystem.getParent((URL)newProject.getURL());
                    URL outputDir = URLFactory.newDirURL((URL)projectDir, (String)"classes");
                    javaProject.setOutputDirectory(outputDir);
                }
            }
        });
    }

    private void registerRecognizerExtensions() {
        ImageNode.init();
        Object2Dom.registerNamespaceElem(Project.class, (String)XMLUtil.toNamespaceURI((String)"jproject"), (String)PROJECT_XML_ROOT_ELEMENT_NAME);
        String jprojectClass = "oracle.jdeveloper.model.JProject";
        String ideHomeDir = Ide.getProductHomeDirectory();
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", null, (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902beta-to-902rc.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/902rc/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902rc-to-902.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/902/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-902-to-903preview.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/903preview/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-903preview-to-903.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/903/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-903-to-904.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/904/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-904-to-905.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/905/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-905-to-9051.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/9051/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-9051-to-10120.xsl")));
        Object2Dom.registerTransform((String)"oracle.jdeveloper.model.JProject", (String)"http://xmlns.oracle.com/jdeveloper/10120/jproject", (String)PROJECT_XML_ROOT_ELEMENT_NAME, (URL)URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jpr-10120-to-10130.xsl")));
        String workspaceClass = Workspace.class.getName();
        URL initialJwsXslt = URLFactory.newFileURL((File)new File(ideHomeDir, "bin/jws-10120-to-10130.xsl"));
        Object2Dom.registerTransform((String)workspaceClass, null, (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/902rc/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/902/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/903preview/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/903/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/904/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/905/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/9051/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
        Object2Dom.registerTransform((String)workspaceClass, (String)"http://xmlns.oracle.com/jdeveloper/10120/workspace", (String)WORKSPACE_XML_ROOT_ELEMENT_NAME, (URL)initialJwsXslt);
    }

    private void registerProjectPropertyPanels() {
        ProjectContentNavigable projectContentNavigable = new ProjectContentNavigable(){

            protected Navigable getGenericNavigable(String label, String contentSetKey) {
                return GenericPanel.getNavigable(label, contentSetKey);
            }
        };
        ProjectPropertiesDialog.addPanel((Navigable)projectContentNavigable);
        ProjectPropertiesDialog.addPanel((Navigable)new Navigable(JProjectArb.getString((int)121), JProjectLibrariesPanel.class));
        ProjectPropertiesDialog.addPanel((Navigable)new CustomNavigable(JProjectArb.getString((int)174), JProjectDependencyPanel.class));
        ProjectPropertiesDialog.addPanel((Navigable)new CustomNavigable(TechArb.getString(0), TechnologiesPanel.class));
    }

    private void registerNodeMigrators() {
        InitialContext ic = Names.newInitialContext();
        Names.bind((javax.naming.Context)ic, (String)WorkspaceMigrator.MIGRATOR_NAME, (Object)new WorkspaceMigrator());
        ProjectMigrator projectMigrator = new ProjectMigrator();
        Names.bind((javax.naming.Context)ic, (String)ProjectMigrator.MIGRATOR_NAME, (Object)projectMigrator);
        Names.bind((javax.naming.Context)ic, (String)"oracle.jdeveloper.model.JProject", (Object)projectMigrator);
        ResourcePathsMigrator migrator = ResourcePathsMigrator.getInstance();
        projectMigrator.addHelper((NodeMigratorHelper)migrator);
        ProjectLibraryMigrator libMigrator = ProjectLibraryMigrator.getInstance();
        projectMigrator.addHelper((NodeMigratorHelper)libMigrator);
        NodeMigrator workspaceMigrator = NodeMigrator.getNodeMigrator((String)WorkspaceMigrator.MIGRATOR_NAME);
        if (workspaceMigrator != null) {
            workspaceMigrator.addHelper((NodeMigratorHelper)WorkingSetsMigratorHelper.getInstance());
        }
        projectMigrator.addHelper((NodeMigratorHelper)OutputDirectoryMigrator.getInstance());
    }

    private static class CustomNavigable
    extends Navigable {
        public CustomNavigable(String shortLabel, Class traversableClass) {
            super(shortLabel, traversableClass);
        }

        public DefaultMutableTreeNode createTreeNode(NavigableContext nc) {
            boolean isDefaultProject = ProjectSettingsTraversablePanel.isDefaultProject((Namespace)nc.getScope());
            return isDefaultProject ? null : super.createTreeNode(nc);
        }
    }
}

