/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.ContentSetPanel;
import oracle.jdeveloper.model.ContentSetValidator;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.SourceRootHelper;
import oracle.jdeveloper.resource.ModelArb;

public class JavaContentValidator
implements ContentSetValidator {
    private ProgressBar _progressBar;
    private ContentSetPanel _projectContentPanel;
    private static final List<SourceRootHelper> SOURCE_ROOT_HELPERS = new ArrayList<SourceRootHelper>(5);

    void setProgressBar(ProgressBar progressBar) {
        this._progressBar = progressBar;
    }

    public static void registerSourceRootHelper(SourceRootHelper helper) {
        if (helper != null && !SOURCE_ROOT_HELPERS.contains(helper)) {
            SOURCE_ROOT_HELPERS.add(helper);
        }
    }

    public static void unRegisterSourceRootHelper(SourceRootHelper helper) {
        if (helper != null && SOURCE_ROOT_HELPERS.contains(helper)) {
            SOURCE_ROOT_HELPERS.remove(helper);
        }
    }

    static SourceRootHelper[] getRegisteredSourceRootHelpers() {
        SourceRootHelper[] helpers = new SourceRootHelper[SOURCE_ROOT_HELPERS.size()];
        SOURCE_ROOT_HELPERS.toArray(helpers);
        return helpers;
    }

    @Override
    public void validateAndProcessURLs(ContentSetPanel panel, URL[] urls) {
        this._projectContentPanel = panel;
        Map<URL, List<URL>> results = this.processURLs(urls);
        if (this._progressBar != null && this._progressBar.hasUserCancelled()) {
            JProjectUtil.notifyCanceled();
            return;
        }
        if (results.keySet().size() == 0) {
            String title = ModelArb.getString((int)128);
            String message = ModelArb.getString((int)129);
            if (MessageDialog.confirm((Component)this.getParentComponent(), (Object)message, (String)title, null)) {
                for (int i = 0; i < urls.length; ++i) {
                    URL contentFolderURL = urls[i];
                    this._projectContentPanel.addFolderToContentSet(contentFolderURL);
                }
            }
            return;
        }
        if (this.userConfirmed(results)) {
            for (URL selectedFolder : results.keySet()) {
                List<URL> roots = results.get(selectedFolder);
                for (URL srcRoot : roots) {
                    if (selectedFolder.toString().length() < srcRoot.toString().length()) {
                        this._projectContentPanel.addFolderToContentSet(srcRoot);
                        continue;
                    }
                    this._projectContentPanel.addFolderToContentSet(selectedFolder, srcRoot);
                }
            }
        }
    }

    private boolean userConfirmed(Map<URL, List<URL>> results) {
        boolean mustConfirm = false;
        block0: for (URL selectedFolder : results.keySet()) {
            List<URL> roots = results.get(selectedFolder);
            for (URL rootURL : roots) {
                if (selectedFolder.toString().length() >= rootURL.toString().length()) continue;
                mustConfirm = true;
                continue block0;
            }
        }
        if (!mustConfirm) {
            return true;
        }
        ArrayList<SelectableURL> toConfirm = new ArrayList<SelectableURL>();
        URL firstURL = null;
        for (URL selectedFolder : results.keySet()) {
            if (firstURL == null) {
                firstURL = selectedFolder;
            }
            List<URL> rootFolders = results.get(selectedFolder);
            for (URL folder : rootFolders) {
                SelectableURL f = new SelectableURL(folder, true);
                if (toConfirm.contains(f)) continue;
                toConfirm.add(f);
            }
            SelectableURL selected = new SelectableURL(selectedFolder, false);
            if (toConfirm.contains(selected)) continue;
            toConfirm.add(selected);
            rootFolders.add(selectedFolder);
        }
        Collections.sort(toConfirm, new SelectableComparator());
        boolean userConfirmed = false;
        int toConfirmCount = toConfirm.size();
        if (toConfirmCount > 0) {
            String title = ModelArb.getString((int)119);
            int numRoots = toConfirm.size();
            if (numRoots == 1) {
                String path = URLFileSystem.getPlatformPathName((URL)firstURL);
                String message = ModelArb.format((int)120, (Object)path);
                userConfirmed = MessageDialog.confirm((Component)this.getParentComponent(), (Object)message, (String)title, null);
            } else {
                ConfirmPanel confirmPanel = new ConfirmPanel(toConfirm);
                List selectedURLs = confirmPanel.runDialog(this.getParentComponent(), title);
                if (selectedURLs.size() > 0) {
                    for (URL root : results.keySet()) {
                        List<URL> dirs = results.get(root);
                        dirs.retainAll(selectedURLs);
                    }
                    userConfirmed = true;
                }
            }
        }
        return userConfirmed || toConfirmCount == 0;
    }

    private Component getParentComponent() {
        if (this._projectContentPanel != null) {
            return this._projectContentPanel;
        }
        return Ide.getMainWindow();
    }

    private boolean panelHasURL(URL url) {
        if (this._projectContentPanel != null) {
            return this._projectContentPanel.contentSetContainsURL(url);
        }
        return false;
    }

    private Map<URL, List<URL>> processURLs(final URL[] urls) {
        final HashMap<URL, List<URL>> map = new HashMap<URL, List<URL>>();
        class FindSrcRootProcess
        implements Runnable {
            public FindSrcRootProcess(Component parent) {
                String title = ModelArb.getString((int)131);
                if (JavaContentValidator.this._progressBar == null) {
                    JavaContentValidator.this._progressBar = new ProgressBar(parent, title, (Runnable)this, true);
                } else {
                    JavaContentValidator.this._progressBar.setRunnable((Runnable)this);
                }
            }

            public String start() {
                String description = ModelArb.getString((int)132);
                JavaContentValidator.this._progressBar.start(description, "");
                return "Process completed";
            }

            @Override
            public void run() {
                for (int i = 0; i < urls.length; ++i) {
                    URL selectedFolder = urls[i];
                    this.updateProgressBar(URLFileSystem.getPlatformPathName((URL)selectedFolder));
                    if (JavaContentValidator.this.panelHasURL(selectedFolder)) {
                        ArrayList<URL> list = new ArrayList<URL>(1);
                        list.add(selectedFolder);
                        map.put(selectedFolder, list);
                        continue;
                    }
                    URL[] folders = new URL[]{selectedFolder};
                    URL[] rootsArray = JProjectUtil.getSourceRoots((URL[])folders, (SourceRootHelper[])JavaContentValidator.getRegisteredSourceRootHelpers());
                    if (rootsArray.length <= 0) continue;
                    ArrayList<URL> roots = new ArrayList<URL>(Arrays.asList(rootsArray));
                    map.put(selectedFolder, roots);
                }
                JavaContentValidator.this._progressBar.setDoneStatus();
            }

            private void updateProgressBar(String text) {
                if (JavaContentValidator.this._progressBar != null && !JavaContentValidator.this._progressBar.hasUserCancelled()) {
                    JavaContentValidator.this._progressBar.updateProgress(null, text);
                }
            }
        }
        FindSrcRootProcess process = new FindSrcRootProcess(this.getParentComponent());
        process.start();
        return map;
    }

    Map<URL, List<URL>> processURLsAndConfirm(URL[] urls) {
        Map<URL, List<URL>> results = this.processURLs(urls);
        if (this.userConfirmed(results)) {
            return results;
        }
        return Collections.emptyMap();
    }

    private static class SelectableComparator
    implements Comparator<SelectableURL> {
        private URLComparator _urlComparator = new URLComparator();

        private SelectableComparator() {
        }

        @Override
        public int compare(SelectableURL o1, SelectableURL o2) {
            return this._urlComparator.compare((Object)(o1 != null ? o1._url : null), (Object)(o2 != null ? o2._url : null));
        }
    }

    private static class SelectableURL {
        URL _url;
        boolean _selected;

        public SelectableURL(URL url, boolean sel) {
            this._url = url;
            this._selected = sel;
        }

        void setSelected(boolean selected) {
            this._selected = selected;
        }

        boolean getSelected() {
            return this._selected;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SelectableURL)) {
                return false;
            }
            SelectableURL other = (SelectableURL)object;
            return this._url != null ? this._url.equals(other._url) : other._url == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._url == null ? 0 : this._url.hashCode());
            return result;
        }
    }

    private static class ConfirmPanel
    extends JPanel
    implements ActionListener,
    CheckBoxListItemStateListener {
        final CheckBoxListModel _model = new CheckBoxListModel();
        final CheckBoxList _rootList = new CheckBoxList();
        final JButton _selectAll = new JButton();
        final JButton _deselectAll = new JButton();
        boolean _updatingList = true;
        JEWTDialog _dialog;

        ConfirmPanel(List<SelectableURL> sourceRoots) {
            super(new GridBagLayout());
            Icon folderIcon = OracleIcons.getIcon((String)"folder.png");
            for (SelectableURL selectable : sourceRoots) {
                URL url = selectable._url;
                String label = URLFileSystem.getPlatformPathName((URL)url);
                this._model.addElement((Object)url, folderIcon, true, selectable._selected, label);
            }
            this._rootList.setModel((ListModel)this._model);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            JWrappedLabel explanatoryLabel = new JWrappedLabel(ModelArb.getString((int)122));
            explanatoryLabel.setPreferredAspectRatio(8.0f);
            JLabel foldersLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)foldersLabel, null, (String)ModelArb.getString((int)123));
            ResourceUtils.resButton((AbstractButton)this._selectAll, (String)ModelArb.getString((int)126));
            ResourceUtils.resButton((AbstractButton)this._deselectAll, (String)ModelArb.getString((int)127));
            this._selectAll.addActionListener(this);
            this._deselectAll.addActionListener(this);
            this._model.addCheckBoxStateListener((CheckBoxListItemStateListener)this);
            this._rootList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            int Y = -1;
            this.add((Component)explanatoryLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)foldersLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JScrollPane((Component)this._rootList), new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 5), 5, 0));
            this.add((Component)this._selectAll, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._deselectAll, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        }

        List runDialog(Component owner, String title) {
            this._dialog = JEWTDialog.createDialog((Component)owner, (String)title, (int)3);
            this._dialog.setResizable(true);
            this._dialog.setContent((Component)this);
            this._dialog.pack();
            boolean result = this._dialog.runDialog();
            this._dialog.dispose();
            if (result) {
                return this._model.getSelectionList();
            }
            return Collections.emptyList();
        }

        public void stateChanged(Object source) {
            if (this._selectAll == null || this._deselectAll == null) {
                return;
            }
            if (!this._updatingList) {
                this.enableButtons();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this._updatingList = true;
            Object source = e.getSource();
            if (source == this._selectAll) {
                this._model.selectAll();
                this.enableButtons();
            } else if (source == this._deselectAll) {
                this._model.deselectAll();
                this.enableButtons();
            }
            this._updatingList = false;
        }

        private void enableButtons() {
            int length = this._model.getSize();
            List list = this._model.getSelectionList();
            int selectedItems = list != null ? list.size() : 0;
            this._selectAll.setEnabled(selectedItems < length);
            this._deselectAll.setEnabled(selectedItems > 0);
            if (this._dialog != null) {
                this._dialog.setOKButtonEnabled(list != null);
            }
        }
    }
}

