/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.jdeveloper.model.SelectDependenciesPanel;
import oracle.jdeveloper.resource.JProjectArb;

public class DependencyPanel
extends DefaultTraversablePanel {
    public static final String PROPERTY_STORAGE_KEY = DependencyPanel.class.getName() + ".property.storage";
    public static final String PROJECT_URL_KEY = DependencyPanel.class.getName() + ".project.url";
    public static final String DEPENDABLE_UNDER_EDIT_KEY = DependencyPanel.class.getName() + ".dependable.under.edit";
    public static final String WORKSPACE_KEY = "Application";
    private static final String HELP_TOPIC_ID = "f1_idedprojsetdependencies_html";
    private final JLabel _noDepsLabel = new JLabel();
    private final JLabel _listLabel = new JLabel();
    private final JList _list = new JList();
    private final JButton _btnMoveFirst = new JButton();
    private final JButton _btnMoveUp = new JButton();
    private final JButton _btnMoveDown = new JButton();
    private final JButton _btnMoveLast = new JButton();
    private final JButton _btnAddEdit = new JButton();
    private final JButton _btnDelete = new JButton();
    private final EventHandler _eventListener = new EventHandler();
    private final DependableRenderer _cellRenderer = new DependableRenderer();
    private final SelectDependenciesPanel _selectDependenciesPanel = new SelectDependenciesPanel();
    private Dependable _activeDependable;
    private Set<URL> _children;
    private DepItem[] _depsArray;
    private URL _curProjectURL;
    private Workspace _curWorkspace;
    private JScrollPane _scrollPane = new JScrollPane(this._list);

    public DependencyPanel() {
        try {
            this.jbInit();
            this.setHelpID(HELP_TOPIC_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelectionDialogHelpId(String helpTopicId) {
        this._selectDependenciesPanel.setHelpID(helpTopicId);
    }

    public void setSelectionDialogInstruction(String text) {
        this._selectDependenciesPanel.setInstructionText(text);
    }

    public void onEntry(TraversableContext dataContext) {
        this._curProjectURL = (URL)dataContext.get(PROJECT_URL_KEY);
        this._curWorkspace = (Workspace)dataContext.get(WORKSPACE_KEY);
        PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
        if (dataContext.contains(DEPENDABLE_UNDER_EDIT_KEY)) {
            this._activeDependable = (Dependable)dataContext.get(DEPENDABLE_UNDER_EDIT_KEY);
        }
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
        List<DepItem> dependencies = this.wrapDependencies(dependencyConfiguration.getDependencyList());
        this._depsArray = dependencies.toArray(new DepItem[dependencies.size()]);
        this._list.setListData(this._depsArray);
        if (this._list.getSelectedIndex() == -1 && this._list.getModel().getSize() > 0) {
            this._list.setSelectedIndex(0);
        }
        this.updateScrollerComponent();
        this.enableButtons();
    }

    private Set getChildren() {
        if (this._children == null) {
            this._children = new HashSet<URL>();
            Iterator children = this._curWorkspace.getChildren();
            while (children.hasNext()) {
                Object next = children.next();
                if (!(next instanceof Project)) continue;
                this._children.add(((Project)next).getURL());
            }
        }
        return this._children;
    }

    public void onExit(TraversableContext dataContext) {
        if (this._depsArray != null) {
            PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
            DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
            dependencyConfiguration.setDependencyList(this.unwrapDependencies());
        }
    }

    private void enableButtons() {
        int selected = this._list.getSelectedIndex();
        this._btnAddEdit.setEnabled(this._curWorkspace.getListOfChildren().size() > 1);
        this._btnDelete.setEnabled(selected != -1);
        this._btnMoveFirst.setEnabled(selected > 0);
        this._btnMoveUp.setEnabled(selected > 0);
        this._btnMoveDown.setEnabled(selected >= 0 && selected < this._depsArray.length - 1);
        this._btnMoveLast.setEnabled(selected >= 0 && selected < this._depsArray.length - 1);
    }

    private void removeDependency(int index) {
        DepItem[] arr = new DepItem[this._depsArray.length - 1];
        System.arraycopy(this._depsArray, 0, arr, 0, index);
        System.arraycopy(this._depsArray, index + 1, arr, index, arr.length - index);
        this._depsArray = arr;
        this._list.setListData(this._depsArray);
        if (this._depsArray.length > 0) {
            int newIndex = Math.min(index, this._depsArray.length - 1);
            this._list.setSelectedIndex(newIndex);
        }
    }

    private void selectDependencies() {
        List newDeps;
        List<DepItem> dependencies;
        Object[] newDepsArray;
        Namespace data = new Namespace();
        data.put(WORKSPACE_KEY, (Object)this._curWorkspace);
        data.put(SelectDependenciesPanel.PROJECT_URL_KEY, (Object)this._curProjectURL);
        data.put(SelectDependenciesPanel.DEPENDENCIES_KEY, this.unwrapDependencies());
        data.put(SelectDependenciesPanel.DEPENDABLE_UNDER_EDIT_KEY, (Object)this._activeDependable);
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)this), JProjectArb.getString((int)186), (Traversable)this._selectDependenciesPanel, data);
        launcher.setInitialSize(new Dimension(475, 400));
        JEWTDialog dialog = launcher.initDialog();
        dialog.setOKButtonEnabled(false);
        this._selectDependenciesPanel.setDialog(dialog);
        int count = this._depsArray.length;
        boolean okResponse = dialog.runDialog();
        dialog.dispose();
        if (okResponse && !Arrays.equals(newDepsArray = (dependencies = this.wrapDependencies(newDeps = (List)data.find(SelectDependenciesPanel.DEPENDENCIES_KEY))).toArray(new DepItem[dependencies.size()]), this._depsArray)) {
            this._depsArray = newDepsArray;
            this._list.setListData(this._depsArray);
            int depsCount = this._depsArray.length;
            if (depsCount > 0 && count < this._depsArray.length - 1) {
                this._list.setSelectedIndex(count);
            }
            if (this._list.getSelectedIndex() == -1 && depsCount > 0) {
                this._list.setSelectedIndex(0);
            }
        }
    }

    private List<DepItem> wrapDependencies(List dependables) {
        if (dependables == null || dependables.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DepItem> depItems = new ArrayList<DepItem>(dependables.size());
        Iterator deps = dependables.iterator();
        while (deps.hasNext()) {
            depItems.add(new DepItem((Dependable)deps.next()));
        }
        return depItems;
    }

    private List<Dependable> unwrapDependencies() {
        if (this._depsArray == null || this._depsArray.length == 0) {
            return new ArrayList<Dependable>();
        }
        ArrayList<Dependable> deps = new ArrayList<Dependable>(this._depsArray.length);
        for (int i = 0; i < this._depsArray.length; ++i) {
            deps.add(this._depsArray[i]._dep);
        }
        return deps;
    }

    private void jbInit() throws Exception {
        this._noDepsLabel.setText(JProjectArb.getString((int)179));
        this._noDepsLabel.setForeground(Colors.HINT_TEXT);
        this._noDepsLabel.setHorizontalAlignment(0);
        this._noDepsLabel.setBackground(SystemColor.window);
        this._noDepsLabel.setOpaque(true);
        this._noDepsLabel.setFont(this._noDepsLabel.getFont().deriveFont(1, 14.0f));
        ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._list, (String)JProjectArb.getString((int)178));
        this._btnAddEdit.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this._btnAddEdit.setToolTipText(JProjectArb.getString((int)180));
        this._btnAddEdit.addActionListener(this._eventListener);
        this._btnDelete.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this._btnDelete.setToolTipText(JProjectArb.getString((int)181));
        this._btnDelete.addActionListener(this._eventListener);
        Insets buttonMargin = new Insets(2, 2, 2, 2);
        this._btnMoveFirst.setIcon(OracleIcons.getIcon((String)"first.png"));
        this._btnMoveFirst.setToolTipText(JProjectArb.getString((int)182));
        this._btnMoveFirst.addActionListener(this._eventListener);
        this._btnMoveFirst.setMargin(buttonMargin);
        this._btnMoveUp.setIcon(OracleIcons.getIcon((String)"previous.png"));
        this._btnMoveUp.setToolTipText(JProjectArb.getString((int)183));
        this._btnMoveUp.addActionListener(this._eventListener);
        this._btnMoveUp.setMargin(buttonMargin);
        this._btnMoveDown.setIcon(OracleIcons.getIcon((String)"next.png"));
        this._btnMoveDown.setToolTipText(JProjectArb.getString((int)184));
        this._btnMoveDown.addActionListener(this._eventListener);
        this._btnMoveDown.setMargin(buttonMargin);
        this._btnMoveLast.setIcon(OracleIcons.getIcon((String)"last.png"));
        this._btnMoveLast.setToolTipText(JProjectArb.getString((int)185));
        this._btnMoveLast.addActionListener(this._eventListener);
        this._btnMoveLast.setMargin(buttonMargin);
        this._list.setCellRenderer(this._cellRenderer);
        this._list.addListSelectionListener(this._eventListener);
        this._list.setSelectionMode(0);
        this._list.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ControlBar toolbar = new ControlBar();
        toolbar.add((Component)this._btnAddEdit);
        toolbar.add((Component)this._btnDelete);
        ComponentWithTitlebar titled = new ComponentWithTitlebar((JComponent)this._scrollPane, this._listLabel, toolbar);
        JPanel buttonPanel = new JPanel(new GridLayout(4, 1, 0, 5));
        buttonPanel.add(this._btnMoveFirst);
        buttonPanel.add(this._btnMoveUp);
        buttonPanel.add(this._btnMoveDown);
        buttonPanel.add(this._btnMoveLast);
        this.setLayout(new GridBagLayout());
        this.add((Component)titled, new GridBagConstraints(0, 0, 1, 5, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    private void updateScrollerComponent() {
        this._scrollPane.getViewport().setView(this._depsArray != null && this._depsArray.length > 0 ? this._list : this._noDepsLabel);
    }

    static /* synthetic */ DepItem[] access$1202(DependencyPanel x0, DepItem[] x1) {
        x0._depsArray = x1;
        return x1;
    }

    private class DependableRenderer
    extends DefaultListCellRenderer {
        private DependableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DepItem) {
                DepItem d = (DepItem)value;
                label.setIcon(d.getIcon());
                label.setText(d.toString());
            }
            return label;
        }
    }

    private class DepItem {
        Icon _icon;
        String _label;
        final Dependable _dep;

        DepItem(Dependable dependable) {
            this._dep = dependable;
        }

        private Icon getIcon() {
            if (this._icon == null) {
                this.getLabelAndIcon();
            }
            return this._icon;
        }

        private void getErrorOrWarningLabelAndIcon(Locatable locatable) {
            URL nextURL;
            Set children = DependencyPanel.this.getChildren();
            if (!children.contains(nextURL = locatable.getURL())) {
                if (URLFileSystem.exists((URL)nextURL)) {
                    this._icon = OracleIcons.getIcon((String)"warning.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)176));
                } else {
                    this._icon = OracleIcons.getIcon((String)"error.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)175));
                }
            }
        }

        private void getLabelAndIcon() {
            if (this._label != null || this._icon != null) {
                return;
            }
            if (this._dep.getSource() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSource());
            } else if (this._dep.getSourceOwner() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSourceOwner());
            }
            if (this._label == null) {
                this._label = this._dep.toString();
            }
            if (this._icon == null) {
                this._icon = this._dep.getSource() != null ? this._dep.getSource().getIcon() : OracleIcons.getIcon((String)"error.png");
            }
        }

        public String toString() {
            this.getLabelAndIcon();
            return this._label;
        }
    }

    private class EventHandler
    implements ActionListener,
    ListSelectionListener {
        private EventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            int index = DependencyPanel.this._list.getSelectedIndex();
            if (source == DependencyPanel.this._btnMoveFirst) {
                this.toTopOrBottom(index, true);
            }
            if (source == DependencyPanel.this._btnMoveUp) {
                this.swapAndSet(index, index - 1);
            } else if (source == DependencyPanel.this._btnMoveDown) {
                this.swapAndSet(index, index + 1);
            } else if (source == DependencyPanel.this._btnMoveLast) {
                this.toTopOrBottom(index, false);
            } else if (source == DependencyPanel.this._btnAddEdit) {
                DependencyPanel.this.selectDependencies();
                DependencyPanel.this.updateScrollerComponent();
            } else if (source == DependencyPanel.this._btnDelete) {
                DependencyPanel.this.removeDependency(index);
                DependencyPanel.this.updateScrollerComponent();
            }
        }

        private void swapAndSet(int currentIndex, int newIndex) {
            DepItem swap = DependencyPanel.this._depsArray[currentIndex];
            ((DependencyPanel)DependencyPanel.this)._depsArray[currentIndex] = DependencyPanel.this._depsArray[newIndex];
            ((DependencyPanel)DependencyPanel.this)._depsArray[newIndex] = swap;
            DependencyPanel.this._list.setListData(DependencyPanel.this._depsArray);
            DependencyPanel.this._list.setSelectedIndex(newIndex);
        }

        private void toTopOrBottom(int currentIndex, boolean top) {
            int firstIndex = 1;
            int lastIndex = DependencyPanel.this._depsArray.length;
            int selectionIndex = 0;
            if (!top) {
                --firstIndex;
                selectionIndex = --lastIndex;
            }
            DepItem[] reordered = new DepItem[DependencyPanel.this._depsArray.length];
            reordered[selectionIndex] = DependencyPanel.this._depsArray[currentIndex];
            int j = 0;
            for (int i = firstIndex; i < lastIndex; ++i) {
                if (j == currentIndex) {
                    // empty if block
                }
                int n = ++j;
                ++j;
                reordered[i] = DependencyPanel.this._depsArray[n];
            }
            DependencyPanel.access$1202(DependencyPanel.this, reordered);
            DependencyPanel.this._list.setListData(DependencyPanel.this._depsArray);
            DependencyPanel.this._list.setSelectedIndex(selectionIndex);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            DependencyPanel.this.enableButtons();
        }
    }
}

