/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

public final class DependencyCache {
    private final Workspace workspace;
    private boolean dirty = true;
    private WorkspaceObserver workspaceObserver = new WorkspaceObserver();
    private ProjectObserver projectObserver = new ProjectObserver();
    HashSet<Project> observedProjects = new HashSet();
    private final HashMap<Project, Collection<Project>> up = new HashMap();
    private final HashMap<Project, Collection<Project>> down = new HashMap();
    private static final HashMap<Workspace, DependencyCache> INSTANCES = new HashMap();
    private static final DependencyListener dependencyListener = new DependencyListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyCache getInstance(Context context) {
        HashMap<Workspace, DependencyCache> hashMap = INSTANCES;
        synchronized (hashMap) {
            Workspace workspace = context.getWorkspace();
            DependencyCache instance = INSTANCES.get(workspace);
            if (instance == null) {
                instance = new DependencyCache(workspace);
                INSTANCES.put(workspace, instance);
            }
            return instance;
        }
    }

    private DependencyCache(Workspace workspace) {
        this.workspace = workspace;
        if (workspace != null) {
            workspace.attach((Observer)this.workspaceObserver);
        }
    }

    public synchronized Collection<Project> getUpstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> upList = this.up.get(project);
        return upList == null ? null : Collections.unmodifiableCollection(upList);
    }

    public synchronized Collection<Project> getDownstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> downList = this.down.get(project);
        return downList == null ? null : Collections.unmodifiableCollection(downList);
    }

    public synchronized Collection<Project> getProjectsUsing(Context context, String ... fqClassNames) throws InterruptedException {
        this.update();
        HashSet<Project> results = new HashSet<Project>();
        LinkedList<Project> queue = new LinkedList<Project>();
        ArrayList<String> classNames = new ArrayList<String>(Arrays.asList(fqClassNames));
        Project project = context.getProject();
        if (project != null) {
            queue.add(project);
        }
        while (!queue.isEmpty() && !classNames.isEmpty()) {
            Collection<Project> upList;
            boolean found = false;
            Project current = (Project)queue.removeFirst();
            JavaManager javaManager = JavaManager.getJavaManager((Project)current);
            Iterator iterator = classNames.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass = javaManager.getClass((String)iterator.next());
                if (javaClass == null) continue;
                found = true;
                if (!this.isOwner(current, javaClass)) continue;
                iterator.remove();
            }
            if (!found) continue;
            results.add(current);
            Collection<Project> downList = this.down.get(current);
            if (downList != null) {
                results.addAll(downList);
            }
            if ((upList = this.up.get(current)) == null) continue;
            for (Project upProject : upList) {
                if (results.contains(upProject)) continue;
                queue.add(upProject);
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    private void dispose() {
        if (this.workspace != null) {
            this.workspace.detach((Observer)this.workspaceObserver);
        }
        for (Project project : this.observedProjects) {
            project.detach((Observer)this.projectObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update() throws InterruptedException {
        if (this.dirty) {
            PerformanceLogger.get().startTiming("DependencyCache.update");
            try {
                for (Project project : this.observedProjects) {
                    project.detach((Observer)this.projectObserver);
                }
                this.observedProjects.clear();
                this.up.clear();
                this.down.clear();
                Collection<Project> projects = this.getProjects();
                this.observedProjects.addAll(projects);
                LinkedList<Project> queue = new LinkedList<Project>(projects);
                while (!queue.isEmpty()) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Project project = queue.removeFirst();
                    project.attach((Observer)this.projectObserver);
                    Collection<Project> upList = this.up.get(project);
                    for (Project dependency : this.getDependencies(project)) {
                        if (upList == null) {
                            upList = new ArrayList<Project>();
                            this.up.put(project, upList);
                        }
                        upList.add(dependency);
                        Collection<Project> downList = this.down.get(dependency);
                        if (downList == null) {
                            downList = new ArrayList<Project>();
                            this.down.put(dependency, downList);
                        }
                        downList.add(project);
                        if (this.observedProjects.contains(dependency)) continue;
                        this.observedProjects.add(dependency);
                        queue.add(dependency);
                    }
                }
                this.dirty = false;
            }
            catch (Throwable throwable) {
                PerformanceLogger.get().stopTiming("DependencyCache.update", "Built dependency cache for " + (this.workspace == null ? "empty context" : this.workspace.getShortLabel()));
                throw throwable;
            }
            PerformanceLogger.get().stopTiming("DependencyCache.update", "Built dependency cache for " + (this.workspace == null ? "empty context" : this.workspace.getShortLabel()));
        }
    }

    private Collection<Project> getProjects() {
        if (this.workspace == null) {
            return Collections.emptySet();
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator iterator = this.workspace.getChildren();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof Project)) continue;
            projects.add((Project)child);
        }
        return projects;
    }

    private Collection<Project> getDependencies(Project project) {
        ArrayList<Project> dependencies = new ArrayList<Project>();
        DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
        Iterator iterator = dc.getDependencies();
        while (iterator.hasNext()) {
            Dependable dependable = (Dependable)iterator.next();
            Element source = dependable.getSource();
            if (!(source instanceof Project)) continue;
            dependencies.add((Project)source);
        }
        return dependencies;
    }

    private boolean isOwner(Project project, JavaClass javaClass) {
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        if (sourceClass != null) {
            SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
            ContentSet contents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (contents.canHaveMember(owningSourceFile.getURL())) {
                return true;
            }
        }
        return false;
    }

    static {
        Node.addNodeListenerForType(Workspace.class, (NodeListener)new WorkspaceListener());
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/" + "dependencyList"), (ProjectChangeListener)dependencyListener);
    }

    private class ProjectObserver
    implements Observer {
        private ProjectObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.OBJECT_RELOADED) {
                DependencyCache.this.dirty = true;
            }
        }
    }

    private class WorkspaceObserver
    implements Observer {
        private WorkspaceObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            block2: {
                int id;
                block4: {
                    block3: {
                        id = change.getMessageID();
                        if (id != UpdateMessage.OBJECT_RELOADED) break block3;
                        DependencyCache.this.dirty = true;
                        break block2;
                    }
                    if (id != UpdateMessage.CHILD_ADDED) break block4;
                    for (Object object : change.getAddObjects()) {
                        if (!(object instanceof Project)) continue;
                        DependencyCache.this.dirty = true;
                        break block2;
                    }
                    break block2;
                }
                if (id != UpdateMessage.CHILD_REMOVED) break block2;
                for (Object object : change.getRemoveObjects()) {
                    if (!(object instanceof Project)) continue;
                    DependencyCache.this.dirty = true;
                    break;
                }
            }
        }
    }

    private static class DependencyListener
    extends ProjectChangeListener {
        private DependencyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            Project project = e.getProject();
            HashMap hashMap = INSTANCES;
            synchronized (hashMap) {
                for (Map.Entry entry : INSTANCES.entrySet()) {
                    DependencyCache instance = (DependencyCache)entry.getValue();
                    if (!instance.observedProjects.contains(project)) continue;
                    instance.dirty = true;
                }
            }
        }
    }

    private static class WorkspaceListener
    extends NodeListener {
        private WorkspaceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeClosed(NodeEvent e) {
            Workspace workspace = (Workspace)e.getNode();
            HashMap hashMap = INSTANCES;
            synchronized (hashMap) {
                DependencyCache instance = (DependencyCache)INSTANCES.remove(workspace);
                if (instance != null) {
                    instance.dispose();
                }
            }
        }
    }
}

