/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDescriptor;

public class TagManager {
    private static final TagManager _singleton = new TagManager();
    private static final String EMPTY_STR = "";
    private ArrayList<TagDescriptor> _allTagsList;
    private JavadocSettings _settings;
    public static final TagDescriptor PARAM_TAG_DEF = new TagDescriptor("@param", 12, 2, "", false, false, true, false, "<parameter name>", "@param");
    public static final TagDescriptor AUTHOR_TAG_DEF = new TagDescriptor("@author", 1, 1, "", false, true, false, true, "", "@author");
    public static final TagDescriptor RETURN_TAG_DEF = new TagDescriptor("@return", 4, 1, "", false, false, true, false, "", "@return");
    public static final TagDescriptor VERSION_TAG_DEF = new TagDescriptor("@version", 1, 1, "", false, false, false, true, "", "@version");
    public static final TagDescriptor SERIAL_DATA_TAG_DEF = new TagDescriptor("@serialData", 12, 1, "", false, false, false, false, "", "@serialData");
    public static final TagDescriptor THROWS_TAG_DEF = new TagDescriptor("@throws", 12, 2, "", false, false, true, false, "<throws type>", "@throws");
    public static final TagDescriptor SEE_TAG_DEF = new TagDescriptor("@see", 15, 1, "", false, true, false, false, "", "@see");
    public static final TagDescriptor SINCE_TAG_DEF = new TagDescriptor("@since", 15, 1, "", false, false, false, true, "", "@since");
    public static final TagDescriptor SERIAL_TAG_DEF = new TagDescriptor("@serial", 3, 1, "", false, false, false, false, "", "@serial");
    public static final TagDescriptor SERIAL_FIELD_TAG_DEF = new TagDescriptor("@serialField", 2, 1, "", false, false, false, false, "", "@serialField");
    public static final TagDescriptor DEPRECATED_TAG_DEF = new TagDescriptor("@deprecated", 15, 1, "", false, false, false, false, "", "@deprecated");
    public static final TagDescriptor DOC_ROOT_TAG_DEF = new TagDescriptor("@docRoot", 15, 1, "", false, true, false, false, "", "@docRoot");
    public static final TagDescriptor INHERIT_DOC_TAG_DEF = new TagDescriptor("@inheritDoc", 12, 1, "", false, true, false, false, "", "@inheritDoc");
    public static final TagDescriptor LINK_TAG_DEF = new TagDescriptor("@link", 15, 1, "", false, true, false, false, "", "@link");
    public static final TagDescriptor LINK_PLAIN_TAG_DEF = new TagDescriptor("@linkplain", 15, 1, "", false, true, false, false, "", "@linkplain");
    public static final TagDescriptor VALUE_TAG_DEF = new TagDescriptor("@value", 2, 1, "", false, true, false, false, "", "@value");
    public static final TagDescriptor CODE_TAG_DEF = new TagDescriptor("@code", 15, 1, "", false, true, false, false, "", "@code");
    public static final TagDescriptor LITERAL_TAG_DEF = new TagDescriptor("@literal", 15, 1, "", false, true, false, false, "", "@literal");
    private static final TagDescriptor[] STANDALONE_TAGS = new TagDescriptor[]{AUTHOR_TAG_DEF, VERSION_TAG_DEF, PARAM_TAG_DEF, RETURN_TAG_DEF, THROWS_TAG_DEF, SEE_TAG_DEF, SINCE_TAG_DEF, SERIAL_TAG_DEF, SERIAL_DATA_TAG_DEF, SERIAL_FIELD_TAG_DEF, DEPRECATED_TAG_DEF};
    private static final TagDescriptor[] INLINE_TAGS = new TagDescriptor[]{DOC_ROOT_TAG_DEF, INHERIT_DOC_TAG_DEF, LINK_TAG_DEF, LINK_PLAIN_TAG_DEF, VALUE_TAG_DEF, LITERAL_TAG_DEF, CODE_TAG_DEF};

    private TagManager() {
    }

    public TagDescriptor findTagDescriptorByName(TagDescriptor thisTD, TagDescriptor[] tds) {
        for (TagDescriptor td : tds) {
            if (!thisTD.tagNamesAreEqual(td)) continue;
            return td;
        }
        return null;
    }

    public TagDescriptor[] getAllTags() {
        this.getSettings();
        this.refreshAllTagsList();
        return this._allTagsList.toArray(new TagDescriptor[this._allTagsList.size()]);
    }

    public TagDescriptor[] getInlneTags() {
        return INLINE_TAGS;
    }

    public ArrayList getTags(int key) {
        this.getSettings();
        this.refreshAllTagsList();
        int listSize = this._allTagsList.size();
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>(listSize);
        for (TagDescriptor td : this._allTagsList) {
            if ((td.getScope() & key) <= 0) continue;
            tags.add(td);
        }
        return tags;
    }

    public ArrayList getInlineTags(int key) {
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>();
        for (TagDescriptor td : INLINE_TAGS) {
            if ((td.getScope() & key) <= 0) continue;
            tags.add(td);
        }
        return tags;
    }

    private void refreshAllTagsList() {
        this._allTagsList = new ArrayList(this._settings.getTagList());
        if (this._allTagsList.size() == 0 || this._allTagsList.get(0) == null) {
            this._allTagsList = new ArrayList();
            this.addBuiltInTagsToList(this._allTagsList);
            this._settings.setTagList(this._allTagsList);
        } else {
            this.addBuiltInTagsToList(this._allTagsList);
            for (TagDescriptor td : this._allTagsList) {
                if (td.getName().startsWith("@")) continue;
                td.setName("@" + td.getName());
            }
        }
    }

    private void addBuiltInTagsToList(List list) {
        TagDescriptor[] customArr = new TagDescriptor[list.size()];
        list.toArray(customArr);
        for (TagDescriptor td : STANDALONE_TAGS) {
            TagDescriptor matchTD = this.findTagDescriptorByName(td, customArr);
            if (matchTD == null) {
                list.add(td);
                continue;
            }
            if (td.isCustom()) continue;
            matchTD.setName(td.getName());
            if (matchTD.getScope() != td.getScope()) {
                matchTD.unsetScope(1);
                matchTD.unsetScope(2);
                matchTD.unsetScope(4);
                matchTD.unsetScope(8);
                matchTD.setScope(td.getScope());
            }
            matchTD.setParams(td.getParams());
            matchTD.setReference(td.getReference());
            matchTD.setAllowDuplicates(td.isAllowDuplicates());
            matchTD.setAllowsTemplate(td.isAllowsTemplate());
            matchTD.setTemplate(td.getTemplate());
            matchTD.setLabel(td.getLabel());
        }
    }

    public JavadocSettings getSettings() {
        if (this._settings == null) {
            this.initializeSettings();
        }
        return this._settings;
    }

    private void initializeSettings() {
        this._settings = (JavadocSettings)Ide.getSettings().getData("JavadocSettings");
        if (this._settings == null || this._settings.getTagList().size() == 0) {
            this._settings = new JavadocSettings();
            this.refreshAllTagsList();
            ClientSetting setting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            setting.putData("JavadocSettings", (Copyable)this._settings);
        }
    }

    public static TagManager getInstance() {
        return _singleton;
    }
}

