/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.util.Copyable;

public class TagDescriptor
implements Copyable {
    private String _name;
    private int _params;
    private String _reference;
    private int _scope;
    private boolean _custom;
    private boolean _allowDuplicates;
    private boolean _required;
    private boolean _allowsTemplate;
    private String _template;
    private String _label;

    public TagDescriptor() {
        this("", 0, 1);
    }

    public TagDescriptor(String name, int scope, int params) {
        this(name, scope, params, "", true, true, false, true, "", name);
    }

    public TagDescriptor(String name, int scope, int params, String ref, boolean custom, boolean allowsDups, boolean required, boolean allowsTemplates, String template, String label) {
        this._name = name.intern();
        this._scope = scope;
        this._params = params;
        this._reference = ref;
        this._custom = custom;
        this._allowDuplicates = allowsDups;
        this._required = required;
        this._allowsTemplate = allowsTemplates;
        this._template = template.intern();
        this._label = label.intern();
    }

    public Object copyTo(Object target) {
        TagDescriptor copy = target instanceof TagDescriptor ? (TagDescriptor)target : new TagDescriptor();
        this.copyToImpl(copy);
        return copy;
    }

    private void copyToImpl(TagDescriptor copy) {
        copy._name = this._name;
        copy._params = this._params;
        copy._reference = this._reference;
        copy._scope = this._scope;
        copy._custom = this._custom;
        copy._allowDuplicates = this._allowDuplicates;
        copy._required = this._required;
        copy._allowsTemplate = this._allowsTemplate;
        copy._template = this._template;
        copy._label = this._label;
    }

    public boolean nameAndReferenceEquals(SourceDocTag sourceDocTag) {
        return this.nameEquals(sourceDocTag) && this.referenceEquals(sourceDocTag);
    }

    public boolean equals(SourceDocTag sourceDocTag) {
        if (this.nameEquals(sourceDocTag)) {
            if (this.getParams() == 2) {
                return this.referenceEquals(sourceDocTag) && this.templateEquals(sourceDocTag);
            }
            return this.templateEquals(sourceDocTag);
        }
        return false;
    }

    private boolean nameEquals(SourceDocTag sourceDocTag) {
        String srcTagName = sourceDocTag.getName();
        if (srcTagName.equals(this.getName())) {
            return true;
        }
        if ("@throws".equals(this.getName()) && sourceDocTag.isException()) {
            return "@throws".equals(srcTagName) || "@exception".equals(srcTagName);
        }
        return false;
    }

    private boolean referenceEquals(SourceDocTag sourceDocTag) {
        if (this.getParams() == 2) {
            String reference = this.getReference();
            if (sourceDocTag.isParameter()) {
                SourceDocReference ref = sourceDocTag.getReference();
                String param = ref != null ? ref.getParameterName() : sourceDocTag.getArgumentText();
                return param.equals(reference);
            }
            if (sourceDocTag.isException()) {
                String tagText = sourceDocTag.getReferenceText();
                if (tagText == null || tagText.equals("")) {
                    return reference.equals("");
                }
                return tagText.equals(reference) || tagText.endsWith("." + reference);
            }
        }
        return true;
    }

    private boolean templateEquals(SourceDocTag sourceDocTag) {
        if (!this.isAllowsTemplate()) {
            return true;
        }
        String template = this.getTemplate();
        if (template.length() == 0) {
            return true;
        }
        String tagText = sourceDocTag.getArgumentText();
        tagText = tagText == null ? "" : tagText.trim();
        return tagText.startsWith(template);
    }

    public SourceDocTag[] findDocTags(SourceDocTag[] tags) {
        ArrayList<SourceDocTag> tagList = new ArrayList<SourceDocTag>();
        for (int i = 0; i < tags.length; ++i) {
            SourceDocTag sourceDocTag = tags[i];
            if (!this.equals(sourceDocTag)) continue;
            tagList.add(sourceDocTag);
        }
        SourceDocTag[] found = new SourceDocTag[tagList.size()];
        tagList.toArray(found);
        return found;
    }

    public boolean tagNamesAreEqual(TagDescriptor td) {
        if (this.getParams() == 1 && this.getParams() == td.getParams()) {
            return this.getName().equals(td.getName());
        }
        return this.getName().equals(td.getName()) && this.getReference().equals(td.getReference());
    }

    public String getFullTagName() {
        String fullName = this.getName();
        if (this.getParams() == 2 && this.getReference().length() > 0) {
            fullName = fullName + " " + this.getReference();
        }
        if (this.getTemplate().length() > 0) {
            fullName = fullName + " " + this.getTemplate();
        }
        return fullName;
    }

    public String getBriefName() {
        int index;
        String n = this.getName();
        if (n.startsWith("{") && (n = n.substring((index = n.indexOf(123)) + 1)).endsWith("}")) {
            index = n.lastIndexOf(125);
            n = n.substring(0, index);
        }
        if (n.startsWith("@")) {
            index = n.indexOf(64);
            n = n.substring(index + 1);
        }
        return n;
    }

    public String toString() {
        return this.getName();
    }

    public void setReference(String reference) {
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setParams(int params) {
        this._params = params;
    }

    public int getParams() {
        return this._params;
    }

    public void setScope(int scope) {
        this._scope |= scope;
    }

    public void unsetScope(int scope) {
        this._scope &= ~scope;
    }

    public int getScope() {
        return this._scope;
    }

    public void setTemplate(String template) {
        this._template = template;
    }

    public String getTemplate() {
        return this._template;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowsTemplate(boolean allowsTemplate) {
        this._allowsTemplate = allowsTemplate;
    }

    public boolean isAllowsTemplate() {
        return this._allowsTemplate;
    }

    public void setCustom(boolean custom) {
        this._custom = custom;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TagDescriptor)) {
            return false;
        }
        TagDescriptor other = (TagDescriptor)object;
        if (!(this._name != null ? this._name.equals(other._name) : other._name == null)) {
            return false;
        }
        if (this._params != other._params) {
            return false;
        }
        if (!(this._reference != null ? this._reference.equals(other._reference) : other._reference == null)) {
            return false;
        }
        if (this._scope != other._scope) {
            return false;
        }
        if (this._custom != other._custom) {
            return false;
        }
        if (this._allowDuplicates != other._allowDuplicates) {
            return false;
        }
        if (this._required != other._required) {
            return false;
        }
        if (this._allowsTemplate != other._allowsTemplate) {
            return false;
        }
        if (!(this._template != null ? this._template.equals(other._template) : other._template == null)) {
            return false;
        }
        return this._label != null ? this._label.equals(other._label) : other._label == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 1;
        result = 37 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 37 * result + this._params;
        result = 37 * result + (this._reference == null ? 0 : this._reference.hashCode());
        result = 37 * result + this._scope;
        result = 37 * result + (this._custom ? 0 : 1);
        result = 37 * result + (this._allowDuplicates ? 0 : 1);
        result = 37 * result + (this._required ? 0 : 1);
        result = 37 * result + (this._allowsTemplate ? 0 : 1);
        result = 37 * result + (this._template == null ? 0 : this._template.hashCode());
        result = 37 * result + (this._label == null ? 0 : this._label.hashCode());
        return result;
    }
}

