/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.ClassEngine;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.FieldInfo;

public class FieldEngine {
    static final int ADD_READER = 1;
    static final int ADD_WRITER = 2;
    static final int REMOVE_READER = 3;
    static final int REMOVE_WRITER = 4;

    public static FieldInfo addField(ClassEngine classEngine, FieldInfo fi) {
        return FieldEngine.addField(classEngine, fi, null);
    }

    public static FieldInfo addField(ClassEngine classEngine, FieldInfo fi, FieldInfo prevFi) {
        SourceClass srcClass = classEngine.getSourceClass();
        if (!(classEngine.isEditable() && ModelUtil.hasLength((String)fi.name) && ModelUtil.hasLength((String)fi.type))) {
            return null;
        }
        if (srcClass.getField(fi.name) != null) {
            return fi;
        }
        EngineUtils.openTransaction(classEngine.getSourceFile());
        List fieldDecls = srcClass.getSourceFieldDeclarations();
        fieldDecls.add(fieldDecls.size(), fi.createSourceFieldDecl(classEngine.getSourceFile()));
        return fi;
    }

    public static boolean removeField(ClassEngine classEngine, String name) {
        if (!classEngine.isEditable()) {
            return false;
        }
        SourceClass srcClass = classEngine.getSourceClass();
        SourceFieldVariable field = srcClass.getSourceFieldVariable(name);
        if (field != null) {
            EngineUtils.openTransaction(classEngine.getSourceFile());
            field.removeSelf();
        }
        return true;
    }

    public static FieldInfo updateField(ClassEngine classEngine, FieldInfo fieldInfoOld, FieldInfo fieldInfoNew) {
        SourceFieldDeclaration newField;
        if (!classEngine.isEditable()) {
            return null;
        }
        SourceClass srcClass = classEngine.getSourceClass();
        SourceFile srcFile = classEngine.getSourceFile();
        EngineUtils.openTransaction(srcFile);
        SourceFieldVariable prevField = null;
        if (!EngineUtils.isAbstract(fieldInfoOld.modifiers)) {
            SourceFieldVariable sourceFieldVariable = prevField = fieldInfoOld != null ? srcClass.getSourceFieldVariable(fieldInfoOld.name) : null;
        }
        if (!EngineUtils.isAbstract(fieldInfoNew.modifiers) && (newField = fieldInfoNew.createSourceFieldDecl(srcFile)) != null) {
            if (prevField != null) {
                SourceDocComment docComm = prevField.getDocComment();
                SourceFactory factory = srcFile.getFactory();
                if (docComm != null) {
                    String text = docComm.getText();
                    newField.setDocComment(factory.createDocComment(text));
                }
                List oldAnnos = prevField.getOwningDeclaration().getSourceAnnotations();
                List newAnnos = newField.getSourceAnnotations();
                if (oldAnnos != null) {
                    for (SourceAnnotation srcAnno : oldAnnos) {
                        String text = srcAnno.getText();
                        newAnnos.add(factory.createAnnotationFromText(text));
                    }
                }
            }
            List fieldDecls = srcClass.getSourceFieldDeclarations();
            fieldDecls.add(fieldDecls.size(), newField);
        }
        if (prevField != null) {
            prevField.removeSelf();
        }
        return fieldInfoNew;
    }
}

