/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.dialogs.DlgArb;

public class ClassPackageListBrowser
extends JPanel
implements ActionListener,
ListSelectionListener {
    private Project project;
    private int mode;
    private List list;
    private DefaultListModel listModel = new DefaultListModel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane scrList = new JScrollPane();
    JList jList1 = new JList();
    JButton butAdd = new JButton();
    JButton butRemove = new JButton();
    JPanel buttonPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    Border bdrScroller = BorderFactory.createLoweredBevelBorder();

    public ClassPackageListBrowser(Project project, int mode, List list) {
        this.project = project;
        this.mode = mode;
        this.list = list;
        for (String s : list) {
            this.listModel.addElement(s);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.listModel.isEmpty()) {
            this.jList1.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.scrList.setBorder(this.bdrScroller);
        this.scrList.getViewport().add((Component)this.jList1, null);
        this.jList1.setSelectionMode(2);
        this.jList1.setModel(this.listModel);
        this.jList1.addListSelectionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butAdd, (String)DlgArb.getString(0));
        this.butAdd.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.butRemove, (String)DlgArb.getString(1));
        this.butRemove.addActionListener(this);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(8);
        this.buttonPanel.setLayout(this.gridLayout1);
        this.buttonPanel.add(this.butAdd);
        this.buttonPanel.add(this.butRemove);
        this.add((Component)this.scrList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.updateButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] sel;
        Object source = e.getSource();
        if (source == this.butAdd) {
            String[] s = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.project, this.mode, true);
            if (s.length > 0) {
                for (int i = 0; i < s.length; ++i) {
                    this.listModel.addElement(s[i]);
                }
                int count = this.listModel.getSize();
                this.jList1.setSelectedIndex(count - 1);
            }
        } else if (source == this.butRemove && (sel = this.jList1.getSelectedValues()) != null && sel.length > 0) {
            int selIdx = this.listModel.indexOf(sel[0]);
            for (int i = 0; i < sel.length; ++i) {
                this.listModel.removeElement(sel[i]);
            }
            int count = this.listModel.getSize();
            this.jList1.setSelectedIndex(selIdx < count ? selIdx : count - 1);
            if (count <= 0) {
                this.butRemove.setEnabled(false);
            }
        }
    }

    private void updateButtons() {
        int[] sel = this.jList1.getSelectedIndices();
        boolean hasSelection = sel != null && sel.length > 0;
        this.butRemove.setEnabled(hasSelection);
    }

    private Component getInitialFocus() {
        if (this.listModel.isEmpty()) {
            return this.butAdd;
        }
        return this.jList1;
    }

    public static boolean browseClassPackageList(String title, Project project, boolean packages, boolean classes, List list) {
        return ClassPackageListBrowser.browseClassPackageList(null, title, project, packages, classes, list, null);
    }

    public static boolean browseClassPackageList(String title, Project project, boolean packages, boolean classes, List list, String helpID) {
        return ClassPackageListBrowser.browseClassPackageList(null, title, project, packages, classes, list, helpID);
    }

    public static boolean browseClassPackageList(Component parent, String title, Project project, boolean packages, boolean classes, List list, String helpID) {
        int mode = 0;
        if (packages) {
            mode |= 1;
        }
        if (classes) {
            mode |= 2;
        }
        ClassPackageListBrowser panel = new ClassPackageListBrowser(project, mode, list);
        if (helpID != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, helpID);
        }
        if (OnePageWizardDialogFactory.runDialog((Component)parent, (Component)panel, (Component)panel.getInitialFocus(), (String)title)) {
            list.clear();
            Enumeration e = panel.listModel.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                list.add(s);
            }
            return true;
        }
        return false;
    }
}

