/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.editor.insight.CamelCaseInsightInputFilter;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.dialogs.ClassPackageNamePrefixFilter;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;
import oracle.jdevimpl.java.JavaArb;

public class BrowseHandler2 {
    private boolean _copyQualifiedClassNameToField;
    private JTextField browseField;
    private ActionListener clientListener;
    private PopupGestureHandler popupGestureHandler;
    private ClassNameFilter classFilter;
    private PackageNameFilter packageFilter;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private BrowseTask browseTask;
    private PopulateTask populateTask;
    private Map<String, String[]> brPackageMap;
    private Set<String> brPackageSet;
    private JavaManager brJavaManager;
    private int classOrPackage;
    private FoundItem lastDefaultItem;
    private boolean pendingLookup = false;
    private AsyncScheduler brScheduler = new AsyncScheduler("BrowseHandler2Browser", 10000);
    private boolean CHECK_FOR_INTERFACE = false;
    private static final int PACKAGE_ONLY = 1;
    private static final int CLASS_ONLY = 2;
    private static final int CLASS_AND_PACKAGE = 3;
    static final String EMPTY_LIST_ITEM = DialogsArb.getString(12);
    static final String PROGRESS_LIST_ITEM = DialogsArb.getString(13);
    private static final FoundItem[] PROGRESS_FEEDBACK = new FoundItem[]{new FoundItem(PROGRESS_LIST_ITEM, -1)};
    private boolean showPopupOnFocus = false;
    private boolean isAdjusting = false;
    private static final int PACKAGE_ITEM = 1;
    private static final int UNQ_CLASS_ITEM = 2;
    private static final int UNQ_INTERFACE_ITEM = 4;
    private static final int FQ_CLASS_ITEM = 3;
    private static final int FQ_INTERFACE_ITEM = 5;
    private static final int MIN_PREFIX_LEN = 1;

    public static BrowseHandler2 createClassBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler2(javaManager, textField, actionListener, 2, null, null);
    }

    public static BrowseHandler2 createPackageBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler2(javaManager, textField, actionListener, 1, null, null);
    }

    public static BrowseHandler2 createClassPackageBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler2(javaManager, textField, actionListener, 3, null, null);
    }

    public static BrowseHandler2 createClassBrowserList(JavaManager javaManager, JTextField textField) {
        return new BrowseHandler2(javaManager, textField, null, 2, null, null);
    }

    public static BrowseHandler2 createClassBrowserList(JavaManager javaManager, JTextField textField, ClassNameFilter classFilter) {
        return new BrowseHandler2(javaManager, textField, null, 2, classFilter, null);
    }

    public static BrowseHandler2 createPackageBrowserList(JavaManager javaManager, JTextField textField) {
        return new BrowseHandler2(javaManager, textField, null, 1, null, null);
    }

    public static BrowseHandler2 createPackageBrowserList(JavaManager javaManager, JTextField textField, PackageNameFilter packageFilter) {
        return new BrowseHandler2(javaManager, textField, null, 1, null, packageFilter);
    }

    public static BrowseHandler2 createClassPackageBrowserList(JavaManager javaManager, JTextField textField) {
        return new BrowseHandler2(javaManager, textField, null, 3, null, null);
    }

    public static BrowseHandler2 createClassPackageBrowserList(JavaManager javaManager, JTextField textField, ClassNameFilter classFilter, PackageNameFilter packageFilter) {
        return new BrowseHandler2(javaManager, textField, null, 3, classFilter, packageFilter);
    }

    private BrowseHandler2(JavaManager javaManager, JTextField textField, ActionListener actionListener, int matchClassAndOrPackage, ClassNameFilter classFilter, PackageNameFilter packageFilter) {
        if (javaManager == null) {
            throw new IllegalArgumentException("The JavaManager cannot be null.");
        }
        this.brJavaManager = javaManager;
        this.browseField = textField;
        this.clientListener = actionListener;
        this.classOrPackage = matchClassAndOrPackage;
        this.initializeFilters(classFilter, packageFilter);
        this.browseField.addKeyListener(this.getPopupGestureHandler());
        this.browseField.addFocusListener(this.getPopupGestureHandler());
        this.browseField.addAncestorListener(this.getPopupGestureHandler());
        this.browseField.getDocument().addDocumentListener(this.getPopupGestureHandler());
    }

    public void dispose() {
        this.cancelLookup();
        this.cancelPopulate();
        if (this.popupList != null) {
            this.popupList.removeMouseListener((MouseListener)this.getPopupGestureHandler());
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.browseField != null) {
            this.browseField.removeKeyListener(this.getPopupGestureHandler());
            this.browseField.removeFocusListener(this.getPopupGestureHandler());
            this.browseField.removeAncestorListener(this.getPopupGestureHandler());
            this.browseField.getDocument().removeDocumentListener(this.getPopupGestureHandler());
            this.browseField = null;
        }
        this.clientListener = null;
        if (this.CHECK_FOR_INTERFACE) {
            CacheSupport cacheSupport = this.brJavaManager.getCacheSupport();
            cacheSupport.flushCache();
        }
    }

    public String getSelectedItem() {
        if (this.lastDefaultItem != null) {
            return this.lastDefaultItem.name;
        }
        if (this.browseField != null) {
            return this.browseField.getText();
        }
        return null;
    }

    void doLookup(String lookupText) {
        this.scheduleLookup(lookupText);
    }

    private void initializeFilters(ClassNameFilter clsFilter, PackageNameFilter pkgFilter) {
        if (clsFilter == null || pkgFilter == null) {
            ClassPackageNamePrefixFilter filter = new ClassPackageNamePrefixFilter();
            this.classFilter = clsFilter != null ? clsFilter : filter;
            this.packageFilter = pkgFilter != null ? pkgFilter : filter;
        } else {
            this.classFilter = clsFilter;
            this.packageFilter = pkgFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookup(String prefixText) {
        BrowseHandler2 browseHandler2;
        if (this.isAdjusting) {
            return;
        }
        if (this.populateTask == null || this.populateTask.brText != Character.toUpperCase(prefixText.charAt(0))) {
            this.cancelPopulate();
            FoundData searchingData = new FoundData(PROGRESS_FEEDBACK, "");
            this.displayResults(searchingData);
            browseHandler2 = this;
            synchronized (browseHandler2) {
                this.populateTask = new PopulateTask(prefixText);
                this.brScheduler.scheduleTask((AsyncTask)this.populateTask);
            }
        } else if (!this.populateTask.isFinished()) {
            return;
        }
        BrowseTask task = new BrowseTask(prefixText);
        browseHandler2 = this;
        synchronized (browseHandler2) {
            if (this.browseTask != null) {
                this.brScheduler.cancelTask((AsyncTask)this.browseTask);
            }
            this.browseTask = task;
        }
        this.brScheduler.scheduleTask((AsyncTask)task);
        this.pendingLookup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLookup() {
        BrowseTask pendingTask;
        BrowseHandler2 browseHandler2 = this;
        synchronized (browseHandler2) {
            pendingTask = this.browseTask;
            this.browseTask = null;
        }
        if (pendingTask != null) {
            this.brScheduler.cancelTask((AsyncTask)pendingTask);
        }
        this.pendingLookup = false;
    }

    private void cancelPopulate() {
        if (this.populateTask != null) {
            this.brScheduler.cancelTask((AsyncTask)this.populateTask);
        }
    }

    private void updatePopup() {
        if (this.browseField == null || !this.browseField.isShowing() || !this.browseField.hasFocus()) {
            return;
        }
        if (this.browseField.getText().length() < 1) {
            this.hidePopup(false);
        } else {
            this.doLookup(this.browseField.getText());
        }
    }

    private void hidePopup(boolean focusTextField) {
        if (focusTextField) {
            this.browseField.requestFocus();
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void displayResults(FoundData data) {
        FoundItem[] foundItems;
        if (this.browseField == null || !this.browseField.isVisible()) {
            return;
        }
        if (this.popupWindow == null) {
            this.popupList = new ListInsightView((ListCellRenderer)((Object)new FoundRenderer()));
            this.popupList.addMouseListener((MouseListener)this.getPopupGestureHandler());
            this.popupList.setData((InsightData)data);
            JScrollPane scroller = new JScrollPane((Component)this.popupList);
            scroller.setHorizontalScrollBarPolicy(31);
            scroller.setFocusable(false);
            this.popupList.setFocusable(false);
            this.popupList.getComponent().setFocusable(false);
            Window parentWindow = SwingUtilities.getWindowAncestor(this.browseField);
            this.popupWindow = new JWindow(parentWindow);
            this.popupWindow.getContentPane().add(scroller);
            this.popupWindow.setFocusableWindowState(false);
        } else {
            this.popupList.setData((InsightData)data);
        }
        if (!this.popupWindow.isVisible()) {
            Point location = this.browseField.getLocationOnScreen();
            location.y += this.browseField.getHeight() + 2;
            this.popupWindow.setLocation(location);
        }
        if ((foundItems = data.getData()).length == 0) {
            this.lastDefaultItem = null;
            this.popupWindow.setVisible(false);
        } else {
            this.popupList.selectDefault();
            this.lastDefaultItem = (FoundItem)((Object)data.getDefault());
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
        }
        this.pendingLookup = false;
    }

    private void populateFinished(Map<String, String[]> packageMap, Set<String> packageSet) {
        this.brPackageMap = packageMap;
        this.brPackageSet = packageSet;
        Runnable invokeTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                BrowseHandler2.this.updatePopup();
            }
        };
        SwingUtilities.invokeLater(invokeTask);
    }

    public boolean isCopyQualifiedClassNameToField() {
        return this._copyQualifiedClassNameToField;
    }

    public void setCopyQualifiedClassNameToField(boolean copyQualifiedClassNameToField) {
        this._copyQualifiedClassNameToField = copyQualifiedClassNameToField;
    }

    public void setShowPopupOnFocus(boolean showPopupOnFocus) {
        this.showPopupOnFocus = showPopupOnFocus;
    }

    public boolean isShowPopupOnFocus() {
        return this.showPopupOnFocus;
    }

    private PopupGestureHandler getPopupGestureHandler() {
        if (this.popupGestureHandler == null) {
            this.popupGestureHandler = new PopupGestureHandler();
        }
        return this.popupGestureHandler;
    }

    private class PopupGestureHandler
    implements FocusListener,
    KeyListener,
    MouseListener,
    AncestorListener,
    DocumentListener {
        private PopupGestureHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (BrowseHandler2.this.showPopupOnFocus && BrowseHandler2.this.popupWindow != null && !BrowseHandler2.this.popupWindow.isVisible()) {
                BrowseHandler2.this.updatePopup();
            }
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (!event.isTemporary()) {
                if (BrowseHandler2.this._copyQualifiedClassNameToField && BrowseHandler2.this.popupList != null && ModelUtil.hasLength((String)BrowseHandler2.this.browseField.getText())) {
                    FoundItem foundItem = (FoundItem)((Object)BrowseHandler2.this.popupList.getSelectedValue());
                }
                BrowseHandler2.this.hidePopup(false);
            }
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            int keycode = event.getKeyCode();
            if (!(BrowseHandler2.this.pendingLookup || BrowseHandler2.this.popupWindow != null && BrowseHandler2.this.popupWindow.isVisible())) {
                if (keycode == 40) {
                    BrowseHandler2.this.updatePopup();
                }
                return;
            }
            switch (keycode) {
                case 10: 
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    if (!BrowseHandler2.this.pendingLookup) break;
                    event.consume();
                    return;
                }
                case 27: {
                    if (!BrowseHandler2.this.pendingLookup) break;
                    BrowseHandler2.this.cancelLookup();
                    BrowseHandler2.this.hidePopup(true);
                    event.consume();
                    return;
                }
                default: {
                    return;
                }
            }
            switch (keycode) {
                default: {
                    throw new IllegalStateException("unexpected key: " + keycode);
                }
                case 40: {
                    BrowseHandler2.this.popupList.down();
                    break;
                }
                case 38: {
                    BrowseHandler2.this.popupList.up();
                    break;
                }
                case 34: {
                    BrowseHandler2.this.popupList.pageDown();
                    break;
                }
                case 33: {
                    BrowseHandler2.this.popupList.pageUp();
                    break;
                }
                case 10: {
                    this.select();
                    event.consume();
                    return;
                }
                case 27: {
                    BrowseHandler2.this.hidePopup(true);
                    event.consume();
                    return;
                }
            }
        }

        private void select() {
            FoundItem clickedItem = (FoundItem)((Object)BrowseHandler2.this.popupList.getSelectedValue());
            if (clickedItem.type == 1) {
                BrowseHandler2.this.browseField.setText(clickedItem.name + ".");
                return;
            }
            if (PROGRESS_LIST_ITEM.equals(clickedItem.toString())) {
                return;
            }
            BrowseHandler2.this.lastDefaultItem = clickedItem;
            BrowseHandler2.this.isAdjusting = true;
            if (BrowseHandler2.this.clientListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, BrowseHandler2.this.getSelectedItem());
                BrowseHandler2.this.clientListener.actionPerformed(actionEvent);
            }
            BrowseHandler2.this.hidePopup(true);
            BrowseHandler2.this.isAdjusting = false;
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.select();
            event.consume();
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            BrowseHandler2.this.hidePopup(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BrowseHandler2.this.updatePopup();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BrowseHandler2.this.updatePopup();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BrowseHandler2.this.updatePopup();
        }
    }

    private class ListGestureHandler
    implements DocumentListener {
        private ListGestureHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.lookup();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.lookup();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void lookup() {
            String searchText = BrowseHandler2.this.browseField.getText().trim();
            if (searchText.length() >= 1) {
                BrowseHandler2.this.scheduleLookup(searchText);
            } else {
                BrowseHandler2.this.cancelLookup();
            }
        }
    }

    private static final class FoundRenderer
    extends ListDataItemCellRenderer {
        private FoundRenderer() {
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension newSize = new Dimension(Math.max(size.width, 200), size.height);
            return newSize;
        }
    }

    private static final class FoundData
    implements ListInsightData {
        private FoundItem[] items;
        private ReadOnlyListModel model;
        private String prefix;

        private FoundData(FoundItem[] items, String prefix) {
            CamelCaseInsightInputFilter.INSTANCE.sort((ListDataItem[])items, prefix);
            this.items = items;
            this.prefix = prefix;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ReadOnlyListModel((Object[])this.items);
            }
            return this.model;
        }

        public FoundItem[] getData() {
            return this.items;
        }

        public FoundItem[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            return CamelCaseInsightInputFilter.INSTANCE.findClosestDataItem((ListDataItem[])this.items, this.prefix);
        }

        public boolean complete(Object selectedObject) {
            return false;
        }

        public void partialComplete() {
        }
    }

    private static class FoundItem
    extends ListDataItem {
        private int type;
        private String name;
        private String display;
        private static final String[] PRIO_PKGS = new String[]{"java.lang.", "java.util", "java.", "javax."};

        private FoundItem(String name, int type) {
            this.type = type;
            this.name = name;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 1: {
                    return OracleIcons.getIcon((String)"package.png");
                }
                case 2: 
                case 3: {
                    return OracleIcons.getIcon((String)"class.png");
                }
                case 4: 
                case 5: {
                    return OracleIcons.getIcon((String)"interface.png");
                }
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String getDisplayText() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            if (this.display == null) {
                String classPart;
                String packagePrefix;
                int dotPos = this.name.lastIndexOf(46);
                if (dotPos == -1) {
                    packagePrefix = "";
                    classPart = this.name;
                } else {
                    packagePrefix = this.name.substring(0, dotPos);
                    classPart = this.name.substring(dotPos + 1);
                }
                this.display = packagePrefix.length() > 0 ? classPart + " ( " + packagePrefix + " )" : classPart;
            }
            return this.display;
        }

        public String getName() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            int dotPos = this.name.lastIndexOf(46);
            return dotPos != -1 ? this.name.substring(dotPos + 1) : this.name;
        }

        private String getPackage() {
            int dotPos = this.name.lastIndexOf(46);
            return dotPos != -1 ? this.name.substring(0, dotPos) : this.name;
        }

        public int compareTo(Object object) {
            String name2;
            FoundItem item2 = (FoundItem)((Object)object);
            String name1 = this.getName();
            if (name1.equalsIgnoreCase(name2 = item2.getName())) {
                int type1 = this.type;
                int type2 = item2.type;
                if ((type1 == 1 || type2 == 1) && type1 != type2) {
                    return type1 - type2;
                }
                if (!(type1 != 2 && type1 != 4 || type2 != 2 && type2 != 4)) {
                    int prio2;
                    String pkg1 = this.getPackage();
                    String pkg2 = item2.getPackage();
                    int prio1 = FoundItem.getPackagePriority(pkg1);
                    if (prio1 != (prio2 = FoundItem.getPackagePriority(pkg2))) {
                        return prio1 - prio2;
                    }
                }
            }
            String display1 = this.getDisplayText();
            String display2 = item2.getDisplayText();
            return FoundItem.compareInsensitive((String)display1, (String)display2);
        }

        private static int getPackagePriority(String pkg) {
            for (int i = 0; i < PRIO_PKGS.length; ++i) {
                String prioPkg = PRIO_PKGS[i];
                if (!pkg.startsWith(prioPkg)) continue;
                return i;
            }
            return PRIO_PKGS.length;
        }
    }

    private final class PopulateTask
    extends AsyncTask {
        public final char brText;
        private boolean popCancelled = false;

        private PopulateTask(String prefixText) {
            this.brText = (char)(prefixText == null || prefixText.length() < 1 ? 32 : (int)Character.toUpperCase(prefixText.charAt(0)));
        }

        protected void requestCancelImpl() {
            this.popCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.popCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runImpl() throws AsyncTask.CancelledException {
            JavaManager jm = BrowseHandler2.this.brJavaManager;
            String feedbackText = JavaArb.getString(14);
            Ide.getStatusBar().setText(feedbackText);
            try {
                JavaClassLocator locator = jm.getJavaClassLocator();
                Collection qualifiedClassNames = locator.getAllClasses(new ClassNameFilter(){

                    public boolean acceptClassName(String className, String packagePrefix) {
                        return PopulateTask.this.brText == '*' || PopulateTask.this.brText == '?' || PopulateTask.this.brText == Character.toUpperCase(className.charAt(0)) || ModelUtil.hasLength((String)packagePrefix) && PopulateTask.this.brText == Character.toUpperCase(packagePrefix.charAt(0));
                    }

                    public void setMatchName(String matchName) {
                    }
                });
                final HashMap<String, Set> packageMap = new HashMap<String, Set>(500);
                for (String name : qualifiedClassNames) {
                    this.bailIfCancelled();
                    int lastDot = name.lastIndexOf(46);
                    String packageName = lastDot == -1 ? "" : name.substring(0, lastDot);
                    String className = lastDot == -1 ? name : name.substring(lastDot + 1);
                    if (className.length() <= 0) continue;
                    Set classSet = (Set)packageMap.get(packageName);
                    if (classSet == null) {
                        classSet = new ArraySortedSet(100);
                        packageMap.put(packageName, classSet);
                    }
                    classSet.add(className);
                }
                locator.getAllPackages(new PackageNameFilter(){

                    public boolean acceptPackageName(String packageName) {
                        if ((PopulateTask.this.brText == '*' || PopulateTask.this.brText == '?' || ModelUtil.hasLength((String)packageName) && Character.toUpperCase(packageName.charAt(0)) == PopulateTask.this.brText) && !packageMap.containsKey(packageName)) {
                            packageMap.put(packageName, Collections.EMPTY_SET);
                            return true;
                        }
                        return false;
                    }

                    public void setMatchName(String matchName) {
                    }
                });
                HashMap<String, String[]> finalPackageMap = new HashMap<String, String[]>(packageMap.size());
                for (String packageName : packageMap.keySet()) {
                    Set classSet = (Set)packageMap.get(packageName);
                    int classCount = classSet == null ? 0 : classSet.size();
                    String[] classes = new String[classCount];
                    if (classCount > 0) {
                        classSet.toArray(classes);
                    }
                    finalPackageMap.put(packageName, classes);
                }
                BrowseHandler2.this.populateFinished(finalPackageMap, finalPackageMap.keySet());
                HashMap<String, String[]> hashMap = finalPackageMap;
                return hashMap;
            }
            finally {
                String currentText = Ide.getStatusBar().getText();
                if (currentText.equals(feedbackText)) {
                    Ide.getStatusBar().setText("");
                }
            }
        }
    }

    private final class BrowseTask
    extends AsyncTask {
        private String brText;
        private boolean brCancelled = false;

        private BrowseTask(String prefixText) {
            this.brText = prefixText;
        }

        protected void requestCancelImpl() {
            this.brCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.brCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            if (this.brText == null || this.brText.length() == 0) {
                return null;
            }
            BrowseTask.sleep((int)10);
            this.bailIfCancelled();
            Map packageMap = BrowseHandler2.this.brPackageMap;
            if (packageMap == null) {
                return null;
            }
            ArrayList<FoundItem> matchList = new ArrayList<FoundItem>();
            this.taskMatchClassOrPackage(this.brText, matchList);
            int count = matchList.size();
            FoundItem[] items = matchList.toArray(new FoundItem[count]);
            final FoundData data = new FoundData(items, this.brText);
            Runnable invokeTask = new Runnable(){

                @Override
                public void run() {
                    if (!BrowseTask.this.brCancelled) {
                        BrowseHandler2.this.displayResults(data);
                    }
                }
            };
            SwingUtilities.invokeLater(invokeTask);
            return data;
        }

        private void taskMatchClassOrPackage(String prefixText, List<FoundItem> resultList) throws AsyncTask.CancelledException {
            boolean hasDot;
            Map packageMap = BrowseHandler2.this.brPackageMap;
            if ((BrowseHandler2.this.classOrPackage & 1) > 0) {
                BrowseHandler2.this.packageFilter.setMatchName(prefixText);
                Set packageSet = BrowseHandler2.this.brPackageSet;
                for (String packagePrefix : packageSet) {
                    this.bailIfCancelled();
                    if (!BrowseHandler2.this.packageFilter.acceptPackageName(packagePrefix)) continue;
                    resultList.add(new FoundItem(packagePrefix, 1));
                }
            }
            boolean bl = hasDot = prefixText.indexOf(46) != -1;
            if ((BrowseHandler2.this.classOrPackage & 2) > 0) {
                BrowseHandler2.this.classFilter.setMatchName(prefixText);
                if (hasDot) {
                    String packagePrefix;
                    int dotPos = prefixText.lastIndexOf(46);
                    packagePrefix = prefixText.substring(0, dotPos);
                    String[] classes = (String[])packageMap.get(packagePrefix);
                    this.addMatchingClasses(classes, packagePrefix, resultList, hasDot);
                } else {
                    for (String packagePrefix : packageMap.keySet()) {
                        this.bailIfCancelled();
                        String[] classes = (String[])packageMap.get(packagePrefix);
                        this.addMatchingClasses(classes, packagePrefix, resultList, hasDot);
                    }
                }
                if (packageMap.containsKey(prefixText)) {
                    if ((BrowseHandler2.this.classOrPackage & 2) > 0) {
                        BrowseHandler2.this.classFilter.setMatchName(prefixText + ".");
                    }
                    String[] classes = (String[])packageMap.get(prefixText);
                    this.addMatchingClasses(classes, prefixText, resultList, true);
                }
            }
        }

        private void addMatchingClasses(String[] classes, String packagePrefix, List resultList, boolean hasDot) throws AsyncTask.CancelledException {
            for (String name : classes) {
                String fqName;
                this.bailIfCancelled();
                if (!BrowseHandler2.this.classFilter.acceptClassName(name, packagePrefix)) continue;
                String string = fqName = packagePrefix.length() > 0 ? packagePrefix + "." + name : name;
                int type = this.isInterface(fqName) ? (hasDot ? 5 : 4) : (hasDot ? 3 : 2);
                resultList.add(new FoundItem(fqName, type));
            }
        }

        private boolean checkForInterface() {
            return BrowseHandler2.this.CHECK_FOR_INTERFACE;
        }

        private boolean isInterface(String fqClassName) {
            if (!this.checkForInterface()) {
                return false;
            }
            JavaManager jm = BrowseHandler2.this.brJavaManager;
            JavaClass foundClass = jm.getClass(fqClassName);
            if (foundClass != null) {
                return foundClass.isInterface();
            }
            return false;
        }
    }
}

