/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.shell;

import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.shell.ShellConstants;

public abstract class ShellAdapter
implements ShellConstants {
    protected final DeployShell shell_;
    protected final Context context_;

    public ShellAdapter(DeployShell shell) {
        this.shell_ = shell;
        this.context_ = this.shell_.getContext();
        assert (this.context_ != null);
    }

    public ShellAdapter(Context context) {
        this.shell_ = null;
        this.context_ = context;
    }

    public DeployShell getShell() {
        return this.shell_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(String key) {
        DeployShell deployShell;
        Object o = null;
        if (this.shell_ != null) {
            deployShell = this.shell_;
            synchronized (deployShell) {
                o = this.shell_.find(key);
            }
        }
        if (o == null) {
            deployShell = this.context_;
            synchronized (deployShell) {
                o = this.context_.getProperty(key);
            }
        }
        return o;
    }

    public Boolean findFlag(String key, boolean def) {
        Object o = this.find(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        DeployShell deployShell;
        Object o = null;
        if (this.shell_ != null) {
            deployShell = this.shell_;
            synchronized (deployShell) {
                o = this.shell_.get(key);
            }
        }
        if (o == null) {
            deployShell = this.context_;
            synchronized (deployShell) {
                o = this.context_.getProperty(key);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        if (this.shell_ != null) {
            DeployShell deployShell = this.shell_;
            synchronized (deployShell) {
                this.shell_.put(key, value);
                return;
            }
        }
        Context context = this.context_;
        synchronized (context) {
            this.context_.setProperty(key, value);
        }
    }

    public ShellAdapter getRoot() {
        return this.newAdapter(this.shell_.getRoot());
    }

    public ShellAdapter newChildShell() {
        return this.newAdapter(new DeployShell(this.shell_));
    }

    protected abstract ShellAdapter newAdapter(DeployShell var1);

    public Context getContext() {
        return this.context_;
    }

    public Element getDeployElement() {
        Element e = (Element)this.find(KEY_DEPLOY_ELEMENT);
        if (e == null) {
            e = this.getContext().getElement();
        }
        return e;
    }

    public void setLogger(Logger logger) {
        this.shell_.setLogger(logger);
    }

    public Logger getLogger() {
        return this.shell_.getLogger();
    }

    public DeployException getDeployException() {
        return this.shell_.getDeployException();
    }

    public void setDeployException(DeployException e) {
        this.shell_.setDeployException(e);
    }

    public boolean isProfileBasedDeployment() {
        return this.getDeployElement() instanceof Profile;
    }

    public Profile getProfile() {
        if (this.isProfileBasedDeployment()) {
            return (Profile)this.getDeployElement();
        }
        return null;
    }

    public boolean isDeploying(int sequence) {
        return this.shell_.isDeploying(sequence);
    }
}

