/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;

public abstract class OBSpiRecognizer<R, O, C> {
    final OBContext<R, O, C> context_;

    public OBSpiRecognizer(OBContext<R, O, C> context) {
        this.context_ = context;
    }

    protected List<OBBuilder<R, O, C>> createOBBuilder(R recognize, Class type) {
        return this.createOBBuilder(recognize, this.context_.getContext(), type);
    }

    protected List<OBBuilder<R, O, C>> createOBBuilder(R recognize, C context, Class type) {
        ArrayList<OBBuilder<R, O, C>> buildersList = new ArrayList<OBBuilder<R, O, C>>();
        for (int i = this.context_.recognizersSize() - 1; i >= 0; --i) {
            OBContext<R, O, C> childCtx;
            OBRecognizer<R, O, C> r = this.context_.recognizers().get(i);
            OBBuilder<R, O, C> builder = r.recognize(recognize, childCtx = this.context_.newOBContext(context, i), type);
            if (builder == null) continue;
            assert (this.checkType(builder, type));
            buildersList.add(builder);
        }
        return buildersList;
    }

    private boolean checkType(OBBuilder<R, O, C> b, Class type) {
        if (!type.isAssignableFrom(b.getObjectClass())) {
            throw new AssertionError((Object)(b.getClass().getName() + " + did not return object of type " + type.getName()));
        }
        return true;
    }
}

