/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.ArrayList;
import java.util.List;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBException;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBListener;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBStager;

public abstract class OBFramework<R, O, C> {
    BuildListenerSupport blsSupport_ = new BuildListenerSupport();

    public OBStager<R, O, C> createBuilder(R recognize, C context) {
        return this.createBuilder_(recognize, context, Object.class);
    }

    public OBStager<R, O, C> createBuilder(R recognize, C context, Class classOrIntf) {
        if (recognize == null) {
            throw new IllegalArgumentException("Recognition target is null");
        }
        OBStager<R, O, C> builder = this.createBuilder_(recognize, context, classOrIntf);
        if (builder.types().length == 0) {
            String msg = recognize + " not recognized in given context.";
            if (classOrIntf != Object.class) {
                msg = msg + " Requested: " + classOrIntf.getName();
            }
            throw new UnrecognizedTargetException(msg);
        }
        return builder;
    }

    private OBStager<R, O, C> createBuilder_(R recognize, C context, Class classOrIntf) {
        return this.newOBStager(this, recognize, context, classOrIntf);
    }

    protected abstract OBStager<R, O, C> newOBStager(OBFramework<R, O, C> var1, R var2, C var3, Class var4);

    public Class[] recognize(R recognize, C context, Class classOrIntf) {
        OBStager<R, O, C> builder = this.createBuilder(recognize, context, classOrIntf);
        return builder.types();
    }

    public Class[] recognize(R recognize, C context) {
        OBStager<R, O, C> builder = this.createBuilder(recognize, context);
        return builder.types();
    }

    public void addBuildListener(Class classOrIntf, OBListener listener) {
        this.blsSupport_.add(classOrIntf, listener, true);
    }

    public void addBuildListener(Class classOrIntf, OBListener listener, boolean subType) {
        this.blsSupport_.add(classOrIntf, listener, subType);
    }

    public boolean removeBuildListener(Class classOrIntf, OBListener listener) {
        return this.blsSupport_.remove(classOrIntf, listener);
    }

    public List<OBListener> getBuildListeners(Class clazz) {
        return this.blsSupport_.getBuildListeners(clazz);
    }

    public abstract List<OBRecognizer<R, O, C>> getRecognizers();

    public static class UnrecognizedTargetException
    extends OBException {
        UnrecognizedTargetException(String msg) {
            super(msg);
        }
    }

    class BuildListenerSupport {
        private ArrayList<BLS> buildListeners_ = new ArrayList();

        BuildListenerSupport() {
        }

        synchronized void add(Class clazz, OBListener listener, boolean subType) {
            if (this.getIndexOfListener(clazz, listener) >= 0) {
                throw new AssertionError((Object)("Duplicate listener. Already added " + clazz.getName()));
            }
            this.buildListeners_.add(new BLS(clazz, listener, subType));
        }

        int getIndexOfListener(Class c, OBListener l) {
            int sz = this.buildListeners_.size();
            for (int i = 0; i < sz; ++i) {
                BLS bls = this.buildListeners_.get(i);
                if (bls.cls != c || bls.listener != l) continue;
                return i;
            }
            return -1;
        }

        synchronized boolean remove(Class clazz, OBListener listener) {
            int i = this.getIndexOfListener(clazz, listener);
            if (i >= 0) {
                this.buildListeners_.remove(i);
                return true;
            }
            return false;
        }

        synchronized ArrayList<OBListener> getBuildListeners(Class profileClass) {
            ArrayList<OBListener> ret = new ArrayList<OBListener>();
            int sz = this.buildListeners_.size();
            for (int i = 0; i < sz; ++i) {
                BLS bls = this.buildListeners_.get(i);
                if (bls.subClass && bls.cls.isAssignableFrom(profileClass)) {
                    ret.add(bls.listener);
                    continue;
                }
                if (bls.cls != profileClass) continue;
                ret.add(bls.listener);
            }
            return ret;
        }
    }

    class BLS {
        Class cls;
        OBListener listener;
        boolean subClass;

        BLS(Class clazz, OBListener listener, boolean subClass) {
            this.cls = clazz;
            this.listener = listener;
            this.subClass = subClass;
        }
    }
}

